/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.nl.NVPair;

public class NetNMPAddr
extends NetProtocolAddr {
    public static final String NMP_PROTOCOL_PREFIX = "NMP";
    public static final String NMP_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=NMP))";
    private static final String[] NMP_ADDR_PARAM = new String[]{"SERVER", "PIPE"};
    private static final String[] NMP_ADDR_PARAM_LABEL = new String[]{"SNCMachine", "SNCPipe"};
    private int inValidField;

    public NetNMPAddr() {
        super(NMP_PROTOCOL_PREFIX, NMP_ADDR_FORMAT, NMP_ADDR_PARAM, NMP_ADDR_PARAM_LABEL);
    }

    public NetNMPAddr(NVPair protoAddr) {
        this();
        this.setAddr(protoAddr);
    }

    public boolean areDataValid() {
        this.devTrc("NetNMPAddr: areDataValid():");
        if (!this.netValidate.validateHostName(this.addrParamText[0])) {
            this.inValidField = 0;
            return false;
        }
        if (this.addrParamText[0].getText().length() > 0 && !this.netValidate.validateName(this.addrParamText[1])) {
            this.inValidField = 1;
            return false;
        }
        if (this.addrParamText[0].getText().length() == 0 && this.addrParamText[1].getText().length() > 0) {
            this.inValidField = 0;
            return false;
        }
        if (this.addrParamText[0].getText().length() > 0 && this.addrParamText[1].getText().length() == 0) {
            this.inValidField = 1;
            return false;
        }
        this.devTrc("NetNMPAddr: areDataValid(): true ");
        return true;
    }

    public void setFocus() {
        this.devTrc("NetNMPAddr: setFocus():");
        switch (this.inValidField) {
            case 0: {
                this.netValidate.showDialog(NMP_ADDR_PARAM[this.inValidField]);
                break;
            }
            case 1: {
                this.netValidate.showDialog(NMP_ADDR_PARAM[this.inValidField]);
                break;
            }
        }
        this.addrParamText[this.inValidField].selectAll();
        this.addrParamText[this.inValidField].requestFocus();
    }

    public String getProtocol() {
        return NMP_PROTOCOL_PREFIX;
    }

    public boolean sameEndpoint(NetProtocolAddr other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NetNMPAddr)) {
            return false;
        }
        String thisServer = this.addrParamText[0].getText().toUpperCase();
        String thatServer = ((NetNMPAddr)other).addrParamText[0].getText().toUpperCase();
        String thisPipe = this.addrParamText[1].getText().toUpperCase();
        String thatPipe = ((NetNMPAddr)other).addrParamText[1].getText().toUpperCase();
        return thisServer.equalsIgnoreCase(thatServer) && thisPipe.equalsIgnoreCase(thatPipe);
    }
}

