/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetNmService
extends NetLayout
implements ProfileCache,
ActionListener,
NetButtonListener {
    private static final String NM_DIR_PATH_PARAM = "names.directory_path";
    private static final String[] selectDefault = new String[]{"TNSNAMES", "ONAMES", "HOSTNAME"};
    private static final String[] availDefault = new String[]{"CDS", "NOVELL", "NIS"};
    private static final String[] buttonName = new String[]{"PFCaddButtonLabel", "PFCremoveButtonLabel", "PFCpromoteButtonLabel", "PFCdemoteButtonLabel"};
    private static final String[] NET_NM_DIR_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_NM_SERVICE_HELP_TOPIC = "TOPICprofNamingMethods";
    private LWList selectList;
    private LWList availList;
    private EwtContainer lpanel;
    private EwtContainer cpanel;
    private EwtContainer rpanel;
    private MarginBorder sharedBorderPixel;
    private LWButton[] button;
    private NLParamParser nlpa;
    private String[] netNmDirButton = new String[NET_NM_DIR_BUTTONS.length];
    private boolean changed;

    public NetNmService() {
        int i = 0;
        while (i < NET_NM_DIR_BUTTONS.length) {
            this.netNmDirButton[i] = this.netStrings.getString(NET_NM_DIR_BUTTONS[i]);
            ++i;
        }
        this.lpanel = new EwtContainer();
        this.lpanel.setLayout(new GridBagLayout());
        this.availList = new LWList(10, false);
        i = 0;
        while (i < availDefault.length) {
            this.availList.addItem(availDefault[i]);
            ++i;
        }
        this.constrain((Container)this.lpanel, (Component)new LWLabel(this.netStrings.getString("PFCavailableLabel")), 0, 0, 1, 1, 2, 10, 10.0, 0.0, 5, 5, 0, 5);
        this.constrain((Container)this.lpanel, (Component)this.availList, 0, 1, 1, 1, 2, 18, 10.0, 0.0, 5, 5, 0, 5);
        this.cpanel = new EwtContainer();
        this.cpanel.setLayout(new GridBagLayout());
        this.button = new LWButton[buttonName.length];
        i = 0;
        while (i < buttonName.length) {
            this.button[i] = new LWButton(this.netStrings.getString(buttonName[i]));
            this.constrain((Container)this.cpanel, (Component)this.button[i], 0, i, 1, 1, 10, 5, 0, 5, 2);
            this.button[i].addActionListener((ActionListener)this);
            ++i;
        }
        this.rpanel = new EwtContainer();
        this.rpanel.setLayout(new GridBagLayout());
        this.selectList = new LWList(10, false);
        i = 0;
        while (i < selectDefault.length) {
            this.selectList.addItem(selectDefault[i]);
            ++i;
        }
        this.constrain((Container)this.rpanel, (Component)new LWLabel(this.netStrings.getString("PFCselectedLabel")), 0, 0, 1, 1, 2, 10, 10.0, 0.0, 5, 5, 0, 5);
        this.constrain((Container)this.rpanel, (Component)this.selectList, 0, 1, 1, 1, 2, 18, 10.0, 0.0, 5, 5, 0, 5);
        this.constrain((Container)((Object)this), (Component)this.lpanel, 0, 0, 1, 1, 2, 13, 0.0, 0.0, 0, 0, 0, 0);
        this.constrain((Container)((Object)this), (Component)this.cpanel, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.constrain((Container)((Object)this), (Component)this.rpanel, 2, 0, 1, 1, 2, 17, 0.0, 0.0, 0, 0, 0, 0);
    }

    public NetNmService(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("NetNmService: setNLP():");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NetNmService: cacheIt():");
        NVPair nvpair = this.nlpa.getNLPListElement(NM_DIR_PATH_PARAM);
        int selectCount = this.selectList.getItemCount();
        if (nvpair != null) {
            if (selectCount == 0) {
                this.nlpa.removeNLPListElement(NM_DIR_PATH_PARAM);
            } else {
                this.cacheSelectList();
            }
        } else if (selectCount == selectDefault.length) {
            int i = 0;
            while (i < selectCount) {
                if (!this.selectList.getItem(i).equalsIgnoreCase(selectDefault[i])) break;
                ++i;
            }
            if (i < selectCount) {
                this.cacheSelectList();
            }
        } else if (selectCount > 0) {
            this.cacheSelectList();
        }
    }

    public void discard() {
        this.devTrc("NetNmService: discard():");
        this.changed = false;
        this.availList.removeAll();
        this.selectList.removeAll();
        int i = 0;
        while (i < selectDefault.length) {
            this.selectList.addItem(selectDefault[i]);
            ++i;
        }
        i = 0;
        while (i < availDefault.length) {
            this.availList.addItem(availDefault[i]);
            ++i;
        }
    }

    public void refresh() {
        this.devTrc("NetNmService: refresh():");
        NVPair nvpair = this.nlpa.getNLPListElement(NM_DIR_PATH_PARAM);
        this.makeAllNamingAvailable();
        if (nvpair != null) {
            int i = 0;
            while (i < nvpair.getListSize()) {
                NVPair nvelement = nvpair.getListElement(i);
                String s = nvelement.getAtom().toUpperCase();
                if (s.equals("NDS")) {
                    s = "NOVELL";
                }
                this.availList.remove(s);
                this.selectList.addItem(s);
                ++i;
            }
        } else {
            int i = 0;
            while (i < selectDefault.length) {
                this.availList.remove(selectDefault[i]);
                this.selectList.addItem(selectDefault[i]);
                ++i;
            }
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        NetStrings netStrings = new NetStrings();
        if (source instanceof LWButton) {
            this.changed = true;
            int j = 0;
            while (j < buttonName.length) {
                if (e.getActionCommand().compareTo(netStrings.getString(buttonName[j])) == 0) break;
                ++j;
            }
            switch (j) {
                case 0: {
                    int i = this.availList.getSelectedIndex();
                    if (i < 0) break;
                    String s = this.availList.getSelectedItem();
                    this.availList.remove(i);
                    this.selectList.addItem(s);
                    break;
                }
                case 1: {
                    int i = this.selectList.getSelectedIndex();
                    if (i < 0) break;
                    String s = this.selectList.getSelectedItem();
                    this.selectList.remove(i);
                    this.availList.addItem(s);
                    break;
                }
                case 3: {
                    int i = this.selectList.getSelectedIndex();
                    if (i < 0 || i >= this.selectList.getItemCount() - 1) break;
                    String s = this.selectList.getSelectedItem();
                    String s1 = this.selectList.getItem(i + 1);
                    this.selectList.replaceItem(s1, i);
                    this.selectList.replaceItem(s, i + 1);
                    this.selectList.deselect(i);
                    this.selectList.select(i + 1);
                    break;
                }
                case 2: {
                    int i = this.selectList.getSelectedIndex();
                    if (i <= 0) break;
                    String s = this.selectList.getSelectedItem();
                    String s1 = this.selectList.getItem(i - 1);
                    this.selectList.replaceItem(s1, i);
                    this.selectList.replaceItem(s, i - 1);
                    this.selectList.deselect(i);
                    this.selectList.select(i - 1);
                    break;
                }
            }
        }
    }

    public NetButton createNetButton() {
        this.devTrc("NetNmService: createNetButton()");
        NetButton netButton = new NetButton(this.netNmDirButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetNmService: buttonPushed()");
        if (label.equalsIgnoreCase(this.netNmDirButton[0])) {
            this.devTrc("NetNmService: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICprofNamingMethods");
        }
    }

    private void makeAllNamingAvailable() {
        this.devTrc("NetNmService: makeAllNamingAvailable():");
        this.availList.removeAll();
        this.selectList.removeAll();
        int i = 0;
        while (i < selectDefault.length) {
            this.availList.addItem(selectDefault[i]);
            ++i;
        }
        i = 0;
        while (i < availDefault.length) {
            this.availList.addItem(availDefault[i]);
            ++i;
        }
    }

    private void cacheSelectList() {
        int i;
        boolean mustCache = false;
        this.devTrc("NetNmService: cacheSelectList():");
        int selectCount = this.selectList.getItemCount();
        if (selectCount != selectDefault.length) {
            mustCache = true;
        }
        if (!mustCache) {
            i = 0;
            while (i < selectCount) {
                if (this.selectList.getItem(i).compareTo(selectDefault[i]) != 0) {
                    mustCache = true;
                    break;
                }
                ++i;
            }
        }
        this.devTrc("NetNmService: cacheSelectList():" + mustCache);
        if (mustCache) {
            StringBuffer sb = new StringBuffer("=(");
            i = 0;
            while (i < selectCount) {
                String param = this.selectList.getItem(i);
                this.devTrc(param);
                if (param.equals("NOVELL")) {
                    param = "NDS";
                }
                sb.append(param);
                if (++i >= selectCount) continue;
                sb.append(", ");
            }
            sb.append(")");
            this.devTrc("NetNmService: cacheSelectList(): " + sb);
            try {
                this.nlpa.addNLPListElement(NM_DIR_PATH_PARAM + sb);
                this.changed = false;
            }
            catch (NLException nLException) {
                this.devTrc("    exception");
            }
        } else {
            this.nlpa.removeNLPListElement(NM_DIR_PATH_PARAM);
        }
    }
}

