/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetONames
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private static final String[] NAMES_PARAMS = new String[]{"names.default_domain", "names.initial_retry_timeout", "names.max_open_connections", "names.message_pool_start_size", "names.request_retries"};
    private static final String[] NAMES_PARAMS_LABELS = new String[]{"PFConamesdefaultDomain", "PFConamesRetryTimeout", "PFConamesMaxCon", "PFConamesPoolSize", "PFConamesRequestRetry"};
    private static final String[] NAMES_PARAM_DEFAULT = new String[]{"", "15", "3", "10", "1"};
    private static final int[] NAMES_PARAM_MIN;
    private static final int[] NAMES_PARAM_MAX;
    private static final String[] NAMES_PANELS;
    private static final int[] NAMES_PARAM_TO_PANELS;
    private static final String[] NET_NM_PARAM_BUTTONS;
    private final NetStrings netStrings = new NetStrings();
    private final String NET_NAME_HELP_TOPIC = "TOPICprofNamingONames";
    private LWTextField[] paramText;
    private MarginBorder sharedBorderPixel;
    private NLParamParser nlpa;
    private EwtContainer[] namesPanel;
    private String[] netNmParamButton = new String[NET_NM_PARAM_BUTTONS.length];
    private String[] paramLabel;
    private int invalidField;

    public NetONames() {
        int i = 0;
        while (i < NET_NM_PARAM_BUTTONS.length) {
            this.netNmParamButton[i] = this.netStrings.getString(NET_NM_PARAM_BUTTONS[i]);
            ++i;
        }
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.namesPanel = new EwtContainer[NAMES_PARAMS.length];
        this.paramText = new LWTextField[NAMES_PARAMS.length];
        this.paramLabel = new String[NAMES_PARAMS.length];
        i = 0;
        while (i < NAMES_PANELS.length) {
            GroupBoxBorder groupBorder = new GroupBoxBorder(this.netStrings.getString(NAMES_PANELS[i]), InsetFramePainter.getFramePainter(), 2);
            this.namesPanel[i] = new EwtContainer();
            this.namesPanel[i].setLayout(new GridBagLayout());
            this.namesPanel[i].setBorder((Border)groupBorder);
            this.constrain((Container)((Object)this), (Component)this.namesPanel[i], 0, i, 1, 1, 5, 5, 5, 5, 2);
            int k = 0;
            int j = 0;
            while (j < NAMES_PARAMS.length) {
                if (NAMES_PARAM_TO_PANELS[j] == i) {
                    this.paramText[j] = j == 0 ? new LWTextField(NAMES_PARAM_DEFAULT[j], 15) : new LWTextField(NAMES_PARAM_DEFAULT[j], 5);
                    this.paramLabel[j] = this.netStrings.getString(NAMES_PARAMS_LABELS[j]);
                    this.constrain((Container)this.namesPanel[i], (Component)new LWLabel(this.paramLabel[j]), 0, k, 1, 1, 5, 5, 5, 5);
                    this.constrain((Container)this.namesPanel[i], (Component)this.paramText[j], 1, k, 1, 1, 5, 5, 5, 5);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public NetONames(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("NetONames: setNLP():");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NetONames: cacheIt():");
        int i = 0;
        while (i < NAMES_PARAMS.length) {
            String s = this.paramText[i].getText();
            if (s.length() > 0) {
                if (s.equalsIgnoreCase(NAMES_PARAM_DEFAULT[i])) {
                    this.nlpa.removeNLPListElement(NAMES_PARAMS[i]);
                } else {
                    try {
                        this.nlpa.addNLPListElement(String.valueOf(NAMES_PARAMS[i]) + "=" + s);
                    }
                    catch (NLException nLException) {}
                }
            } else {
                this.nlpa.removeNLPListElement(NAMES_PARAMS[i]);
            }
            ++i;
        }
    }

    public void discard() {
        this.devTrc("NetONames: discard():");
        int i = 0;
        while (i < NAMES_PARAMS.length) {
            this.paramText[i].setText(NAMES_PARAM_DEFAULT[i]);
            ++i;
        }
    }

    public void refresh() {
        this.devTrc("NetONames: refresh():");
        int i = 0;
        while (i < NAMES_PARAMS.length) {
            String s;
            NVPair nvpair = this.nlpa.getNLPListElement(NAMES_PARAMS[i]);
            if (nvpair != null && (s = nvpair.getAtom()) != null) {
                this.paramText[i].setText(s);
            }
            ++i;
        }
    }

    public boolean hasChanged() {
        boolean rc = false;
        this.devTrc("NetONames: hasChanged():");
        int i = 0;
        while (i < NAMES_PARAMS.length) {
            NVPair nvpair = this.nlpa.getNLPListElement(NAMES_PARAMS[i]);
            if (nvpair != null) {
                if (!this.paramText[i].getText().equalsIgnoreCase(nvpair.getAtom())) {
                    rc = true;
                    break;
                }
            } else if (!this.paramText[i].getText().equalsIgnoreCase(NAMES_PARAM_DEFAULT[i])) {
                rc = true;
                break;
            }
            ++i;
        }
        this.devTrc("NetONames: hasChanged(): " + i + " " + rc);
        return rc;
    }

    public boolean areDataValid() {
        boolean rc = true;
        int i = 0;
        while (i < NAMES_PARAMS.length) {
            rc = i != 0 ? this.netValidate.validateNumber(this.paramText[i], NAMES_PARAM_MIN[i], NAMES_PARAM_MAX[i]) : this.netValidate.validateHostName(this.paramText[i]);
            if (!rc) break;
            ++i;
        }
        this.invalidField = !rc ? i : 0;
        return rc;
    }

    public void setFocus() {
        if (this.invalidField == 0) {
            this.netValidate.showDialog(this.paramLabel[this.invalidField]);
        } else {
            this.netValidate.showDialog(this.paramLabel[this.invalidField], NAMES_PARAM_MIN[this.invalidField], NAMES_PARAM_MAX[this.invalidField]);
        }
        this.paramText[this.invalidField].requestFocus();
        this.paramText[this.invalidField].selectAll();
    }

    public NetButton createNetButton() {
        this.devTrc("NetONames: createNetButton()");
        NetButton netButton = new NetButton(this.netNmParamButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetONames: buttonPushed()");
        if (label.equalsIgnoreCase(this.netNmParamButton[0])) {
            this.devTrc("NetONames: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICprofNamingONames");
        }
    }

    public String getDefaultDomain() {
        return this.paramText[0].getText();
    }

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 3;
        nArray[4] = 1;
        NAMES_PARAM_MIN = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 600;
        nArray2[2] = 64;
        nArray2[3] = 256;
        nArray2[4] = 5;
        NAMES_PARAM_MAX = nArray2;
        NAMES_PANELS = new String[]{"PFConamesBorderLabel1", "PFConamesBorderLabel2", "PFConamesBorderLabel3"};
        int[] nArray3 = new int[5];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 2;
        nArray3[4] = 1;
        NAMES_PARAM_TO_PANELS = nArray3;
        NET_NM_PARAM_BUTTONS = new String[]{"PFChelp"};
    }
}

