/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import oracle.ewt.event.Cancelable;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetAddr;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class NetONmServer
extends NetLayout
implements ProfileCache,
NetButtonListener,
TabPanelListener {
    private static final String[] NET_ADDR_BUTTONS = new String[]{"PFCnew", "PFCdelete", "PFChelp"};
    private static final String NAMES_PARAM = "names.preferred_servers";
    private static final String _desc_list = "DESCRIPTION_LIST";
    private static final String _desc = "DESCRIPTION";
    private static final String _addr_list = "ADDRESS_LIST";
    private static final String _addr = "ADDRESS";
    private static final String PANEL_LABEL_PREFIX = "PFCpreferServer";
    private static final String paramFormat = "(ADDRESS_LIST=)";
    private static final String defaultAddr = "(Address=(protocol=tcp))";
    private String[] buttonLabels;
    private String panelNamePrefix;
    private final NetStrings netStrings = new NetStrings();
    private final String NET_ONAME_SERVER_HELP_TOPIC = "TOPICprofPrefONamesServer";
    private NetButton buttonPanel;
    private TabPanel ONStabPanel;
    private MultiLineLabel mainMsg;
    private NVFactory nvfactory = new NVFactory();
    private NLParamParser nlpa;
    private NetAddr currAddr;
    private boolean changed;
    private boolean deletingPage = false;
    private int invalidAddr;

    public NetONmServer() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 20, 10));
        this.mainMsg = new MultiLineLabel(WordWrapper.getTextWrapper(), this.netStrings.getString("PFCzeroONames"));
        this.mainMsg.setAlignment(1);
        this.mainMsg.setPreferredAspectRatio(10.0f);
        this.buttonLabels = new String[NET_ADDR_BUTTONS.length];
        int i = 0;
        while (i < NET_ADDR_BUTTONS.length) {
            this.buttonLabels[i] = this.netStrings.getString(NET_ADDR_BUTTONS[i]);
            ++i;
        }
        this.panelNamePrefix = this.netStrings.getString(PANEL_LABEL_PREFIX);
        this.buttonPanel = new NetButton(this.buttonLabels);
        this.buttonPanel.addNetButtonListener(this);
        ((Container)((Object)this)).add((Component)this.mainMsg, "Center");
        ((Container)((Object)this)).add((Component)((Object)this.buttonPanel), "South");
    }

    public NetONmServer(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("NetONmServer: setNLP():");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        NVPair newParam = this.nvfactory.createNVPair(paramFormat);
        this.devTrc("NetONmServer: cacheIt():");
        if (this.ONStabPanel != null) {
            int i = 0;
            while (i < this.ONStabPanel.getPageCount()) {
                TabPanelPage tpp = this.ONStabPanel.getPage(i);
                NVPair addr = ((NetAddr)((Object)tpp.getContent())).getAddr();
                if (addr != null) {
                    this.devTrc("NetONmServer: cacheIt():" + addr.toString());
                    newParam.addListElement(addr);
                }
                ++i;
            }
        }
        if (newParam.getListSize() > 0) {
            this.devTrc("NetONmServer: cacheIt(): adding address list.");
            try {
                this.nlpa.addNLPListElement("names.preferred_servers=" + newParam.toString());
            }
            catch (NLException nLException) {}
        } else {
            this.devTrc("NetONmServer: cacheIt(): removing names.preferred_servers");
            this.nlpa.removeNLPListElement(NAMES_PARAM);
        }
    }

    public void discard() {
        this.devTrc("NetONmServer: discard():");
        this.refresh();
    }

    public void refresh() {
        String addrType;
        NVPair nvAddr = this.nlpa.getNLPListElement(NAMES_PARAM);
        this.devTrc("NetONmServer: refresh():");
        this.removeTabPanel();
        this.devTrc("NetONmServer: refresh():removed all previous pages.");
        this.changed = false;
        if (nvAddr != null && !(addrType = (nvAddr = nvAddr.getListElement(0)).getName()).equalsIgnoreCase(_desc_list) && !addrType.equalsIgnoreCase(_desc)) {
            if (addrType.equalsIgnoreCase(_addr_list)) {
                this.doAddrList(nvAddr);
            } else {
                this.addAddrPanel(nvAddr);
            }
        }
    }

    public boolean hasChanged() {
        if (!this.changed && this.ONStabPanel != null) {
            this.devTrc("NetONmServer: hasChanged():");
            int i = 0;
            while (i < this.ONStabPanel.getPageCount()) {
                TabPanelPage tpp = this.ONStabPanel.getPage(i);
                this.changed = ((NetAddr)((Object)tpp.getContent())).hasChanged();
                if (this.changed) break;
                ++i;
            }
        }
        return this.changed;
    }

    public boolean areDataValid() {
        boolean rc = true;
        if (this.ONStabPanel == null) {
            return true;
        }
        int i = 0;
        while (i < this.ONStabPanel.getPageCount()) {
            this.devTrc("NetONmServer: areDataValid() " + i);
            TabPanelPage tpp = this.ONStabPanel.getPage(i);
            rc = ((NetAddr)((Object)tpp.getContent())).areDataValid();
            if (!rc) {
                this.devTrc("NetONmServer: areDataValid(): " + i + " " + rc);
                this.invalidAddr = i;
                break;
            }
            ++i;
        }
        return rc;
    }

    public void setFocus() {
        if (this.ONStabPanel != null && this.invalidAddr < this.ONStabPanel.getPageCount()) {
            TabPanelPage tpp = this.ONStabPanel.getPage(this.invalidAddr);
            tpp.setSelected(true);
            ((NetAddr)((Object)tpp.getContent())).setFocus();
        }
    }

    public void buttonPushed(String label) {
        this.devTrc("NetONmServer: buttonPushed()");
        this.changed = true;
        int i = 0;
        while (i < NET_ADDR_BUTTONS.length) {
            if (label.compareTo(this.buttonLabels[i]) == 0) break;
            ++i;
        }
        switch (i) {
            case 0: {
                if (this.ONStabPanel != null && this.ONStabPanel.getPageCount() > 0 && !this.areDataValid()) {
                    this.setFocus();
                    break;
                }
                TabPanelPage newTpp = this.addAddrPanel(null);
                newTpp.setSelected(true);
                break;
            }
            case 1: {
                this.deletingPage = true;
                if (this.ONStabPanel != null) {
                    if (this.ONStabPanel.getPageCount() > 1) {
                        this.deleteAddrPanel();
                    } else {
                        this.removeTabPanel();
                    }
                }
                this.deletingPage = false;
                break;
            }
            case 2: {
                this.devTrc("NetONmServer: buttonPushed(): do help.");
                NetHelp netHelp = NetUtils.getHelpContext();
                netHelp.show("TOPICprofPrefONamesServer");
                break;
            }
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent e) {
        TabPanelPage currentPage = e.getPage();
        if (currentPage != null) {
            this.currAddr = (NetAddr)((Object)currentPage.getContent());
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent e) {
        if (!this.deletingPage && this.currAddr != null && !this.currAddr.areDataValid()) {
            ((Cancelable)e).cancel();
            this.currAddr.setFocus();
        }
    }

    private void addTabPanel() {
        this.ONStabPanel = new TabPanel();
        this.ONStabPanel.addTabPanelListener((TabPanelListener)this);
        ((Container)((Object)this)).remove((Component)this.mainMsg);
        ((Container)((Object)this)).add((Component)this.ONStabPanel, "Center");
    }

    private void removeTabPanel() {
        if (this.ONStabPanel != null) {
            ((Container)((Object)this)).remove((Component)this.ONStabPanel);
        }
        this.ONStabPanel = null;
        this.currAddr = null;
        ((Container)((Object)this)).add((Component)this.mainMsg, "Center");
        ((Container)((Object)this)).validate();
    }

    private void deleteAddrPanel() {
        if (this.ONStabPanel == null) {
            return;
        }
        if (this.ONStabPanel.getPageCount() == 1) {
            this.removeTabPanel();
        } else {
            TabPanelPage tpp2delete = this.ONStabPanel.getSelectedPage();
            int i = tpp2delete.getIndex();
            this.ONStabPanel.removePage(tpp2delete);
            while (i < this.ONStabPanel.getPageCount()) {
                TabPanelPage tpp = this.ONStabPanel.getPage(i);
                tpp.setLabel(String.valueOf(this.panelNamePrefix) + (i + 1));
                ++i;
            }
        }
    }

    private void doDescList(NVPair nvAddr) {
        int i = 0;
        while (i < nvAddr.getListSize()) {
            NVPair tmpNVAddr = nvAddr.getListElement(i);
            this.addAddrPanel(tmpNVAddr);
            ++i;
        }
    }

    private void doDesc(NVPair nvAddr) {
        int i = 0;
        while (i < nvAddr.getListSize()) {
            NVPair tmpNVAddr = nvAddr.getListElement(i);
            this.addAddrPanel(tmpNVAddr);
            ++i;
        }
    }

    private void doAddrList(NVPair nvAddr) {
        int i = 0;
        while (i < nvAddr.getListSize()) {
            NVPair tmpNVAddr = nvAddr.getListElement(i);
            this.addAddrPanel(tmpNVAddr);
            ++i;
        }
    }

    private TabPanelPage addAddrPanel(NVPair nvAddr) {
        if (this.ONStabPanel == null) {
            this.addTabPanel();
        }
        NetAddr addrPanel = new NetAddr(nvAddr);
        TabPanelPage tpp = this.ONStabPanel.addPage("", (Component)((Object)addrPanel));
        int i = tpp.getIndex();
        this.devTrc("NetONmServer: addAddrPanel():" + i);
        tpp.setLabel(String.valueOf(this.panelNamePrefix) + (i + 1));
        addrPanel.setAppEnv(this.netApp);
        ((Container)((Object)this)).validate();
        this.ONStabPanel.validate();
        return tpp;
    }
}

