/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.NetPStack;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetPStack
extends NetLayout {
    private final NVFactory factory = new NVFactory();
    private final String prefix = "(PROTOCOL_STACK=(PRESENTATION=";
    private final String middle = ")(SESSION=";
    private final String suffix = "))";
    private final String[] allPres = new String[]{"TTC", "GIOP"};
    private final String[] allSess = new String[]{"NS", "RAW"};
    private final NetStrings ns = new NetStrings();
    private final String sessLabelString = this.ns.getString("PFCNPSsession");
    private final String presLabelString = this.ns.getString("PFCNPSpresentation");
    private final String customString = this.ns.getString("PFCNPScustom");
    private final String customButtonString = this.ns.getString("PFCNPScustomize");
    private final String net8String = this.ns.getString("PFCNPSnet8");
    private final String iiopString = this.ns.getString("PFCNPSiiop");
    private Hashtable comboDict = new Hashtable(5);
    private String[] defaultCombo;
    private LWChoice presChoice;
    private LWButton customButton;
    private CustomDialog customDialog;
    private NVPair currStack;
    private boolean changed;
    private boolean editable = true;
    protected String[] initialCustomSetting;

    public NetPStack() {
        this(null);
    }

    public NetPStack(NVPair pStack) {
        this.comboDict.put(this.net8String, new String[]{"TTC", "NS"});
        this.comboDict.put(this.iiopString, new String[]{"GIOP", "RAW"});
        this.defaultCombo = (String[])this.comboDict.get(this.net8String);
        this.presChoice = new LWChoice();
        Enumeration enumeration = this.comboDict.keys();
        while (enumeration.hasMoreElements()) {
            this.presChoice.add((String)enumeration.nextElement());
        }
        this.presChoice.add(this.customString);
        this.presChoice.select(0);
        this.presChoice.addItemListener((ItemListener)new 1());
        this.customButton = new LWButton(this.customButtonString);
        this.customButton.addActionListener((ActionListener)new 2());
        this.customButton.setEnabled(false);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.ipadx = 20;
        ((Container)((Object)this)).add((Component)this.presChoice, gbc);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.ipadx = 10;
        gbc.insets.left = 5;
        ((Container)((Object)this)).add((Component)this.customButton, gbc);
        if (pStack == null) {
            pStack = this.factory.createNVPair("(PROTOCOL_STACK=(PRESENTATION=" + this.defaultCombo[0] + ")(SESSION=" + this.defaultCombo[1] + "))");
        }
        this.setPStack(pStack);
    }

    public void setPStack(NVPair pStack) {
        if (pStack == null) {
            return;
        }
        this.currStack = pStack;
        NVNavigator nav = new NVNavigator();
        String[] combo = new String[2];
        try {
            combo[0] = nav.findNVPairRecurse(pStack, "PRESENTATION").getAtom();
            combo[1] = nav.findNVPairRecurse(pStack, "SESSION").getAtom();
        }
        catch (NullPointerException nullPointerException) {}
        if (combo[0] == null || combo[1] == null) {
            combo = this.defaultCombo;
        }
        this.presChoice.select(this.customString);
        Enumeration e = this.comboDict.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] dictCombo = (String[])this.comboDict.get(name);
            if (!combo[0].equals(dictCombo[0]) || !combo[1].equals(dictCombo[1])) continue;
            this.presChoice.select(name);
        }
        if (this.presChoice.getSelectedItem().equals(this.customString)) {
            this.customButton.setEnabled(true);
            if (this.customDialog != null) {
                this.customDialog.setSelection(combo);
            } else {
                this.initialCustomSetting = combo;
            }
        }
    }

    public NVPair getPStack() {
        if (this.changed) {
            String name = this.presChoice.getSelectedItem();
            String[] combo = (String[])this.comboDict.get(name);
            if (combo == null) {
                combo = this.customDialog != null ? this.customDialog.getSelection() : this.defaultCombo;
            }
            this.currStack = this.factory.createNVPair("(PROTOCOL_STACK=(PRESENTATION=" + combo[0] + ")(SESSION=" + combo[1] + "))");
        }
        return this.currStack;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public synchronized void setEditable(boolean b) {
        this.editable = b;
        Component[] comps = ((Container)((Object)this)).getComponents();
        int i = 0;
        while (i < comps.length) {
            comps[i].setEnabled(b);
            ++i;
        }
        if (this.customButton.isEnabled() && !this.presChoice.getSelectedItem().equals(this.customString)) {
            this.customButton.setEnabled(false);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void discard() {
        this.setPStack(this.currStack);
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        return this.customDialog != null && this.customDialog.hasChanged();
    }

    static /* synthetic */ NetStrings access$6(NetPStack $0) {
        return $0.ns;
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (e.getItem().equals(NetPStack.this.customString)) {
                    NetPStack.this.customButton.setEnabled(true);
                    if (NetPStack.this.customDialog == null) {
                        NetPStack.this.customDialog = new CustomDialog((Frame)NetPStack.this.getFrame());
                    }
                    NetPStack.this.customDialog.runDialog();
                    if (NetPStack.this.customDialog.hasChanged()) {
                        NetPStack.this.changed = true;
                    }
                } else {
                    NetPStack.this.customButton.setEnabled(false);
                    NetPStack.this.changed = true;
                }
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (NetPStack.this.customDialog == null) {
                NetPStack.this.customDialog = new CustomDialog((Frame)NetPStack.this.getFrame());
            }
            NetPStack.this.customDialog.runDialog();
            if (NetPStack.this.customDialog.hasChanged()) {
                NetPStack.this.changed = true;
            }
        }

        /* synthetic */ 2() {
        }
    }

    private class CustomDialog
    extends BufferedDialog
    implements ActionListener {
        private final int DLG_WIDTH = 300;
        private final int DLG_HEIGHT = 150;
        private LWLabel presLabel;
        private LWLabel sessLabel;
        private LWChoice presChoice;
        private LWChoice sessChoice;
        private LWButton okButton;
        private LWButton cancelButton;
        private LWButton helpButton;
        private final String okButtonString = NetPStack.access$6(NetPStack.this).getString("PFCNPSok");
        private final String cancelButtonString = NetPStack.access$6(NetPStack.this).getString("PFCNPScancel");
        private final String helpButtonString = NetPStack.access$6(NetPStack.this).getString("PFChelp");
        private final String dialogTitleString = NetPStack.access$6(NetPStack.this).getString("PFCNPSdialogTitle");
        private final String helpTopicString = "TOPICprofPStack";
        private int previousPres;
        private int previousSess;

        CustomDialog(Frame fr) {
            super(fr, true);
            NetPStack.this = NetPStack.this;
            this.presLabel = new LWLabel(NetPStack.this.presLabelString);
            this.sessLabel = new LWLabel(NetPStack.this.sessLabelString);
            3 il = new 3(this);
            this.presChoice = new LWChoice();
            int i = 0;
            while (i < NetPStack.this.allPres.length) {
                this.presChoice.addItem(NetPStack.this.allPres[i]);
                ++i;
            }
            this.presChoice.select(0);
            this.presChoice.addItemListener((ItemListener)il);
            this.sessChoice = new LWChoice();
            int i2 = 0;
            while (i2 < NetPStack.this.allSess.length) {
                this.sessChoice.addItem(NetPStack.this.allSess[i2]);
                ++i2;
            }
            this.sessChoice.select(0);
            this.sessChoice.addItemListener((ItemListener)il);
            this.okButton = new LWButton(this.okButtonString);
            this.okButton.setActionCommand("OK");
            this.okButton.addActionListener((ActionListener)this);
            this.okButton.setLeftmost(true);
            this.cancelButton = new LWButton(this.cancelButtonString);
            this.cancelButton.setActionCommand("CANCEL");
            this.cancelButton.addActionListener((ActionListener)this);
            this.cancelButton.setRightmost(true);
            this.helpButton = new LWButton(this.helpButtonString);
            this.helpButton.setActionCommand("HELP");
            this.helpButton.addActionListener((ActionListener)this);
            this.helpButton.setLeftmost(true);
            this.helpButton.setRightmost(true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets.top = 10;
            gbc.insets.left = 10;
            ((Container)((Object)this)).add((Component)this.presLabel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets.top = 0;
            ((Container)((Object)this)).add((Component)this.sessLabel, gbc);
            gbc.weightx = 3.0;
            gbc.fill = 2;
            gbc.anchor = 13;
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.insets.left = 5;
            gbc.insets.top = 10;
            gbc.insets.right = 10;
            ((Container)((Object)this)).add((Component)this.presChoice, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets.top = 0;
            ((Container)((Object)this)).add((Component)this.sessChoice, gbc);
            EwtContainer buttonPanel = new EwtContainer();
            buttonPanel.setLayout(new GridBagLayout());
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 10;
            gbc.insets.top = 5;
            gbc.insets.bottom = 10;
            gbc.insets.right = 0;
            gbc.insets.left = 0;
            ((Container)((Object)this)).add((Component)buttonPanel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.insets.top = 0;
            gbc.insets.bottom = 0;
            gbc.insets.left = 10;
            gbc.insets.right = 0;
            buttonPanel.add((Component)this.helpButton, gbc);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            gbc.insets.right = 0;
            gbc.insets.left = 0;
            gbc.anchor = 13;
            buttonPanel.add((Component)this.okButton, gbc);
            ++gbc.gridx;
            gbc.insets.left = 3;
            gbc.insets.right = 10;
            buttonPanel.add((Component)this.cancelButton, gbc);
            ((Dialog)((Object)this)).setTitle(this.dialogTitleString);
            if (NetPStack.this.initialCustomSetting != null) {
                this.setSelection(NetPStack.this.initialCustomSetting);
                NetPStack.this.initialCustomSetting = null;
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("HELP")) {
                NetUtils.getHelpContext().show("TOPICprofPStack");
            } else if (e.getActionCommand().equals("CANCEL")) {
                ((Component)((Object)this)).setVisible(false);
                NetPStack.this.changed = false;
                this.presChoice.select(this.previousPres);
                this.sessChoice.select(this.previousSess);
            } else {
                ((Component)((Object)this)).setVisible(false);
                NetPStack.this.changed = true;
            }
        }

        public void runDialog() {
            this.previousPres = this.presChoice.getSelectedIndex();
            this.previousSess = this.sessChoice.getSelectedIndex();
            ((Component)((Object)this)).setSize(300, 150);
            Rectangle rect = NetPStack.this.getFrame().getBounds();
            ((Component)((Object)this)).setLocation(rect.x + rect.width / 2 - 150, rect.y + rect.height / 2 - 75);
            ((Component)((Object)this)).setVisible(true);
        }

        public boolean hasChanged() {
            return NetPStack.this.changed;
        }

        public void setSelection(String[] combo) {
            if (combo == null || combo[0] == null || combo[1] == null) {
                return;
            }
            this.presChoice.select(combo[0]);
            this.sessChoice.select(combo[1]);
        }

        public String[] getSelection() {
            return new String[]{this.presChoice.getSelectedItem(), this.sessChoice.getSelectedItem()};
        }

        static /* synthetic */ NetPStack access$0(CustomDialog $0) {
            return $0.NetPStack.this;
        }
    }
}

