/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWChoice;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetGeneral;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.NetName;
import oracle.net.asst.profile.NetONmServer;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.NetANO;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetProfile
extends NetLayout
implements ItemListener {
    private String[] category;
    private EwtContainer mainPanel;
    private BufferedFrame frame;
    private CardLayout cardLayout;
    private MarginBorder sharedBorderPixel;
    private ProfileCache[] categoryPanel;
    private String[] categoryLabel;
    private LWChoice choice;
    private NLParamParser nlpa;
    private int currentCategory;

    public NetProfile() {
        try {
            try {
                boolean enableANO = false;
                NetProperties props = new NetProperties();
                String inst = props.getProperty("INSTALLEDCOMPONENTS");
                if (inst == null) {
                    inst = props.getProperty("InstalledComponents");
                }
                if (inst == null) {
                    inst = props.getProperty("installedcomponents");
                }
                if (inst != null) {
                    StringTokenizer st = new StringTokenizer(inst, ", ", false);
                    while (st.hasMoreTokens()) {
                        if (!st.nextToken().equalsIgnoreCase("ANO")) continue;
                        enableANO = true;
                        break;
                    }
                    this.category = enableANO ? new String[4] : new String[3];
                } else {
                    this.category = new String[4];
                }
            }
            catch (IOException iOException) {
                this.category = new String[4];
            }
            Object var2_5 = null;
            this.category[0] = "PFCcategoryNaming";
            this.category[1] = "PFCcategoryGeneral";
            this.category[2] = "PFCcategoryONS";
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.category[0] = "PFCcategoryNaming";
            this.category[1] = "PFCcategoryGeneral";
            this.category[2] = "PFCcategoryONS";
            if (this.category.length == 4) {
                this.category[3] = "PFCcategoryANO";
            }
            throw throwable;
        }
        if (this.category.length == 4) {
            this.category[3] = "PFCcategoryANO";
        }
        this.setTrace();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.sharedBorderPixel = new MarginBorder(8, 8, 8, 8);
        NetStrings netStrings = new NetStrings();
        this.choice = new LWChoice();
        int i = 0;
        while (i < this.category.length) {
            this.choice.addItem(netStrings.getString(this.category[i]));
            ++i;
        }
        this.choice.addItemListener((ItemListener)this);
        this.constrain((Container)((Object)this), (Component)this.choice, 0, 0, 1, 1, 0, 10, 0, 0);
        this.cardLayout = new CardLayout();
        this.mainPanel = new EwtContainer();
        this.mainPanel.setLayout(this.cardLayout);
        this.mainPanel.setBorder((Border)this.sharedBorderPixel);
        this.categoryPanel = new ProfileCache[this.category.length];
        this.categoryLabel = new String[this.category.length];
        this.categoryPanel[0] = new NetName();
        this.categoryPanel[1] = new NetGeneral();
        this.categoryPanel[2] = new NetONmServer();
        if (this.categoryPanel.length == 4) {
            this.categoryPanel[3] = new NetANO();
        }
        int i2 = 0;
        while (i2 < this.category.length) {
            this.categoryLabel[i2] = netStrings.getString(this.category[i2]);
            this.mainPanel.add(this.categoryLabel[i2], (Component)((EwtContainer)this.categoryPanel[i2]));
            ++i2;
        }
        this.constrain((Container)((Object)this), (Component)this.mainPanel, 0, 1, 1, 1);
        this.currentCategory = 0;
    }

    public NetProfile(String filename) throws IOException, NLException {
        this();
        this.activate(filename);
    }

    public boolean hasChanged() {
        boolean rc = false;
        int i = 0;
        while (i < this.category.length) {
            rc = this.categoryPanel[i].hasChanged();
            if (rc) break;
            ++i;
        }
        this.devTrc("NetProfile: hasChanged(): " + i + " " + rc);
        return rc;
    }

    public void activate(String filename) throws FileNotFoundException, IOException, NLException {
        this.devTrc("NetProfile: activate():" + filename);
        try {
            this.nlpa = new NLParamParser(filename);
        }
        catch (FileNotFoundException e) {
            this.devTrc("NetProfile: activate():" + this.nlpa.toString());
            throw e;
        }
        catch (IOException e) {
            this.devTrc("NetProfile: activate(): IO Exception");
            throw e;
        }
        catch (NLException e) {
            this.devTrc("NetProfile: activate(): NL Exception");
            throw e;
        }
        int i = 0;
        while (i < this.category.length) {
            this.categoryPanel[i].setNLP(this.nlpa);
            ++i;
        }
        i = 0;
        while (i < this.category.length) {
            this.categoryPanel[i].refresh();
            ++i;
        }
    }

    public boolean Comp_file_has_Comments() {
        return this.nlpa.fileHasComments();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof LWChoice) {
            this.devTrc("NetProfile: itemStateChanged(): validating " + this.currentCategory);
            if (this.categoryPanel[this.currentCategory].areDataValid()) {
                String label = e.getItem().toString();
                this.currentCategory = this.getCategoryIndex(label);
                this.cardLayout.show((Container)this.mainPanel, label);
            } else {
                this.choice.select(this.currentCategory);
                this.categoryPanel[this.currentCategory].setFocus();
            }
            this.devTrc("NetProfile: itemStateChanged(): currentCategory=" + this.currentCategory);
        }
    }

    public void discard() {
        this.devTrc("NetProfile: discard():");
        this.nlpa.removeNLPAllElements();
        int i = 0;
        while (i < this.category.length) {
            this.categoryPanel[i].refresh();
            ++i;
        }
    }

    public boolean save(String fileName) {
        this.devTrc("NetProfile: save():" + fileName);
        if (!this.areDataValid()) {
            return false;
        }
        this.checkSave();
        int i = 0;
        while (i < this.category.length) {
            this.categoryPanel[i].cacheIt();
            ++i;
        }
        try {
            this.nlpa.saveNLParams(fileName);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void setAppEnv(WebApplication w) {
        this.devTrc("NetProfile: setAppEnv():");
        this.frame = (BufferedFrame)w.getFrame();
        int i = 0;
        while (i < this.category.length) {
            ((NetLayout)((Object)this.categoryPanel[i])).setAppEnv(w);
            ++i;
        }
    }

    public boolean areDataValid() {
        this.devTrc("NetProfile: areDataValid():");
        boolean rc = true;
        int i = 0;
        while (i < this.category.length) {
            rc = this.categoryPanel[i].areDataValid();
            if (!rc) {
                this.currentCategory = i;
                this.choice.select(this.currentCategory);
                this.cardLayout.show((Container)this.mainPanel, this.categoryLabel[this.currentCategory]);
                this.categoryPanel[this.currentCategory].setFocus();
                break;
            }
            ++i;
        }
        return rc;
    }

    public void checkSave() {
    }

    public String getDefaultDomain() {
        return ((NetName)this.categoryPanel[0]).getDefaultDomain();
    }

    private int getCategoryIndex(String label) {
        int i = 0;
        while (i < this.category.length) {
            if (this.categoryLabel[i].compareTo(label) == 0) break;
            ++i;
        }
        return i;
    }
}

