/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetLayout;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

abstract class NetProtocolAddr
extends NetLayout {
    String protocol;
    String addrFormat;
    String[] addrParam;
    NVPair addr;
    NVFactory nvfactory = new NVFactory();
    NVNavigator nvnav = new NVNavigator();
    LWTextField[] addrParamText;
    int invalidField;

    public NetProtocolAddr() {
    }

    public NetProtocolAddr(String newProtocol, String newAddrFormat, String[] newAddrParam, String[] newAddrParamLabel) {
        this.protocol = newProtocol;
        this.addrFormat = newAddrFormat;
        this.addrParam = newAddrParam;
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(3, 3, 3, 3));
        this.addrParamText = new LWTextField[this.addrParam.length];
        NetStrings netStrings = new NetStrings();
        int i = 0;
        while (i < this.addrParam.length) {
            this.constrain((Container)((Object)this), (Component)new LWLabel(netStrings.getString(newAddrParamLabel[i]), 1), 0, i, 1, 1, 0, 10, 5, 8);
            this.addrParamText[i] = new LWTextField(20);
            this.constrain((Container)((Object)this), (Component)this.addrParamText[i], 1, i, 1, 1, 0, 10, 5, 8);
            ++i;
        }
    }

    public void setAddr(NVPair protoAddr) {
        this.devTrc("NetProtocolAddr: setAddr():");
        this.addr = protoAddr;
        this.refresh();
    }

    public NVPair getAddr() {
        NVPair newAddr = this.nvfactory.createNVPair(this.addrFormat);
        this.devTrc("NetProtocolAddr: getAddr(): addrParam=" + this.addrParam.length);
        int i = 0;
        while (i < this.addrParam.length) {
            String s = this.addrParamText[i].getText();
            if (s.length() <= 0) {
                newAddr = null;
                break;
            }
            NVPair newAddrParam = this.nvfactory.createNVPair("(" + this.addrParam[i] + "=" + s + ")");
            this.devTrc("NetProtocolAddr: getAddr():" + newAddrParam.toString());
            newAddr.addListElement(newAddrParam);
            ++i;
        }
        this.addr = newAddr;
        return newAddr;
    }

    public abstract boolean areDataValid();

    public void setFocus() {
        this.devTrc("NetProtocolAddr: setFocus():");
        this.netValidate.showDialog(this.addrParam[this.invalidField]);
        this.addrParamText[this.invalidField].selectAll();
        this.addrParamText[this.invalidField].requestFocus();
    }

    public void setEditable(boolean b) {
        int i = 0;
        while (i < this.addrParam.length) {
            this.addrParamText[i].setEditable(b);
            ++i;
        }
    }

    public boolean hasChanged() {
        boolean rc = false;
        this.devTrc("NetProtocolAddr: hasChanged():");
        int i = 0;
        while (i < this.addrParam.length) {
            NVPair nvpair = this.nvnav.findNVPair(this.addr, this.addrParam[i]);
            if (nvpair == null) {
                if (this.addrParamText[i].getText().length() > 0) {
                    rc = true;
                }
            } else if (!this.addrParamText[i].getText().equalsIgnoreCase(nvpair.getAtom())) {
                rc = true;
            }
            if (rc) break;
            ++i;
        }
        this.devTrc("NetProtocolAddr: hasChanged(): " + i + " " + rc);
        return rc;
    }

    public void refresh() {
        this.devTrc("NetProtocolAddr: refresh():");
        int i = 0;
        while (i < this.addrParam.length) {
            NVPair nvpair = this.nvnav.findNVPair(this.addr, this.addrParam[i]);
            String paramValue = nvpair == null ? new String("") : nvpair.getAtom();
            this.addrParamText[i].setText(paramValue);
            ++i;
        }
    }

    public void discard() {
        this.devTrc("NetProtocolAddr: discard():");
        int i = 0;
        while (i < this.addrParam.length) {
            this.addrParamText[i].setText("");
            ++i;
        }
    }

    public String toString() {
        this.devTrc("NetProtocolAddr: toString():");
        if (this.addr == null) {
            return null;
        }
        return this.addr.toString();
    }

    public abstract String getProtocol();

    public abstract boolean sameEndpoint(NetProtocolAddr var1);
}

