/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetRoute
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private static final String[] ROUTING_PARAM = new String[]{"use_dedicated_server", "use_cman"};
    private static final String[] ROUTING_PARAM_LABELS = new String[]{"PFCuseDedicatedServer", "PFCuseCMAN"};
    private static final String[] ROUTING_DISABLE_CODE = new String[]{"off", "false"};
    private static final String[] ROUTING_ENABLE_CODE = new String[]{"on", "true"};
    private static final String[] NET_ROUTE_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_ROUTE_HELP_TOPIC = "TOPICprofGeneralRouting";
    private MarginBorder sharedBorderPixel;
    private LWCheckbox[] fieldCheckbox;
    private NLParamParser nlpa;
    private String[] netRouteButton = new String[NET_ROUTE_BUTTONS.length];

    public NetRoute() {
        int i = 0;
        while (i < NET_ROUTE_BUTTONS.length) {
            this.netRouteButton[i] = this.netStrings.getString(NET_ROUTE_BUTTONS[i]);
            ++i;
        }
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        this.fieldCheckbox = new LWCheckbox[ROUTING_PARAM.length];
        i = 0;
        while (i < ROUTING_PARAM.length) {
            this.constrain((Container)((Object)this), (Component)new LWLabel(this.netStrings.getString(ROUTING_PARAM_LABELS[i]), 1), 0, i, 1, 1, 5, 5, 5, 5);
            this.fieldCheckbox[i] = new LWCheckbox();
            this.constrain((Container)((Object)this), (Component)this.fieldCheckbox[i], 1, i, 1, 1, 5, 5, 5, 5);
            ++i;
        }
    }

    public NetRoute(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("Caching info into NLPA/n");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NetRoute: cacheIt():");
        int i = 0;
        while (i < ROUTING_PARAM.length) {
            if (this.fieldCheckbox[i].getState()) {
                String s = ROUTING_ENABLE_CODE[i];
                try {
                    this.nlpa.addNLPListElement(String.valueOf(ROUTING_PARAM[i]) + "=" + s);
                }
                catch (NLException nLException) {}
            } else {
                this.nlpa.removeNLPListElement(ROUTING_PARAM[i]);
            }
            ++i;
        }
        this.pruneObsoleteParams();
    }

    public void discard() {
        this.devTrc("NetRoute: discard():");
        int i = 0;
        while (i < ROUTING_PARAM.length) {
            this.fieldCheckbox[i].setState(false);
            ++i;
        }
    }

    public void refresh() {
        this.devTrc("NetRoute: refresh():");
        int i = 0;
        while (i < ROUTING_PARAM.length) {
            NVPair nvpair = this.nlpa.getNLPListElement(ROUTING_PARAM[i]);
            if (nvpair != null && (nvpair.getAtom().equalsIgnoreCase("on") || nvpair.getAtom().equalsIgnoreCase("true"))) {
                this.fieldCheckbox[i].setState(true);
            }
            ++i;
        }
    }

    public boolean hasChanged() {
        boolean rc = false;
        this.devTrc("NetRoute: hasChanged():");
        int i = 0;
        while (i < ROUTING_PARAM.length) {
            NVPair nvpair = this.nlpa.getNLPListElement(ROUTING_PARAM[i]);
            if (nvpair != null) {
                if ((nvpair.getAtom().equalsIgnoreCase("on") || nvpair.getAtom().equalsIgnoreCase("true")) ^ this.fieldCheckbox[i].getState()) {
                    rc = true;
                    break;
                }
            } else if (this.fieldCheckbox[i].getState()) {
                rc = true;
                break;
            }
            ++i;
        }
        this.devTrc("NetRoute: hasChanged(): " + i + " " + rc);
        return rc;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NetRoute: createNetButton()");
        NetButton netButton = new NetButton(this.netRouteButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetRoute: buttonPushed()");
        if (label.equalsIgnoreCase(this.netRouteButton[0])) {
            this.devTrc("NetRoute: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICprofGeneralRouting");
        }
    }

    private void pruneObsoleteParams() {
        this.nlpa.removeNLPListElement("AUTOMATIC_IPC");
    }
}

