/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.nl.NVPair;

public class NetSPXAddr
extends NetProtocolAddr {
    public static final String SPX_PROTOCOL_PREFIX = "SPX";
    public static final String SPX_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=SPX))";
    private static final String[] SPX_ADDR_PARAM = new String[]{"SERVICE"};
    private static final String[] SPX_ADDR_PARAM_LABEL = new String[]{"PFCaddrServiceLabel"};

    public NetSPXAddr() {
        super(SPX_PROTOCOL_PREFIX, SPX_ADDR_FORMAT, SPX_ADDR_PARAM, SPX_ADDR_PARAM_LABEL);
    }

    public NetSPXAddr(NVPair protoAddr) {
        this();
        this.setAddr(protoAddr);
    }

    public String getProtocol() {
        return SPX_PROTOCOL_PREFIX;
    }

    public boolean areDataValid() {
        String val = this.addrParamText[0].getText();
        if (val == null || val.equals("") || val.indexOf(32) != -1) {
            this.invalidField = 0;
            return false;
        }
        return true;
    }

    public void setFocus() {
        this.netValidate.showDialog(SPX_ADDR_PARAM[0]);
        this.addrParamText[0].requestFocus();
    }

    public boolean sameEndpoint(NetProtocolAddr other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NetSPXAddr)) {
            return false;
        }
        String thisService = this.addrParamText[0].getText().toUpperCase();
        String thatService = ((NetSPXAddr)other).addrParamText[0].getText().toUpperCase();
        return thisService.equalsIgnoreCase(thatService);
    }
}

