/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.net.UnknownHostException;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.asst.profile.NetTCPSAddr;
import oracle.net.nl.NVPair;

public class NetTCPAddr
extends NetProtocolAddr {
    public static final String TCP_PROTOCOL_PREFIX = "TCP";
    public static final String TCP_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=TCP))";
    private static final String[] TCP_ADDR_PARAM = new String[]{"HOST", "PORT"};
    private static final String[] TCP_ADDR_PARAM_LABEL = new String[]{"PFCaddrHostLabel", "PFCaddrPortLabel"};
    private int inValidField;

    public NetTCPAddr() {
        super(TCP_PROTOCOL_PREFIX, TCP_ADDR_FORMAT, TCP_ADDR_PARAM, TCP_ADDR_PARAM_LABEL);
    }

    public NetTCPAddr(NVPair protoAddr) {
        this();
        this.setAddr(protoAddr);
    }

    public boolean areDataValid() {
        this.devTrc("NetTCPAddr: areDataValid():");
        if (this.addrParamText[0].getText().length() == 0 || !this.netValidate.validateHostName(this.addrParamText[0])) {
            this.inValidField = 0;
            return false;
        }
        if (this.addrParamText[1].getText().length() == 0 || !this.netValidate.validateNumber(this.addrParamText[1], 1, 65535)) {
            this.inValidField = 1;
            return false;
        }
        this.devTrc("NetTCPAddr: areDataValid(): true ");
        return true;
    }

    public void setFocus() {
        this.devTrc("NetTCPAddr: setFocus():");
        switch (this.inValidField) {
            case 0: {
                this.netValidate.showDialog(TCP_ADDR_PARAM[this.inValidField]);
                break;
            }
            case 1: {
                this.netValidate.showDialog(TCP_ADDR_PARAM[this.inValidField], 1, 65535);
                break;
            }
        }
        this.addrParamText[this.inValidField].selectAll();
        this.addrParamText[this.inValidField].requestFocus();
    }

    public String getProtocol() {
        return TCP_PROTOCOL_PREFIX;
    }

    public boolean sameEndpoint(NetProtocolAddr other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NetTCPAddr) && !(other instanceof NetTCPSAddr)) {
            return false;
        }
        String thisHost = this.addrParamText[0].getText();
        String thatHost = other.addrParamText[0].getText();
        String thisPort = this.addrParamText[1].getText().toUpperCase();
        String thatPort = other.addrParamText[1].getText().toUpperCase();
        try {
            return NetUtils.isSameHost(thisHost, thatHost) && thisPort.equalsIgnoreCase(thatPort);
        }
        catch (UnknownHostException unknownHostException) {
            return thisHost.equalsIgnoreCase(thatHost) && thisPort.equalsIgnoreCase(thatPort);
        }
    }
}

