/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetTrace
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private static final String[] TRACE_LEVEL = new String[]{"OFF", "USER", "ADMIN", "SUPPORT"};
    private static final String[] WHO_TYPE = new String[]{"client", "server"};
    private static final String[] WHO_LABEL = new String[]{"PFCclientLabel", "PFCserverLabel"};
    private static final String[] TRACE_PARAM = new String[]{"trace_level", "trace_directory", "trace_file", "trace_unique"};
    private static final String[] TRACE_PARAM_LABEL = new String[]{"PFCtraceLevel", "PFCtraceDirectory", "PFCtraceFile", "PFCtraceUnique"};
    private static final String[] NET_TRACE_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_TRACE_HELP_TOPIC = "TOPICprofGeneralTracing";
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private EwtContainer[] whoPanel;
    private LWChoice[] levelChoice;
    private NLParamParser nlpa;
    private String[] netTraceButtons = new String[NET_TRACE_BUTTONS.length];
    private LWCheckbox traceUnique;

    public NetTrace() {
        int i = 0;
        while (i < NET_TRACE_BUTTONS.length) {
            this.netTraceButtons[i] = this.netStrings.getString(NET_TRACE_BUTTONS[i]);
            ++i;
        }
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        this.whoPanel = new EwtContainer[WHO_TYPE.length];
        this.itemText = new LWTextField[TRACE_PARAM.length * WHO_TYPE.length];
        this.levelChoice = new LWChoice[WHO_TYPE.length];
        int j = 0;
        while (j < WHO_TYPE.length) {
            GroupBoxBorder groupBorder = new GroupBoxBorder(this.netStrings.getString(WHO_LABEL[j]), InsetFramePainter.getFramePainter(), 2);
            this.whoPanel[j] = new EwtContainer();
            this.whoPanel[j].setLayout(new GridBagLayout());
            this.whoPanel[j].setBorder((Border)groupBorder);
            this.constrain((Container)((Object)this), (Component)this.whoPanel[j], 0, j, 1, 1, 5, 5, 5, 5, 2);
            int k = j * WHO_TYPE.length;
            i = 0;
            while (i < TRACE_PARAM.length) {
                if (i < TRACE_PARAM.length - 1 || j < WHO_TYPE.length - 1) {
                    this.constrain((Container)this.whoPanel[j], (Component)new LWLabel(this.netStrings.getString(TRACE_PARAM_LABEL[i]), 1), 0, i + 1, 1, 1, 0, 10, 5, 8);
                }
                if (i == 0) {
                    this.levelChoice[j] = new LWChoice();
                    int l = 0;
                    while (l < TRACE_LEVEL.length) {
                        this.levelChoice[j].addItem(TRACE_LEVEL[l]);
                        ++l;
                    }
                    this.constrain((Container)this.whoPanel[j], (Component)this.levelChoice[j], 1, i + 1, 1, 1, 0, 10, 5, 8);
                } else if (i == TRACE_PARAM.length - 1) {
                    if (j == 0) {
                        this.traceUnique = new LWCheckbox();
                        this.constrain((Container)this.whoPanel[j], (Component)this.traceUnique, 1, i + 1, 1, 1, 0, 10, 5, 8);
                    }
                } else {
                    this.itemText[k + i] = new LWTextField(10);
                    this.constrain((Container)this.whoPanel[j], (Component)this.itemText[k + i], 1, i + 1, 1, 1, 0, 10, 5, 8);
                }
                ++i;
            }
            ++j;
        }
    }

    public NetTrace(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("Caching info into NLPA");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NetTrace: cacheIt():");
        int j = 0;
        while (j < WHO_TYPE.length) {
            int k = j * WHO_TYPE.length;
            int i = 0;
            while (i < TRACE_PARAM.length) {
                String s1;
                String s = new String(String.valueOf(TRACE_PARAM[i]) + "_" + WHO_TYPE[j]);
                if (i == 0) {
                    int l = this.levelChoice[j].getSelectedIndex();
                    this.devTrc("NetTrace: cacheIt(): l=" + l);
                    if (l > 0) {
                        s1 = this.levelChoice[j].getItem(l);
                        try {
                            this.nlpa.addNLPListElement(String.valueOf(s) + "=" + s1);
                        }
                        catch (NLException nLException) {}
                    } else {
                        this.nlpa.removeNLPListElement(s);
                    }
                } else if (i == TRACE_PARAM.length - 1) {
                    if (j == 0) {
                        if (this.traceUnique.getState()) {
                            try {
                                this.nlpa.addNLPListElement(String.valueOf(s) + "=on");
                            }
                            catch (NLException nLException) {}
                        } else {
                            this.nlpa.removeNLPListElement(s);
                        }
                    }
                } else {
                    s1 = this.itemText[k + i].getText();
                    if (s1.length() > 0) {
                        try {
                            this.nlpa.addNLPListElement(String.valueOf(s) + "=" + s1);
                        }
                        catch (NLException nLException) {}
                    } else {
                        this.nlpa.removeNLPListElement(s);
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public void discard() {
        this.devTrc("NetTrace: discard():");
        int j = 0;
        while (j < WHO_TYPE.length) {
            int k = j * WHO_TYPE.length;
            int i = 0;
            while (i < TRACE_PARAM.length) {
                if (i == 0 || i == TRACE_PARAM.length - 1) {
                    this.levelChoice[j].select(0);
                } else {
                    this.itemText[k + i].setText("");
                }
                ++i;
            }
            ++j;
        }
    }

    public void refresh() {
        this.devTrc("NetTrace: refresh():");
        int j = 0;
        while (j < WHO_TYPE.length) {
            int k = j * WHO_TYPE.length;
            int i = 0;
            while (i < TRACE_PARAM.length) {
                NVPair nvpair = this.nlpa.getNLPListElement(new String(String.valueOf(TRACE_PARAM[i]) + "_" + WHO_TYPE[j]));
                if (nvpair != null) {
                    if (i == 0) {
                        if (nvpair.getAtom().equalsIgnoreCase("16")) {
                            this.levelChoice[j].select(TRACE_LEVEL.length - 1);
                        } else {
                            int l = 0;
                            while (l < TRACE_LEVEL.length) {
                                if (TRACE_LEVEL[l].equalsIgnoreCase(nvpair.getAtom())) break;
                                ++l;
                            }
                            if (l < TRACE_LEVEL.length) {
                                this.levelChoice[j].select(l);
                            }
                        }
                    } else if (i == TRACE_PARAM.length - 1) {
                        if (j == 0) {
                            if (nvpair.getAtom().equalsIgnoreCase("on")) {
                                this.traceUnique.setState(true);
                            } else {
                                this.traceUnique.setState(false);
                            }
                        }
                    } else {
                        this.itemText[k + i].setText(nvpair.getAtom());
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public boolean hasChanged() {
        boolean rc = false;
        this.devTrc("NetTrace: hasChanged():");
        int i = 0;
        int j = 0;
        while (j < WHO_TYPE.length) {
            int k = j * WHO_TYPE.length;
            i = 0;
            while (i < TRACE_PARAM.length) {
                NVPair nvpair = this.nlpa.getNLPListElement(new String(String.valueOf(TRACE_PARAM[i]) + "_" + WHO_TYPE[j]));
                if (nvpair != null) {
                    if (i == 0) {
                        if (!this.levelChoice[j].getSelectedItem().equalsIgnoreCase(nvpair.getAtom())) {
                            rc = true;
                            break;
                        }
                    } else if (i == TRACE_PARAM.length - 1) {
                        if (j == 0 && nvpair.getAtom().equalsIgnoreCase("on") ^ this.traceUnique.getState()) {
                            rc = true;
                            break;
                        }
                    } else if (!this.itemText[k + i].getText().equalsIgnoreCase(nvpair.getAtom())) {
                        rc = true;
                        break;
                    }
                } else if (i == 0) {
                    if (this.levelChoice[j].getSelectedIndex() > 0) {
                        rc = true;
                        break;
                    }
                } else if (i == TRACE_PARAM.length - 1) {
                    if (j == 0 && this.traceUnique.getState()) {
                        rc = true;
                        break;
                    }
                } else if (this.itemText[k + i].getText().length() > 0) {
                    rc = true;
                    break;
                }
                ++i;
            }
            if (rc) break;
            ++j;
        }
        this.devTrc("NetTrace: hasChanged(): " + j + " " + i + " " + rc);
        return rc;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NetTrace: createNetButton()");
        NetButton netButton = new NetButton(this.netTraceButtons);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetTrace: buttonPushed()");
        if (label.equalsIgnoreCase(this.netTraceButtons[0])) {
            this.devTrc("NetTrace: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICprofGeneralTracing");
        }
    }
}

