/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.NetBAuthParam;
import oracle.net.asst.security.NetCYBAuth;
import oracle.net.asst.security.NetIDXAuth;
import oracle.net.asst.security.NetKRBAuth;
import oracle.net.asst.security.NetNTSAuth;
import oracle.net.asst.security.NetRADAuth;
import oracle.net.asst.security.NetSECAuth;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetAuthParam
extends NetLayout
implements ItemListener,
ProfileCache,
NetButtonListener {
    private final NetStrings netStrings = new NetStrings();
    private static final String[] supportedAuthSrv = new String[]{"KERBEROS(V5)", "CYBERSAFE", "IDENTIX", "SECURID", "NTS", "RADIUS"};
    private static final String[] NET_AUTHPARAM_BUTTONS = new String[]{"PFChelp"};
    private static final String AUTH_LABEL = "PFCserviceANO";
    private final String NET_AUTHPARAM_HELP_TOPIC = "TOPICanoAuthParam";
    private MarginBorder sharedBorderPixel;
    private LWChoice AuthSrvChoice;
    private NetBAuthParam[] AuthService;
    private EwtContainer AuthDisplay;
    private CardLayout authCardLayout;
    private int currentAuthSrv;
    private NLParamParser nlpa;
    private String[] netAuthParamButton = new String[NET_AUTHPARAM_BUTTONS.length];

    public NetAuthParam() {
        int i = 0;
        while (i < NET_AUTHPARAM_BUTTONS.length) {
            this.netAuthParamButton[i] = this.netStrings.getString(NET_AUTHPARAM_BUTTONS[i]);
            ++i;
        }
        this.sharedBorderPixel = new MarginBorder(8, 8, 8, 8);
        this.setBorder((Border)this.sharedBorderPixel);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.constrain((Container)((Object)this), (Component)new LWLabel(this.netStrings.getString(AUTH_LABEL), 1), 0, 0, 1, 1, 0, 4, 0, 0, 2);
        this.AuthSrvChoice = new LWChoice();
        this.authCardLayout = new CardLayout();
        this.AuthDisplay = new EwtContainer();
        this.AuthService = new NetBAuthParam[supportedAuthSrv.length];
        this.AuthDisplay.setLayout(this.authCardLayout);
        i = 0;
        while (i < supportedAuthSrv.length) {
            this.AuthSrvChoice.addItem(supportedAuthSrv[i]);
            this.AuthService[i] = this.createAuth(supportedAuthSrv[i]);
            if (this.AuthService[i] != null) {
                this.AuthDisplay.add(supportedAuthSrv[i], (Component)((Object)this.AuthService[i]));
            }
            ++i;
        }
        this.AuthSrvChoice.addItemListener((ItemListener)this);
        this.constrain((Container)((Object)this), (Component)this.AuthSrvChoice, 1, 0, 1, 1, 0, 4, 0, 0, 2);
        this.constrain((Container)((Object)this), (Component)this.AuthDisplay, 0, 1, 2, 1, 0, 4, 0, 0);
        this.displayAuth(supportedAuthSrv[0]);
        this.currentAuthSrv = 0;
    }

    public NetAuthParam(NVPair AuthSrv) {
        this();
        this.currentAuthSrv = this.chooseAuth(AuthSrv);
        this.displayAuth(supportedAuthSrv[this.currentAuthSrv]);
        this.AuthService[this.currentAuthSrv].setAuth(AuthSrv);
    }

    public NVPair getAuth() {
        this.devTrc("NetAuthParam: getAuth():");
        return this.AuthService[this.currentAuthSrv].getAuth();
    }

    public void itemStateChanged(ItemEvent e) {
        this.devTrc("NetAuthParam: itemStateChanged():");
        Object source = e.getSource();
        if (source instanceof LWChoice) {
            this.displayAuth(e.getItem().toString());
            this.currentAuthSrv = this.chooseAuth(e.getItem().toString());
        }
    }

    private void displayAuth(String authService) {
        this.devTrc("NetAuthParam: displayAuth():");
        this.authCardLayout.show((Container)this.AuthDisplay, authService);
        this.AuthSrvChoice.select(authService);
    }

    private NetBAuthParam createAuth(String authService) {
        this.devTrc("NetAuthParam: createAuth():");
        if (authService.equalsIgnoreCase(supportedAuthSrv[0])) {
            return new NetKRBAuth();
        }
        if (authService.equalsIgnoreCase(supportedAuthSrv[1])) {
            return new NetCYBAuth();
        }
        if (authService.equalsIgnoreCase(supportedAuthSrv[2])) {
            return new NetIDXAuth();
        }
        if (authService.equalsIgnoreCase(supportedAuthSrv[3])) {
            return new NetSECAuth();
        }
        if (authService.equalsIgnoreCase(supportedAuthSrv[4])) {
            return new NetNTSAuth();
        }
        if (authService.equalsIgnoreCase(supportedAuthSrv[5])) {
            return new NetRADAuth();
        }
        return null;
    }

    private int chooseAuth(String authService) {
        this.devTrc("NetAuthParam: chooseAuth(String):");
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (authService.equalsIgnoreCase(supportedAuthSrv[i])) break;
            ++i;
        }
        return i;
    }

    private int chooseAuth(NVPair address) {
        NVNavigator nvnav = new NVNavigator();
        this.devTrc("NetAuthParam: chooseAuth(NVPair):");
        NVPair nvpair = nvnav.findNVPair(address, "Auth Service");
        String authService = nvpair.getAtom();
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (authService.equalsIgnoreCase(supportedAuthSrv[i])) break;
            ++i;
        }
        return i;
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("Caching info into NLPA");
        this.nlpa = nlpaParam;
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (this.AuthService[i] != null) {
                this.AuthService[i].setNLP(this.nlpa);
            }
            ++i;
        }
    }

    public void cacheIt() {
        this.devTrc("NetAuthParam: cacheIt():");
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (this.AuthService[i] != null) {
                this.AuthService[i].cacheIt();
            }
            ++i;
        }
    }

    public void refresh() {
        this.devTrc("NetAuthParam: cacheIt():");
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (this.AuthService[i] != null) {
                this.AuthService[i].refresh();
            }
            ++i;
        }
    }

    public boolean hasChanged() {
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (this.AuthService[i].hasChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void discard() {
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (this.AuthService[i] != null) {
                this.AuthService[i].discard();
            }
            ++i;
        }
    }

    public NetButton createNetButton() {
        this.devTrc("NetAuthparam: createNetButton()");
        NetButton netButton = new NetButton(this.netAuthParamButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetAuthparam: buttonPushed()");
        if (label.equalsIgnoreCase(this.netAuthParamButton[0])) {
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICanoAuthParam");
        }
    }

    public boolean areDataValid() {
        this.devTrc("NetAuthParam areDataValid");
        int i = 0;
        while (i < supportedAuthSrv.length) {
            if (!this.AuthService[i].areDataValid()) {
                this.currentAuthSrv = i;
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setFocus() {
        this.devTrc("NetAuthParam setFocus");
        this.displayAuth(supportedAuthSrv[this.currentAuthSrv]);
        this.AuthService[this.currentAuthSrv].setFocus();
    }

    public void setAppEnv(WebApplication w) {
        this.devTrc("NetAuthParam setAppEnv");
        this.frame = (BufferedFrame)w.getFrame();
        int i = 0;
        while (i < supportedAuthSrv.length) {
            this.AuthService[i].setAppEnv(w);
            ++i;
        }
    }
}

