/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetBAuth
extends NetLayout
implements ProfileCache,
ActionListener,
NetButtonListener {
    private String[] selectDefault;
    private String[] removeList;
    private String[] availDefault;
    private LWList selectList;
    private LWList availList;
    private EwtContainer lpanel;
    private EwtContainer cpanel;
    private EwtContainer rpanel;
    private MarginBorder sharedBorderPixel;
    private LWButton[] button;
    private NLParamParser nlpa;
    private boolean foundnone;
    private boolean selected;
    private String helpTopic;
    private String authName;
    private String[] ctrlButtons = new String[CTRLPANEL_LABEL.length];
    private String[] netAuthButton = new String[NET_AUTH_BUTTONS.length];
    private boolean emptyAdp = true;
    private boolean emptyRm = false;
    private NetStrings netStrings = new NetStrings();
    private static final int PANEL_SIZE = 10;
    private static final String EMPTY = "";
    private static final String authservice = "sqlnet.authentication_services";
    private static final String NO_ADAPTER = "";
    private static final String OPEN_PAREN = "=(BEQ, TCPS, ";
    private static final String CLOSE_PAREN = ")";
    private static final String COMMA = ",";
    private static final String[] NET_AUTH_BUTTONS = new String[]{"PFChelp"};
    private static final String[] PANEL_LABEL = new String[]{"PFCselectedANO", "PFCavailableANO"};
    private static final String[] CTRLPANEL_LABEL = new String[]{"PFCaddButtonLabel", "PFCremoveButtonLabel", "PFCpromoteButtonLabel", "PFCdemoteButtonLabel"};

    public NetBAuth(String newAuthName, String[] newRemoveList, String[] newSelectDefault, String[] newAvailDefault) {
        int i = 0;
        while (i < NET_AUTH_BUTTONS.length) {
            this.netAuthButton[i] = this.netStrings.getString(NET_AUTH_BUTTONS[i]);
            ++i;
        }
        this.foundnone = true;
        this.removeList = newRemoveList;
        this.selectDefault = newSelectDefault;
        this.availDefault = newAvailDefault;
        this.helpTopic = new String(newAuthName);
        this.selected = false;
        this.authName = newAuthName;
        this.lpanel = new EwtContainer();
        this.lpanel.setLayout(new GridBagLayout());
        this.availList = new LWList(10, false);
        i = 0;
        while (i < this.availDefault.length) {
            this.availList.addItem(this.availDefault[i]);
            ++i;
        }
        this.constrain((Container)this.lpanel, (Component)new LWLabel(this.netStrings.getString(PANEL_LABEL[1])), 0, 0, 1, 1);
        this.constrain((Container)this.lpanel, (Component)this.availList, 0, 1, 1, 1, 5, 5, 0, 5, 1);
        this.cpanel = new EwtContainer();
        this.cpanel.setLayout(new GridBagLayout());
        this.button = new LWButton[CTRLPANEL_LABEL.length];
        this.ctrlButtons[0] = this.netStrings.getString(CTRLPANEL_LABEL[0]);
        this.button[0] = new LWButton(this.ctrlButtons[0]);
        this.button[0].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[0], 0, 0, 1, 1, 2, 15, 1.0, 5.0, 0, 5, 0, 5);
        this.ctrlButtons[1] = this.netStrings.getString(CTRLPANEL_LABEL[1]);
        this.button[1] = new LWButton(this.ctrlButtons[1]);
        this.button[1].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[1], 0, 1, 1, 1, 2, 10, 1.0, 0.0, 10, 5, 0, 5);
        this.ctrlButtons[2] = this.netStrings.getString(CTRLPANEL_LABEL[2]);
        this.button[2] = new LWButton(this.ctrlButtons[2]);
        this.button[2].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[2], 0, 2, 1, 1, 2, 10, 1.0, 0.0, 10, 5, 0, 5);
        this.ctrlButtons[3] = this.netStrings.getString(CTRLPANEL_LABEL[3]);
        this.button[3] = new LWButton(this.ctrlButtons[3]);
        this.button[3].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[3], 0, 3, 1, 1, 2, 11, 1.0, 5.0, 10, 5, 0, 5);
        this.rpanel = new EwtContainer();
        this.rpanel.setLayout(new GridBagLayout());
        this.selectList = new LWList(10, false);
        i = 0;
        while (i < this.selectDefault.length) {
            this.selectList.addItem(this.selectDefault[i]);
            ++i;
        }
        this.constrain((Container)this.rpanel, (Component)new LWLabel(this.netStrings.getString(PANEL_LABEL[0])), 0, 0, 1, 1);
        this.constrain((Container)this.rpanel, (Component)this.selectList, 0, 1, 1, 1, 5, 5, 0, 5, 1);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.constrain((Container)((Object)this), (Component)this.lpanel, 0, 0, 1, 1);
        this.constrain((Container)((Object)this), (Component)this.cpanel, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.constrain((Container)((Object)this), (Component)this.rpanel, 2, 0, 1, 1);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("NetBAuth: setNLP():");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NetBAuth: cacheIt():");
        this.checkEmptyAdp();
        int selectCount = this.selectList.getItemCount();
        this.devTrc("NetBAuth: cacheIt():" + this.selected);
        if (!this.selected) {
            return;
        }
        this.selected = false;
        if (selectCount == 0) {
            this.nlpa.removeNLPListElement(authservice);
            return;
        }
        this.cacheSelectList();
    }

    public void refresh() {
        this.devTrc("NetBAuth: refresh():");
        NVPair nvpair = this.nlpa.getNLPListElement(authservice);
        if (nvpair != null) {
            this.makeAllNamingAvailable();
            int i = 0;
            while (i < nvpair.getListSize()) {
                NVPair nvelement = nvpair.getListElement(i);
                String s = nvelement.getAtom().toUpperCase();
                if (this.checkAdd(s)) {
                    this.selectList.addItem(s);
                    this.checkEmptyAdp();
                    if (this.checkRemove(s)) {
                        this.availList.remove(s);
                        this.checkRmEmpty();
                    }
                }
                ++i;
            }
        }
    }

    public boolean checkAdd(String s) {
        int i = 0;
        while (i < this.removeList.length) {
            if (s.equalsIgnoreCase(this.removeList[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkRemove(String s) {
        int availCount = this.availList.getItemCount();
        int i = 0;
        while (i < availCount) {
            if (s.equalsIgnoreCase(this.availList.getItem(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.selected = true;
        this.devTrc("ACTION selected :" + this.selected);
        if (source instanceof LWButton) {
            int j = 0;
            while (j < CTRLPANEL_LABEL.length) {
                if (e.getActionCommand().compareTo(this.netStrings.getString(CTRLPANEL_LABEL[j])) == 0) break;
                ++j;
            }
            switch (j) {
                case 0: {
                    int i = this.availList.getSelectedIndex();
                    if (i < 0) break;
                    String s = this.availList.getSelectedItem();
                    this.availList.remove(i);
                    this.selectList.addItem(s);
                    this.checkEmptyAdp();
                    break;
                }
                case 1: {
                    int i = this.selectList.getSelectedIndex();
                    if (i < 0) break;
                    String s = this.selectList.getSelectedItem();
                    this.selectList.remove(i);
                    this.availList.addItem(s);
                    this.checkRmEmpty();
                    break;
                }
                case 3: {
                    int i = this.selectList.getSelectedIndex();
                    if (i < 0 || i >= this.selectList.getItemCount() - 1) break;
                    String s = this.selectList.getSelectedItem();
                    String s1 = this.selectList.getItem(i + 1);
                    this.selectList.replaceItem(s1, i);
                    this.selectList.replaceItem(s, i + 1);
                    this.selectList.deselect(i);
                    this.selectList.select(i + 1);
                    break;
                }
                case 2: {
                    int i = this.selectList.getSelectedIndex();
                    if (i <= 0) break;
                    String s = this.selectList.getSelectedItem();
                    String s1 = this.selectList.getItem(i - 1);
                    this.selectList.replaceItem(s1, i);
                    this.selectList.replaceItem(s, i - 1);
                    this.selectList.deselect(i);
                    this.selectList.select(i - 1);
                    break;
                }
            }
        }
    }

    private void makeAllNamingAvailable() {
        this.devTrc("NetBAuth: makeAllNamingAvailable():");
        this.availList.removeAll();
        this.selectList.removeAll();
        int i = 0;
        while (i < this.availDefault.length) {
            this.availList.addItem(this.availDefault[i]);
            ++i;
        }
        if (!this.emptyAdp) {
            return;
        }
        i = 0;
        while (i < this.selectDefault.length) {
            this.selectList.addItem(this.selectDefault[i]);
            ++i;
        }
    }

    private void cacheSelectList() {
        this.devTrc("NetBAuth: cacheSelectList():");
        StringBuffer sb = new StringBuffer();
        int selectCount = this.selectList.getItemCount();
        sb.append(OPEN_PAREN);
        int i = 0;
        while (i < selectCount) {
            sb.append(this.selectList.getItem(i));
            if (++i >= selectCount) continue;
            sb.append(COMMA);
        }
        sb.append(CLOSE_PAREN);
        try {
            this.devTrc("NetBAuth selectList CacheOut");
            this.nlpa.addNLPListElement(authservice + sb.toString());
        }
        catch (NLException e) {
            System.err.println("exception during write: " + e);
        }
    }

    public boolean hasChanged() {
        return this.selected;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void discard() {
        this.makeAllNamingAvailable();
    }

    public void reset() {
        this.selected = false;
        this.makeAllNamingAvailable();
    }

    public NetButton createNetButton() {
        this.devTrc("NetBAuth: createNetButton()");
        NetButton netButton = new NetButton(this.netAuthButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetBAuth: buttonPushed()");
        if (label.equalsIgnoreCase(this.netAuthButton[0])) {
            this.devTrc("NetBAuth: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show(this.helpTopic);
        }
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public void checkEmptyAdp() {
        if (this.emptyAdp) {
            this.selectList.remove("");
            this.emptyAdp = false;
        }
    }

    public void checkRmEmpty() {
        int count = this.availList.getItemCount();
        this.devTrc("NetBAuth checkRmEmpty()" + count);
        if (count == 0) {
            this.emptyRm = true;
            this.availList.addItem("");
        } else if (this.emptyRm) {
            this.availList.remove("");
            this.emptyRm = false;
        }
    }
}

