/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.security.NetKRBAuth;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

class NetBAuthParam
extends NetLayout
implements KeyListener,
FocusListener {
    boolean hasChanged = false;
    private String authService;
    private String[] hiddenParam;
    private String[] hiddenParamVal;
    private String[] defaultVal;
    public String[] authParamLabel;
    public String[] authParam;
    NVPair auth;
    NVFactory nvfactory = new NVFactory();
    NVNavigator nvnav = new NVNavigator();
    LWTextField[] authParamText;
    MarginBorder sharedBorderPixel;
    private NLParamParser nlpa;
    protected String[] authParamName;
    private String os;
    protected int currentField;
    private static String[] ADAPTER = new String[]{"SECURID", "NTS"};
    private boolean refreshDef;
    private static int MAX_CLOCKSKEW = 6000;
    private static int MIN_CLOCKSKEW;

    public NetBAuthParam() {
    }

    public NetBAuthParam(String newAuthService, String[] newAuthParamLabel, String[] newAuthParam, String[] newHiddenParam, String[] newHiddenParamVal, String[] newDefaultVal, String[] newNTDefaultVal) {
        NetStrings netStrings = new NetStrings();
        this.refreshDef = true;
        this.currentField = -1;
        this.os = System.getProperty("os.name");
        this.authService = newAuthService;
        this.authParamLabel = newAuthParamLabel;
        this.authParam = newAuthParam;
        this.hiddenParam = newHiddenParam;
        this.hiddenParamVal = newHiddenParamVal;
        this.defaultVal = this.os.equals("Windows NT") || this.os.equals("Windows 95") ? newNTDefaultVal : newDefaultVal;
        this.authParamName = new String[this.authParamLabel.length];
        this.sharedBorderPixel = new MarginBorder(3, 3, 3, 3);
        this.setBorder((Border)this.sharedBorderPixel);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.authParamText = new LWTextField[this.authParamLabel.length];
        int i = 0;
        while (i < this.authParamLabel.length) {
            this.authParamName[i] = netStrings.getString(this.authParamLabel[i]);
            ++i;
        }
        String s = ":";
        i = 0;
        while (i < ADAPTER.length) {
            if (this.authService.equalsIgnoreCase(ADAPTER[i])) {
                s = "!";
            }
            ++i;
        }
        i = 0;
        while (i < this.authParamName.length) {
            this.constrain((Container)((Object)this), (Component)new LWLabel(String.valueOf(this.authParamName[i]) + s, 1), 0, i, 1, 1, 0, 10, 5, 8);
            this.authParamText[i] = new LWTextField(20);
            this.authParamText[i].addKeyListener(this);
            this.authParamText[i].addFocusListener(this);
            if (!this.authService.equalsIgnoreCase(ADAPTER[0]) && !this.authService.equalsIgnoreCase(ADAPTER[1])) {
                this.constrain((Container)((Object)this), (Component)this.authParamText[i], 1, i, 1, 1, 0, 10, 5, 8);
            }
            ++i;
        }
        this.showDefault();
        this.setDefault();
    }

    public void setAuth(NVPair AuthSrv) {
        this.devTrc("NetBAuthParam: setAuth():");
        this.auth = AuthSrv;
        this.refresh();
    }

    public NVPair getAuth() {
        NVPair newAuth = this.nvfactory.createNVPair("");
        this.devTrc("NetBAuthParam: getAuth(): authParamName=" + this.authParamName.length);
        int i = 0;
        while (i < this.authParamName.length) {
            NVPair newAuthParam = this.nvfactory.createNVPair("(" + this.authParamName[i] + "=" + this.authParamText[i].getText() + ")");
            this.devTrc("NetBAuthParam: getAuth():" + newAuthParam.toString());
            newAuth.addListElement(newAuthParam);
            ++i;
        }
        this.auth = newAuth;
        return newAuth;
    }

    public boolean isAuthValid() {
        this.devTrc("NetBAuthParam: isAuthValid():");
        return true;
    }

    public boolean hasChanged() {
        this.devTrc("NetBAuthParam: hasChanged():");
        return this.hasChanged;
    }

    public void refresh() {
        this.devTrc("NetBAuthParam: refresh():");
        int i = 0;
        while (i < this.authParam.length) {
            NVPair nvpair;
            String param = this.authParam[i];
            if (param != null && (nvpair = this.nlpa.getNLPListElement(param)) != null) {
                this.authParamText[i].setText(nvpair.getAtom());
            }
            ++i;
        }
        if (!this.authParamText[0].getText().equals("")) {
            this.showDefaultEditable();
        }
    }

    public void cacheIt() {
        String paramValue;
        NVPair nvpair;
        String param;
        this.devTrc("NetBAuthParam: cacheIt():" + this.authService);
        int i = 0;
        while (i < this.authParam.length) {
            param = this.authParam[i];
            if (param != null) {
                nvpair = this.nlpa.getNLPListElement(param);
                paramValue = this.authParamText[i].getText();
                int paramlen = paramValue.length();
                this.devTrc("NetBAuthParam: cacheIt() paramlen:" + paramlen);
                if (i == 0 && paramlen == 0) {
                    this.removeAll(this.nlpa);
                    return;
                }
                if (paramlen >= 0) {
                    this.nlpa.removeNLPListElement(param);
                }
                if (paramlen > 0) {
                    try {
                        if (this.defaultVal != null) {
                            if (!paramValue.equals(this.defaultVal[i])) {
                                this.nlpa.addNLPListElement(String.valueOf(param) + "=" + paramValue);
                            }
                        } else {
                            this.nlpa.addNLPListElement(String.valueOf(param) + "=" + paramValue);
                        }
                    }
                    catch (NLException nLException) {}
                }
            }
            ++i;
        }
        if (this.hiddenParam != null) {
            i = 0;
            while (i < this.hiddenParam.length) {
                param = this.hiddenParam[i];
                nvpair = this.nlpa.getNLPListElement(param);
                paramValue = this.hiddenParamVal[i];
                while (nvpair != null) {
                    this.nlpa.removeNLPListElement(param);
                    nvpair = this.nlpa.getNLPListElement(param);
                }
                try {
                    this.nlpa.addNLPListElement(String.valueOf(param) + "=" + paramValue);
                }
                catch (NLException nLException) {}
                ++i;
            }
        }
    }

    public String toString() {
        this.devTrc("NetBAuthParam: toString():");
        return this.auth.toString();
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("Caching info into NLPA");
        this.nlpa = nlpaParam;
    }

    public void discard() {
        int i = 0;
        while (i < this.authParamName.length) {
            this.authParamText[i].setText("");
            ++i;
        }
    }

    public void removeAll(NLParamParser params) {
        String param;
        int i = 0;
        while (i < this.authParam.length) {
            param = this.authParam[i];
            this.devTrc("NetBAuthParam: cacheIt() remove:" + param);
            params.removeNLPListElement(param);
            ++i;
        }
        if (this.hiddenParam != null) {
            i = 0;
            while (i < this.hiddenParam.length) {
                param = this.hiddenParam[i];
                params.removeNLPListElement(param);
                ++i;
            }
        }
    }

    public String getFirstParam() {
        return this.authParamText[0].getText();
    }

    protected void setDefault() {
        this.devTrc("NetAuthParam: setDefault()");
        String s = this.getFirstParam();
        if (s.equals("") || s == null) {
            this.refreshDef = true;
            this.showDefaultUnEditable();
            return;
        }
        if (this.refreshDef) {
            this.showDefaultEditable();
            this.refreshDef = false;
        }
    }

    protected void showDefault() {
        this.devTrc("NetAuthParam: showDefault()");
        int i = 0;
        while (i < this.authParam.length) {
            String s = this.authParamText[i].getText();
            if (s.equals("") && this.defaultVal != null) {
                this.authParamText[i].setText(this.defaultVal[i]);
            }
            ++i;
        }
        if (this instanceof NetKRBAuth) {
            this.authParamText[0].setText("");
        }
    }

    protected void showDefaultEditable() {
        this.devTrc("NetAuthParam: showDefaultEditable()");
        int i = 1;
        while (i < this.authParam.length) {
            String s = this.authParamText[i].getText();
            if (s.equals("") && this.defaultVal != null) {
                this.authParamText[i].setText(this.defaultVal[i]);
            }
            this.authParamText[i].setEditable(true);
            ++i;
        }
    }

    protected void showDefaultUnEditable() {
        this.devTrc("NetAuthParam: showDefaultUnEditable()");
        String s = this.authParamText[0].getText();
        if (!s.equals("")) {
            return;
        }
        int i = 1;
        while (i < this.authParam.length) {
            s = this.authParamText[i].getText();
            if (s.equals("") && this.defaultVal != null) {
                this.authParamText[i].setText(this.defaultVal[i]);
            }
            this.authParamText[i].setEditable(false);
            ++i;
        }
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component comp = evt.getComponent();
        char ch = evt.getKeyChar();
        LWTextField f = (LWTextField)comp;
        String cs = f.getText();
        int paramLen = this.authParamText.length;
        this.hasChanged = true;
        this.devTrc("NetBAuthParam : keyTyped()");
        if (comp instanceof LWTextField) {
            this.setDefault();
        }
        if (f.equals(this.authParamText[paramLen - 1])) {
            this.devTrc("NetBAuthParam : keyTyped() character typed:" + ch);
            this.netValidate.validateNumber(f, MIN_CLOCKSKEW, MAX_CLOCKSKEW);
        } else if (!this.validateCharset(ch)) {
            evt.setKeyChar('\u0000');
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public boolean areDataValid() {
        int paramLen = this.authParamText.length;
        this.devTrc("NetBAuthParam areDataValid:");
        String s0 = this.authParamText[0].getText();
        if (!s0.equals("")) {
            if (this.netValidate != null) {
                if (this.authParamText.length > 1) {
                    if (!this.netValidate.validateNumber(this.authParamText[paramLen - 1], MIN_CLOCKSKEW, MAX_CLOCKSKEW)) {
                        this.currentField = paramLen - 1;
                        return false;
                    }
                } else if (!this.netValidate.validateName(this.authParamText[0])) {
                    this.devTrc("NetBAuthParam areDataValid:false");
                    this.currentField = 0;
                    return false;
                }
            }
            this.devTrc("NetBAuthParam areDataValid:true");
        }
        return true;
    }

    public boolean validateCharset(char ch) {
        int paramLen = this.authParamText.length;
        this.devTrc("NetBAuthParam : validateCharset():" + ch);
        if (this.os.equals("Windows NT") || this.os.equals("Windows 95") ? Character.isLetterOrDigit(ch) || ch == '-' || ch == '_' || ch == '.' || ch == '\\' || ch == ':' : Character.isLetterOrDigit(ch) || ch == '-' || ch == '_' || ch == '.' || ch == '/') {
            return true;
        }
        return ch == '\b' || Character.digit(ch, 10) == -1;
    }

    public void setFocus() {
        this.devTrc("NetBAuthParam : setFocus():currentField:" + this.currentField);
        LWTextField f = this.authParamText[this.currentField];
        if (this.currentField != -1) {
            if (this.currentField != 0) {
                this.netValidate.showDialog(f.getText(), MIN_CLOCKSKEW, MAX_CLOCKSKEW);
            }
            if (this.currentField == 0) {
                this.netValidate.showDialog(f.getText());
            }
            f.requestFocus();
            f.selectAll();
        }
    }
}

