/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetChksum
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private final NetStrings netStrings = new NetStrings();
    private static final String[] tLevel = new String[]{"required", "requested", "accepted", "rejected"};
    private static final String[] who = new String[]{"server", "client"};
    private static final String[] LEVELCHK_LABEL = new String[]{"PFClevelCHK", "PFCemptyCHK"};
    private static final String[] param = new String[]{"sqlnet.crypto_checksum", "sqlnet_crypto_checksum_type"};
    private static final String[] INDCHKSUM_LABEL = new String[]{"PFCserverCHK", "PFCclientCHK"};
    private static final String[] NET_CHKSUM_BUTTONS = new String[]{"PFChelp"};
    private final String NET_CHKSUM_HELP_TOPIC = "TOPICanoIntegrity";
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private EwtContainer[] whoPanel;
    private LWCheckbox[] whoCheckbox;
    private LWChoice[] levelChoice;
    private NLParamParser nlpa;
    private String[] netChksumButton = new String[NET_CHKSUM_BUTTONS.length];
    private boolean changed = false;
    private boolean[] checkedBox;
    private boolean saved = false;

    public NetChksum() {
        int i = 0;
        while (i < NET_CHKSUM_BUTTONS.length) {
            this.netChksumButton[i] = this.netStrings.getString(NET_CHKSUM_BUTTONS[i]);
            ++i;
        }
        this.sharedBorderPixel = new MarginBorder(8, 8, 8, 8);
        this.setBorder((Border)this.sharedBorderPixel);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.whoPanel = new EwtContainer[who.length];
        this.whoCheckbox = new LWCheckbox[who.length];
        this.checkedBox = new boolean[who.length];
        this.itemText = new LWTextField[LEVELCHK_LABEL.length * who.length];
        this.levelChoice = new LWChoice[who.length];
        int j = 0;
        while (j < who.length) {
            this.whoPanel[j] = new EwtContainer();
            this.whoPanel[j].setLayout(new GridBagLayout());
            this.whoCheckbox[j] = new LWCheckbox(this.netStrings.getString(INDCHKSUM_LABEL[j]));
            this.constrain((Container)((Object)this), (Component)this.whoPanel[j], 0, j, 1, 1, 5, 5, 5, 5);
            this.constrain((Container)this.whoPanel[j], (Component)this.whoCheckbox[j], 0, 0, 1, 1, 3, 5, 5, 5);
            this.whoCheckbox[j].setState(false);
            this.checkedBox[j] = false;
            int k = j * who.length;
            i = 0;
            while (i < LEVELCHK_LABEL.length) {
                this.constrain((Container)this.whoPanel[j], (Component)new LWLabel(this.netStrings.getString(LEVELCHK_LABEL[i]), 1), 0, i + 1, 1, 1, 0, 10, 5, 8);
                if (i == 0) {
                    this.levelChoice[j] = new LWChoice();
                    int l = 0;
                    while (l < tLevel.length) {
                        this.levelChoice[j].addItem(tLevel[l]);
                        ++l;
                    }
                    this.constrain((Container)this.whoPanel[j], (Component)this.levelChoice[j], 1, i + 1, 1, 1, 0, 10, 5, 8);
                } else {
                    this.itemText[k + i] = new LWTextField(20);
                    this.itemText[k + i].setText("MD5");
                }
                ++i;
            }
            ++j;
        }
    }

    public NetChksum(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("Caching info into NLPA");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NetChksum: cacheIt():");
        int j = 0;
        while (j < who.length) {
            if (!this.whoCheckbox[j].getState()) {
                this.devTrc("NetChksum: cacheIt(): state FALSE");
                if (this.checkedBox[j]) {
                    this.removeAll(j);
                }
                this.checkedBox[j] = false;
            } else {
                this.devTrc("NetChksum: cacheIt(): continue");
                int k = j * who.length;
                int i = 0;
                while (i < LEVELCHK_LABEL.length) {
                    String s1;
                    String s = new String(String.valueOf(param[i]) + "_" + who[j]);
                    this.devTrc("NetChksum: cacheIt(): param" + s);
                    NVPair nvpair = this.nlpa.getNLPListElement(s);
                    if (i == 0) {
                        int l = this.levelChoice[j].getSelectedIndex();
                        this.devTrc("NetChksum: cacheIt(): l=" + l);
                        if (l >= 0 || nvpair != null) {
                            s1 = this.levelChoice[j].getItem(l);
                            try {
                                this.nlpa.addNLPListElement(String.valueOf(s) + "=" + s1);
                            }
                            catch (NLException nLException) {}
                        }
                    } else {
                        s1 = this.itemText[k + i].getText();
                        if (s1.length() > 0) {
                            try {
                                this.nlpa.addNLPListElement(String.valueOf(s) + "=" + s1);
                            }
                            catch (NLException nLException) {}
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        this.saved = true;
        this.changed = false;
    }

    public void refresh() {
        this.devTrc("NetChksum: refresh():");
        int j = 0;
        while (j < who.length) {
            int k = j * who.length;
            int i = 0;
            while (i < param.length) {
                NVPair nvpair = this.nlpa.getNLPListElement(new String(String.valueOf(param[i]) + "_" + who[j]));
                if (nvpair != null) {
                    this.whoCheckbox[j].setState(true);
                    this.checkedBox[j] = true;
                    if (i == 0) {
                        int l = 0;
                        while (l < tLevel.length) {
                            if (tLevel[l].equalsIgnoreCase(nvpair.getAtom())) break;
                            ++l;
                        }
                        if (l < tLevel.length) {
                            this.levelChoice[j].select(l);
                        }
                    } else {
                        this.itemText[k + i].setText("MD5");
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public boolean hasChanged() {
        if (this.saved) {
            this.saved = false;
            return false;
        }
        int i = 0;
        while (i < who.length) {
            if (!this.whoCheckbox[i].getState() && this.checkedBox[i]) {
                this.changed = true;
            }
            if (this.whoCheckbox[i].getState() && !this.checkedBox[i]) {
                this.changed = true;
            }
            ++i;
        }
        this.devTrc("NetChksum hasChanged=" + this.changed);
        return this.changed;
    }

    public void discard() {
        int i = 0;
        while (i < LEVELCHK_LABEL.length) {
            this.itemText[i].setText("");
            ++i;
        }
    }

    public NetButton createNetButton() {
        this.devTrc("NetChksum: createNetButton()");
        NetButton netButton = new NetButton(this.netChksumButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetChksum: buttonPushed()");
        if (label.equalsIgnoreCase(this.netChksumButton[0])) {
            this.devTrc("NetChksum: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICanoIntegrity");
        }
    }

    public void removeAll(int index) {
        int i = 0;
        while (i < param.length) {
            String par = new String(String.valueOf(param[i]) + "_" + who[index]);
            this.devTrc("NetChksum: removeAll" + par);
            this.nlpa.removeNLPListElement(par);
            ++i;
        }
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }
}

