/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.NetBEncryp;
import oracle.net.asst.security.NetEncrypCli;
import oracle.net.asst.security.NetEncrypSrv;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetEncryp
extends NetLayout
implements ItemListener,
ProfileCache,
NetButtonListener {
    private final NetStrings netStrings = new NetStrings();
    private static final String[] supportedEncrypSrv = new String[]{"SERVER", "CLIENT"};
    private static final String[] NET_ENCRYP_BUTTONS = new String[]{"PFChelp"};
    private static final String ENCRYP_LABEL = "PFCselectENC";
    private static final String NET_ENCRYP_HELP_TOPIC = "TOPICanoEncryption";
    private EwtContainer tpanel;
    private LWChoice encrypSrvChoice;
    private CardLayout encrypCardLayout;
    private EwtContainer encrypDisplay;
    private NetBEncryp[] encrypService = new NetBEncryp[supportedEncrypSrv.length];
    private String[] netEncrypButton = new String[NET_ENCRYP_BUTTONS.length];
    private NLParamParser nlpa;
    NVPair encryp;
    private int currentEncrypSrv = 0;
    private boolean changed = false;
    private int invalidPanel;

    public NetEncryp() {
        int i = 0;
        while (i < NET_ENCRYP_BUTTONS.length) {
            this.netEncrypButton[i] = this.netStrings.getString(NET_ENCRYP_BUTTONS[i]);
            ++i;
        }
        this.encrypDisplay = new EwtContainer();
        this.encrypCardLayout = new CardLayout();
        this.encrypDisplay.setLayout(this.encrypCardLayout);
        this.encrypSrvChoice = new LWChoice();
        this.encrypSrvChoice.addItemListener((ItemListener)this);
        int i2 = 0;
        while (i2 < supportedEncrypSrv.length) {
            this.encrypSrvChoice.addItem(supportedEncrypSrv[i2]);
            this.encrypService[i2] = this.createEncryp(supportedEncrypSrv[i2]);
            this.encrypDisplay.add(supportedEncrypSrv[i2], (Component)((Object)this.encrypService[i2]));
            ++i2;
        }
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        ((Container)((Object)this)).add((Component)new LWLabel(this.netStrings.getString(ENCRYP_LABEL), 1), gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.insets.left = 3;
        ((Container)((Object)this)).add((Component)this.encrypSrvChoice, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        ((Container)((Object)this)).add((Component)this.encrypDisplay, gbc);
        this.displayEncryp(supportedEncrypSrv[0]);
    }

    public NetEncryp(NVPair encrypSrv) {
        this();
        this.currentEncrypSrv = this.chooseEncryp(encrypSrv);
        this.displayEncryp(supportedEncrypSrv[this.currentEncrypSrv]);
        this.encrypService[this.currentEncrypSrv].setEncryp(encrypSrv);
    }

    public void itemStateChanged(ItemEvent e) {
        this.devTrc("NetEncryp: itemStateChanged():");
        Object source = e.getSource();
        if (source instanceof LWChoice) {
            this.displayEncryp(e.getItem().toString());
            this.currentEncrypSrv = this.chooseEncryp(e.getItem().toString());
        }
    }

    public NVPair getEncryp() {
        this.devTrc("NetEncryp: getEncryp():");
        return this.encrypService[this.currentEncrypSrv].getEncryp();
    }

    private void displayEncryp(String encrypService) {
        this.devTrc("NetEncryp: displayEncryp():");
        this.encrypCardLayout.show((Container)this.encrypDisplay, encrypService);
        this.encrypSrvChoice.select(encrypService);
    }

    private NetBEncryp createEncryp(String encrypService) {
        this.devTrc("NetEncryp: createEncryp():");
        if (encrypService.equalsIgnoreCase("SERVER")) {
            return new NetEncrypSrv();
        }
        if (encrypService.equalsIgnoreCase("CLIENT")) {
            return new NetEncrypCli();
        }
        return null;
    }

    private int chooseEncryp(String encrypService) {
        this.devTrc("NetEncryp: chooseEncryp(String):");
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            if (encrypService.equalsIgnoreCase(supportedEncrypSrv[i])) break;
            ++i;
        }
        return i;
    }

    private int chooseEncryp(NVPair address) {
        NVNavigator nvnav = new NVNavigator();
        NVPair nvpair = nvnav.findNVPair(address, "Encryp Service");
        String encrypService = nvpair.getAtom();
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            if (encrypService.equalsIgnoreCase(supportedEncrypSrv[i])) break;
            ++i;
        }
        return i;
    }

    public void setEncryp(NVPair encrypType) {
        this.devTrc("NetEncryp: setAuth():");
        this.encryp = encrypType;
        this.refresh();
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("setting NLPA");
        this.nlpa = nlpaParam;
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            this.encrypService[i].setNLP(this.nlpa);
            ++i;
        }
    }

    public boolean hasChanged() {
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            if (this.encrypService[i].hasChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void cacheIt() {
        this.devTrc("NetEncryp: cacheIt():");
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            this.encrypService[i].cacheIt();
            ++i;
        }
    }

    public void refresh() {
        this.devTrc("NetEncryp: refresh():");
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            this.encrypService[i].refresh();
            ++i;
        }
    }

    public void discard() {
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            this.encrypService[i].discard();
            ++i;
        }
    }

    public NetButton createNetButton() {
        this.devTrc("NetEncryp: createNetButton()");
        NetButton netButton = new NetButton(this.netEncrypButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetEncryp: buttonPushed()");
        if (label.equalsIgnoreCase(this.netEncrypButton[0])) {
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show(NET_ENCRYP_HELP_TOPIC);
        }
    }

    public boolean areDataValid() {
        int i = 0;
        while (i < supportedEncrypSrv.length) {
            if (!this.encrypService[i].areDataValid()) {
                this.invalidPanel = i;
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setFocus() {
        this.displayEncryp(supportedEncrypSrv[this.invalidPanel]);
        this.encrypService[this.invalidPanel].setFocus();
    }
}

