/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.security.NetBAuthParam;
import oracle.net.common.NetGetEnv;
import oracle.net.nl.NVPair;

public class NetRADAuth
extends NetBAuthParam {
    private static final String authService = "RADIUS";
    private static final String oracle_home;
    private static final String[] paramStrings;
    private static final String[] paramNames;
    private static final String[] solarisDefaults;
    private static final String[] ntDefaults;

    public NetRADAuth() {
        super(authService, paramStrings, paramNames, null, null, solarisDefaults, ntDefaults);
    }

    public NetRADAuth(NVPair authService) {
        this();
        this.setAuth(authService);
    }

    public void keyTyped(KeyEvent evt) {
        Component comp = evt.getComponent();
        char ch = evt.getKeyChar();
        this.devTrc("NetRADAuth : keyTyped()");
        this.hasChanged = true;
        if (!this.validateCharset(ch)) {
            evt.setKeyChar('\u0000');
        }
    }

    public boolean areDataValid() {
        this.devTrc("NetBAuthParam areDataValid:");
        int paramLen = this.authParamText.length;
        String s = this.authParamText[0].getText();
        if (!this.netValidate.validateHostName(this.authParamText[0])) {
            this.currentField = 0;
            return false;
        }
        int i = 1;
        while (i <= 3) {
            if (!this.netValidate.validateNumber(this.authParamText[i], 0, Integer.MAX_VALUE) || this.authParamText[i].getText().equals("")) {
                this.currentField = i;
                return false;
            }
            ++i;
        }
        this.devTrc("NetBAuthParam areDataValid:true");
        this.currentField = -1;
        return true;
    }

    public void setFocus() {
        this.devTrc("NetBAuthParam : setFocus():currentField:" + this.currentField);
        LWTextField f = this.authParamText[this.currentField];
        if (this.currentField != -1) {
            this.netValidate.showDialog(this.authParamName[this.currentField]);
            f.requestFocus();
            f.selectAll();
        }
    }

    static {
        String tmpString = NetGetEnv.getOracleHome();
        int i = tmpString.length() - 1;
        while (i >= 0) {
            if (tmpString.charAt(i) != File.separatorChar) break;
            tmpString = tmpString.substring(0, i + 1);
            --i;
        }
        oracle_home = String.valueOf(tmpString) + File.separatorChar;
        paramStrings = new String[]{"PFCRADParamPrimaryHost", "PFCRADParamPrimaryPort", "PFCRADParamPrimaryTimeout", "PFCRADParamPrimaryRetries", "PFCRADParamSecretFile", "PFCRADParamSendAccounting", "PFCRADParamChallengeResponse", "PFCRADParamChallengeKeyword", "PFCRADParamAuthInterface"};
        paramNames = new String[]{"sqlnet.radius_authentication", "sqlnet.radius_authentication_port", "sqlnet.radius_authentication_timeout", "sqlnet.radius_authentication_retries", "sqlnet.radius_secret", "sqlnet.radius_send_accounting", "sqlnet.radius_challenge_response", "sqlnet.radius_default_challenge_keyword", "sqlnet.radius_authentication_interface"};
        solarisDefaults = new String[]{"localhost", "1645", "15", "3", String.valueOf(oracle_home) + "network/security/radius.key", "OFF", "OFF", "challenge", "DefaultRadiusInterface"};
        ntDefaults = new String[]{"localhost", "1645", "15", "3", String.valueOf(oracle_home) + "network\\security\\radius.key", "OFF", "OFF", "challenge", "DefaultRadiusInterface"};
    }
}

