/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetContainer;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NullFieldDialog;
import oracle.net.asst.listener.ListenerComponent;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.SSLCipherSuitePanel;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetSSL
extends NetLayout
implements ProfileCache,
NetButtonListener,
ItemListener {
    private static final String walletParam = "oss.source.my_wallet";
    private static final String suiteParam = "ssl_cipher_suites";
    private static final String versionParam = "ssl_version";
    private static final String clientParam = "ssl_client_authentication";
    private static final NetStrings netStrings = new NetStrings();
    private static final String STATE_NONE = "NONE";
    private static final String STATE_CLIENT = netStrings.getString("PFCSSLclient");
    private static final String STATE_SERVER = netStrings.getString("PFCSSLserver");
    private String instructionString;
    private final String roleChooserString = netStrings.getString("PFCSSLrole");
    private final String walletLabelString = netStrings.getString("PFCSSLwallet");
    private final String chooseWalletString = netStrings.getString("PFCSSLchooseWallet");
    private final String walletDialogString = netStrings.getString("PFCSSLwalletDialog");
    private final String clientAuthString = netStrings.getString("PFCSSLclientAuth");
    private final String browseButtonString = netStrings.getString("PFCSSLbrowse");
    private final String sslVersionString = netStrings.getString("PFCSSLversion");
    private final String anyVersionString = netStrings.getString("PFCSSLanyVersion");
    private final String messageStringClient = netStrings.getString("PFCSSLmessageClient");
    private final String messageStringServer = netStrings.getString("PFCSSLmessageServer");
    private final String[] helpButtonString = new String[]{netStrings.getString("PFChelp")};
    private final String netSSLHelpFile = "TOPICanoSSL";
    private final String[] versions = new String[]{this.anyVersionString, "3.0"};
    private LWTextField walletField;
    private LWChoice versionChoice;
    private MultiLineLabel message;
    private LWLabel versionLabel;
    private LWLabel walletLabel;
    private LWLabel cipherSuiteLabel;
    private LWCheckboxGroup roleBoxGroup;
    private LWCheckbox clientAuthBox;
    private LWCheckbox domesticBox;
    private LWCheckbox roleClientBox;
    private LWCheckbox roleServerBox;
    private LWButton browseButton;
    private LWButton promoteButton;
    private LWButton demoteButton;
    private LWButton addButton;
    private LWButton removeButton;
    private SSLCipherSuitePanel csPanel;
    private GroupBoxContainer groupBoxPanel;
    private EwtContainer componentPanel;
    private EwtContainer roleChooser;
    private EwtContainer messagePanel;
    private boolean changed = false;
    private boolean guiInitialized = false;
    private boolean fontInitialized = false;
    private String state = "NONE";
    private NLParamParser nlpa;
    private Container treeParent;
    private Component invalidField;
    private GridBagConstraints gbc = new GridBagConstraints();
    private Component[] allComponents;

    public NetSSL() {
        try {
            this.instructionString = netStrings.getString("PFCSSLinstructions");
        }
        catch (MissingResourceException missingResourceException) {
            this.instructionString = "";
        }
        this.roleChooser = new EwtContainer();
        this.roleChooser.setLayout(new FlowLayout(1, 0, 0));
        this.roleChooser.add((Component)new LWLabel(this.roleChooserString));
        this.roleBoxGroup = new LWCheckboxGroup();
        this.roleClientBox = new LWCheckbox(STATE_CLIENT, false, this.roleBoxGroup);
        this.roleClientBox.addItemListener((ItemListener)this);
        this.roleServerBox = new LWCheckbox(STATE_SERVER, false, this.roleBoxGroup);
        this.roleServerBox.addItemListener((ItemListener)this);
        this.roleChooser.add((Component)this.roleClientBox);
        this.roleChooser.add((Component)new LWLabel("  "));
        this.roleChooser.add((Component)this.roleServerBox);
        this.walletLabel = new LWLabel(this.walletLabelString);
        this.walletField = new LWTextField();
        this.walletField.addKeyListener(new 1());
        this.versionLabel = new LWLabel(this.sslVersionString);
        this.versionChoice = new LWChoice();
        this.versionChoice.addItemListener((ItemListener)this);
        int i = 0;
        while (i < this.versions.length) {
            this.versionChoice.addItem(this.versions[i]);
            ++i;
        }
        this.browseButton = new LWButton(this.browseButtonString);
        this.browseButton.addActionListener((ActionListener)new 2());
        this.message = new MultiLineLabel(WordWrapper.getTextWrapper(), this.instructionString);
        this.message.setPreferredAspectRatio(15.0f);
        this.messagePanel = new EwtContainer();
        this.messagePanel.setLayout(new BorderLayout());
        this.messagePanel.setBorderPainter((BorderPainter)new FixedBorderPainter(2, 10, 0, 10));
        this.messagePanel.add((Component)this.message, "Center");
        this.csPanel = new SSLCipherSuitePanel(null);
        this.clientAuthBox = new LWCheckbox(this.clientAuthString, true);
        this.clientAuthBox.addItemListener((ItemListener)this);
        this.componentPanel = new EwtContainer();
        this.componentPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 10, 5, 10));
        this.componentPanel.setLayout(new GridBagLayout());
        this.groupBoxPanel = new GroupBoxContainer();
        this.groupBoxPanel.setTitle((Component)this.roleChooser);
        this.groupBoxPanel.setContent((Component)this.componentPanel);
        this.layoutComponents();
        this.allComponents = new Component[]{this.walletLabel, this.walletField, this.cipherSuiteLabel, this.csPanel, this.versionLabel, this.versionChoice, this.clientAuthBox, this.browseButton};
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 10, 5, 10));
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 0));
        ((Container)((Object)this)).add((Component)this.groupBoxPanel, "Center");
        ((Container)((Object)this)).add((Component)this.messagePanel, "South");
        ((Component)((Object)this)).addComponentListener(new 3());
    }

    public NetSSL(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.fontInitialized) {
            Font mf = this.message.getFont();
            if (mf != null) {
                this.message.setFont(new Font(mf.getName(), mf.getStyle(), mf.getSize() - 2));
            }
            this.fontInitialized = true;
        }
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        if (this.state == STATE_NONE) {
            return;
        }
        try {
            String wallet = this.walletField.getText();
            if (wallet == null || wallet == "") {
                throw new NullPointerException("Null wallet string in NetSSL");
            }
            String walletString = "oss.source.my_wallet=(SOURCE=(METHOD=FILE)(METHOD_DATA=(DIRECTORY=" + wallet + ")))";
            NetContainer cont = NetUtils.getApplication().getContainer();
            ListenerComponent lcomp = (ListenerComponent)cont.getListenerComponent();
            lcomp.getNLPA().addNLPListElement(walletString);
            this.nlpa.addNLPListElement(walletString);
            String ver = this.versionChoice.getSelectedItem();
            if (ver == this.anyVersionString) {
                ver = "0";
            }
            this.nlpa.addNLPListElement("ssl_version=" + ver);
            String[] suites = this.csPanel.getSelectedSuites();
            String catSuites = "";
            if (suites.length == 0) {
                this.nlpa.removeNLPListElement(suiteParam);
            } else {
                String prepend = "";
                int i = 0;
                while (i < suites.length) {
                    if (suites[i] != null) {
                        catSuites = String.valueOf(catSuites) + prepend + suites[i];
                        prepend = ", ";
                    }
                    ++i;
                }
                if (catSuites == null || catSuites == "") {
                    this.nlpa.removeNLPListElement(suiteParam);
                } else {
                    this.nlpa.addNLPListElement("ssl_cipher_suites=( " + catSuites + " )");
                }
            }
            if (this.clientAuthBox.getState()) {
                this.nlpa.addNLPListElement("ssl_client_authentication=TRUE");
            } else {
                this.nlpa.addNLPListElement("ssl_client_authentication=FALSE");
            }
            this.changed = false;
            this.csPanel.setChanged(false);
        }
        catch (NLException e) {
            System.err.println(e);
        }
    }

    public void refresh() {
        NVNavigator nav = new NVNavigator();
        NVPair val = null;
        NVPair element = null;
        Vector<String> suites = new Vector<String>(10, 5);
        this.state = STATE_NONE;
        val = this.nlpa.getNLPListElement(walletParam);
        if (val != null && (element = nav.findNVPairRecurse(val, "DIRECTORY")) != null) {
            this.walletField.setText(element.getAtom());
            this.state = STATE_CLIENT;
        }
        val = null;
        element = null;
        val = this.nlpa.getNLPListElement(suiteParam);
        if (val != null) {
            int i = 0;
            while (i < val.getListSize()) {
                element = val.getListElement(i);
                suites.addElement(element.getAtom());
                ++i;
            }
            String[] sSuites = new String[suites.size()];
            int j = 0;
            while (j < sSuites.length) {
                sSuites[j] = (String)suites.elementAt(j);
                ++j;
            }
            this.csPanel.setSelectedSuites(sSuites);
            this.state = STATE_CLIENT;
        }
        val = null;
        element = null;
        val = this.nlpa.getNLPListElement(versionParam);
        if (val != null) {
            String ver = val.getAtom();
            if (ver != null) {
                if (ver == "0" || ver == "0.0") {
                    this.versionChoice.select(this.anyVersionString);
                } else {
                    int i = this.versions.length - 1;
                    while (i >= 0) {
                        if (ver == this.versions[i]) {
                            this.versionChoice.select(ver);
                        }
                        --i;
                    }
                }
                this.state = STATE_CLIENT;
            }
        } else {
            this.versionChoice.select(0);
        }
        val = null;
        element = null;
        val = this.nlpa.getNLPListElement(clientParam);
        if (val != null) {
            String _state = val.getAtom();
            if (_state.equalsIgnoreCase("FALSE")) {
                this.clientAuthBox.setState(false);
            }
            this.state = STATE_SERVER;
        } else {
            this.clientAuthBox.setState(true);
        }
        this.roleClientBox.setState(false);
        this.roleServerBox.setState(false);
        if (this.state == STATE_CLIENT) {
            this.roleClientBox.setState(true);
        } else if (this.state == STATE_SERVER) {
            this.roleServerBox.setState(true);
        }
        this.toggleState(this.state);
        this.changed = false;
        this.csPanel.setChanged(false);
    }

    public boolean hasChanged() {
        return this.changed || this.csPanel.hasChanged();
    }

    public void discard() {
        this.refresh();
    }

    public boolean areDataValid() {
        if (this.state == STATE_NONE) {
            return true;
        }
        String wallet = this.walletField.getText();
        if (wallet == null || wallet == "") {
            this.invalidField = this.walletField;
            return false;
        }
        return true;
    }

    public void setFocus() {
        if (this.invalidField == null) {
            return;
        }
        String message = "Field";
        if (this.invalidField == this.walletField) {
            message = this.walletLabelString.substring(0, this.walletLabelString.length() - 1);
        }
        Container parent = null;
        parent = ((Component)((Object)this)).getParent();
        while (!(parent instanceof BufferedFrame)) {
            parent = parent.getParent();
        }
        NullFieldDialog d = new NullFieldDialog((BufferedFrame)parent, message);
        Rectangle bounds = parent.getBounds();
        ((Component)((Object)d)).setLocation(bounds.x + bounds.width / 2 - ((Component)((Object)d)).getSize().width / 2, bounds.y + bounds.height / 2 - ((Component)((Object)d)).getSize().height / 2);
        ((Dialog)((Object)d)).show();
        d.dispose();
        this.invalidField.requestFocus();
        if (this.invalidField instanceof LWTextField) {
            ((LWTextField)this.invalidField).selectAll();
        }
    }

    public NetButton createNetButton() {
        NetButton netButton = new NetButton(this.helpButtonString);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        if (label.equalsIgnoreCase(this.helpButtonString[0])) {
            NetUtils.getHelpContext().show("TOPICanoSSL");
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getItem();
        if (e.getStateChange() == 1) {
            if (obj == STATE_CLIENT) {
                this.toggleState(STATE_CLIENT);
            } else if (obj == STATE_SERVER) {
                this.toggleState(STATE_SERVER);
            }
        }
    }

    private void showAllComponents(boolean state) {
        int i = 0;
        while (i < this.allComponents.length) {
            if (this.allComponents[i] != null) {
                this.allComponents[i].setVisible(state);
            }
            ++i;
        }
    }

    protected void toggleState(String newState) {
        if (newState == STATE_NONE) {
            this.showAllComponents(false);
            this.message.setText(this.instructionString);
        } else if (newState == STATE_CLIENT) {
            this.showAllComponents(true);
            this.clientAuthBox.setVisible(false);
            this.message.setText(this.messageStringClient);
        } else {
            this.showAllComponents(true);
            this.message.setText(this.messageStringServer);
        }
        if (this.state == STATE_NONE && newState != STATE_NONE) {
            try {
                NetContainer parent = NetUtils.getApplication().getContainer();
                ((Container)((Object)parent)).getLayout().layoutContainer((Container)((Object)parent));
                ((Container)((Object)parent)).validate();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            ((Container)((Object)this)).getLayout().layoutContainer((Container)((Object)this));
            ((Container)((Object)this)).validate();
        }
        this.state = newState;
    }

    protected void layoutComponents() {
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 1;
        this.gbc.fill = 2;
        this.gbc.anchor = 16;
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets.right = 0;
        this.gbc.insets.left = 0;
        this.gbc.insets.bottom = 0;
        this.gbc.insets.top = 0;
        this.componentPanel.add((Component)this.walletLabel, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.gbc.gridheight = 1;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 0.0;
        this.componentPanel.add((Component)this.walletField, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.insets.left = 5;
        this.componentPanel.add((Component)this.browseButton, this.gbc);
        this.gbc.insets.left = 0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 10.0;
        this.gbc.insets.top = 5;
        this.componentPanel.add((Component)((Object)this.csPanel), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 17;
        this.gbc.fill = 0;
        this.gbc.insets.top = 10;
        this.componentPanel.add((Component)this.versionLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 10.0;
        this.gbc.fill = 0;
        this.gbc.insets.left = 5;
        this.componentPanel.add((Component)this.versionChoice, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 3;
        this.gbc.anchor = 16;
        this.gbc.fill = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets.bottom = 0;
        this.gbc.insets.left = 0;
        this.gbc.insets.top = 5;
        this.componentPanel.add((Component)this.clientAuthBox, this.gbc);
    }

    protected String pickDirectory() {
        Container parent = null;
        parent = ((Component)((Object)this)).getParent();
        while (!(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        DirectoryDialog dialog = new DirectoryDialog((Frame)parent, this.chooseWalletString);
        dialog.setMessage(this.walletDialogString);
        dialog.setCenterOver((Component)parent);
        dialog.setCreateAllowed(true);
        File dir = new File(this.walletField.getText());
        if (!dir.isDirectory()) {
            dir = new File(File.separator);
        }
        if ((dir = dialog.runDialog(dir)) != null) {
            return dir.toString();
        }
        return null;
    }

    static /* synthetic */ boolean access$0(NetSSL $0) {
        return $0.changed;
    }

    private final class 1
    extends KeyAdapter {
        public void keyTyped(KeyEvent e) {
            NetSSL.this.changed = true;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String newDir = NetSSL.this.pickDirectory();
            if (newDir != null) {
                NetSSL.this.walletField.setText(newDir);
                NetSSL.this.changed = true;
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends ComponentAdapter {
        public void componentShown(ComponentEvent e) {
            if (!NetSSL.this.guiInitialized) {
                if (NetSSL.this.state != STATE_NONE) {
                    NetSSL.this.roleBoxGroup.setSelectedCheckbox(NetSSL.this.state == STATE_CLIENT ? NetSSL.this.roleClientBox : NetSSL.this.roleServerBox);
                }
                NetSSL.this.toggleState(NetSSL.this.state);
                ((Container)((Object)NetSSL.this)).getLayout().layoutContainer((Container)((Object)NetSSL.this));
                ((Container)((Object)NetSSL.this)).validate();
                NetSSL.this.guiInitialized = true;
            }
        }

        /* synthetic */ 3() {
        }
    }
}

