/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.SortableTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.event.Cancelable;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderEvent;
import oracle.ewt.header.HeaderSelectAdapter;
import oracle.ewt.header.HeaderSelectListener;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableCellSelectAdapter;
import oracle.ewt.table.TableCellSelectListener;
import oracle.ewt.table.TableEvent;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.security.SSLCipherSuitePanel;

public class SSLCipherSuitePanel
extends NetLayout
implements ActionListener {
    private static final int DLG_WIDTH = 350;
    private static final int DLG_HEIGHT = 350;
    private static Hashtable exportDict = new Hashtable(25);
    private static Hashtable domesticDict = new Hashtable(25);
    private static Hashtable toolTipDict = new Hashtable(50);
    private static final NetStrings netStrings;
    private final String[] cols = new String[]{netStrings.getString("PFCSSLCSauthentication"), netStrings.getString("PFCSSLCSencryption"), netStrings.getString("PFCSSLCSdataIntegrity")};
    private final String cipherSuiteString = netStrings.getString("PFCSSLCScipherSuite");
    private final String addButtonString = netStrings.getString("PFCSSLCSadd");
    private final String removeButtonString = netStrings.getString("PFCSSLCSremove");
    private final String promoteButtonString = netStrings.getString("PFCSSLCSpromote");
    private final String demoteButtonString = netStrings.getString("PFCSSLCSdemote");
    private ArrayOneDDataSource colLabels;
    private SortableTwoDDataSource csData;
    private static SortableTwoDDataSource allData;
    private SpreadTable csTable;
    private ScrollBox tableSBox;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton promoteButton;
    private LWButton demoteButton;
    private Grid csGrid;
    private GridSelection csSelect;
    private Header csHeader;
    private NetProperties props;
    private int csTableInnerWidth = -1;
    private boolean enableUSDomestic = false;
    private boolean changed = false;
    private boolean allDataContainsDomestic = false;

    public SSLCipherSuitePanel(String[] suites) {
        try {
            this.props = new NetProperties();
            String dom = this.props.getProperty("USDOMESTIC");
            this.enableUSDomestic = dom != null && dom.equalsIgnoreCase("YES");
        }
        catch (IOException iOException) {
            this.props = null;
            this.enableUSDomestic = true;
        }
        this.csData = this.initDataSource(suites, this.enableUSDomestic);
        this.colLabels = new ArrayOneDDataSource((Object[])this.cols);
        this.csTable = new SpreadTable((TwoDDataSource)this.csData, (OneDDataSource)this.colLabels, null);
        this.csTable.setVerticalSeparatorsVisible(false);
        this.csTable.setHorizontalSeparatorsVisible(false);
        this.csTable.addCellSelectListener((TableCellSelectListener)new 1());
        this.csHeader = this.csTable.getColumnHeader();
        this.csHeader.setCanResizeItems(true);
        this.csHeader.addSelectListener((HeaderSelectListener)new 2());
        this.csGrid = this.csTable.getGrid();
        this.csGrid.setToolTipValue((ToolTipClient)new CipherSuiteToolTipClient(this.csTable));
        this.csGrid.setPreferredRowsOnScreen(4);
        this.csGrid.setPreferredColumnsOnScreen(3);
        this.csSelect = this.csGrid.getGridSelection();
        this.tableSBox = new ScrollBox((Component)this.csTable, 2, 0);
        this.addButton = new LWButton(this.addButtonString);
        this.addButton.setActionCommand("ADD");
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeButtonString);
        this.removeButton.setActionCommand("REMOVE");
        this.removeButton.addActionListener((ActionListener)this);
        this.promoteButton = new LWButton();
        this.promoteButton.setActionCommand("PROMOTE");
        this.promoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.upArrow"), 1));
        this.promoteButton.setFocusable(false);
        this.promoteButton.addActionListener((ActionListener)this);
        this.demoteButton = new LWButton();
        this.demoteButton.setActionCommand("DEMOTE");
        this.demoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.downArrow"), 1));
        this.demoteButton.setFocusable(false);
        this.demoteButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.left = 5;
        gbc.insets.top = 5;
        ((Container)((Object)this)).add((Component)this.tableSBox, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 5.0;
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.insets.top = 1;
        gbc.insets.bottom = 1;
        ((Container)((Object)this)).add((Component)this.promoteButton, gbc);
        ++gbc.gridy;
        gbc.anchor = 11;
        ((Container)((Object)this)).add((Component)this.demoteButton, gbc);
        EwtContainer buttonPanel = new EwtContainer();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add((Component)this.addButton);
        buttonPanel.add((Component)this.removeButton);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets.top = 4;
        gbc.insets.bottom = 5;
        gbc.anchor = 10;
        gbc.fill = 0;
        ((Container)((Object)this)).add((Component)buttonPanel, gbc);
        this.setBorderPainter(UIManager.createGroupBoxPainter((String)this.cipherSuiteString));
        if (this.csGrid.getRowCount() != 0) {
            this.csSelect.setRowSelected(0, true);
        }
    }

    public void setSelectedSuites(String[] suites) {
        this.csTable.setDataSources((TwoDDataSource)this.initDataSource(suites, this.enableUSDomestic), (OneDDataSource)this.colLabels, null);
        this.csGrid = this.csTable.getGrid();
        this.csData = (SortableTwoDDataSource)this.csGrid.getDataSource();
        this.csTableInnerWidth = -1;
    }

    public void paint(Graphics g) {
        int _width = this.csTable.getInnerSize().width;
        if (this.csTableInnerWidth != _width) {
            int colWidth = _width / this.cols.length;
            int i = 0;
            while (i < this.cols.length) {
                this.csTable.setColumnWidth(i, colWidth);
                ++i;
            }
            this.csTableInnerWidth = _width;
        }
        super.paint(g);
    }

    public String[] getSelectedSuites() {
        String suite = "";
        String append = "";
        String newSuite = null;
        String[] suites = new String[this.csData.getRowCount()];
        int i = 0;
        while (i < suites.length) {
            int j = 0;
            while (j < this.cols.length) {
                suite = String.valueOf(suite) + append + (String)this.csData.getData(j, i);
                append = "*";
                ++j;
            }
            newSuite = this.unHashSuite(suite);
            if (newSuite == null) {
                throw new NullPointerException("null suite");
            }
            suites[i] = newSuite;
            append = "";
            suite = "";
            ++i;
        }
        return suites;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean state) {
        this.changed = state;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ADD")) {
            String[] newSuite = null;
            BufferedFrame fr = this.findParentFrame();
            SuiteDialog dialog = new SuiteDialog(fr, true);
            ((Component)((Object)dialog)).setSize(350, 350);
            Rectangle bounds = fr.getBounds();
            ((Component)((Object)dialog)).setLocation(bounds.x + bounds.width / 2 - 175, bounds.y + bounds.height / 2 - 175);
            ((Component)((Object)dialog)).setVisible(true);
            String os = System.getProperty("os.name");
            if (os.equals("Windows 95") || os.equals("Windows NT")) {
                fr.toFront();
            }
            if ((newSuite = dialog.getSelectedSuite()) != null) {
                this.changed = true;
                boolean dup = false;
                int rows = this.csData.getRowCount();
                int j = 0;
                while (j < rows) {
                    if (((String)this.csData.getData(0, j)).equals(newSuite[0]) && ((String)this.csData.getData(1, j)).equals(newSuite[1]) && ((String)this.csData.getData(2, j)).equals(newSuite[2])) {
                        dup = true;
                        break;
                    }
                    ++j;
                }
                if (!dup) {
                    int newRow = 0;
                    int[] selRows = this.csSelect.getSelectedRows();
                    newRow = selRows == null || selRows.length == 0 ? rows : selRows[0] + 1;
                    this.csData.addRows(newRow, 1);
                    int i = 0;
                    while (i < newSuite.length) {
                        this.csData.setData(i, newRow, (Object)newSuite[i]);
                        ++i;
                    }
                    if (selRows != null && selRows.length != 0) {
                        this.csSelect.setRowSelected(selRows[0], false);
                    }
                    this.csSelect.setRowSelected(newRow, true);
                }
            }
        } else if (command.equals("REMOVE")) {
            int[] rows = this.csSelect.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            this.csData.removeRows(rows[0], 1);
            this.changed = true;
            if (this.csData.getRowCount() == 0) {
                return;
            }
            if (rows[0] == 0) {
                this.csSelect.setRowSelected(0, true);
            } else {
                this.csSelect.setRowSelected(rows[0] - 1, true);
            }
        } else if (command.equals("PROMOTE")) {
            if (this.moveSelectedRow(1)) {
                this.changed = true;
            }
        } else if (command.equals("DEMOTE") && this.moveSelectedRow(-1)) {
            this.changed = true;
        }
    }

    private boolean moveSelectedRow(int direction) {
        direction = direction >= 0 ? -1 : 1;
        int[] rows = this.csSelect.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return false;
        }
        if (direction == -1 && rows[0] == 0) {
            return false;
        }
        if (direction == 1 && rows[0] == this.csData.getRowCount() - 1) {
            return false;
        }
        Object[] temp = new Object[this.csData.getColumnCount()];
        int i = 0;
        while (i < temp.length) {
            temp[i] = this.csData.getData(i, rows[0]);
            ++i;
        }
        int i2 = 0;
        while (i2 < temp.length) {
            this.csData.setData(i2, rows[0], this.csData.getData(i2, rows[0] + direction));
            ++i2;
        }
        int i3 = 0;
        while (i3 < temp.length) {
            this.csData.setData(i3, rows[0] + direction, temp[i3]);
            ++i3;
        }
        this.csSelect.setRowSelected(rows[0], false);
        this.csSelect.setRowSelected(rows[0] + direction, true);
        int selectedRow = this.csSelect.getSelectedRows()[0];
        int firstVisRow = this.csTable.getFirstRowOnScreen();
        if (!this.csGrid.isRowOnScreen(selectedRow) || selectedRow < firstVisRow) {
            if (selectedRow < firstVisRow) {
                this.csTable.setFirstRowOnScreen(selectedRow);
            } else {
                firstVisRow = selectedRow - this.csTable.getOnScreenRowCount() + 1;
                this.csTable.setFirstRowOnScreen(firstVisRow);
            }
        }
        return true;
    }

    private SortableTwoDDataSource initDataSource(String[] selected, boolean domestic) {
        if (selected == null) {
            return new SortableTwoDDataSource(this.cols.length, 0);
        }
        int count = 0;
        int i = 0;
        while (i < selected.length) {
            if (exportDict.get(selected[i]) != null || domestic && domesticDict.get(selected[i]) != null) {
                ++count;
            }
            ++i;
        }
        SortableTwoDDataSource data = new SortableTwoDDataSource(this.cols.length, count);
        int row = 0;
        int i2 = 0;
        while (i2 < selected.length) {
            String[] parms = this.parseSuite((String)exportDict.get(selected[i2]));
            if (parms == null && domestic) {
                parms = this.parseSuite((String)domesticDict.get(selected[i2]));
            }
            if (parms != null) {
                int j = 0;
                while (j < parms.length) {
                    data.setData(j, row, (Object)parms[j]);
                    ++j;
                }
                ++row;
            }
            ++i2;
        }
        return data;
    }

    private BufferedFrame findParentFrame() {
        Container parent = ((Component)((Object)this)).getParent();
        while (!(parent instanceof BufferedFrame)) {
            parent = parent.getParent();
        }
        if (parent instanceof BufferedFrame) {
            return (BufferedFrame)parent;
        }
        return null;
    }

    private String unHashSuite(String suite) {
        String elem;
        Enumeration e = exportDict.keys();
        while (e.hasMoreElements()) {
            elem = (String)e.nextElement();
            if (suite.compareTo((String)exportDict.get(elem)) != 0) continue;
            return elem;
        }
        if (this.enableUSDomestic) {
            e = domesticDict.keys();
            while (e.hasMoreElements()) {
                elem = (String)e.nextElement();
                if (suite.compareTo((String)domesticDict.get(elem)) != 0) continue;
                return elem;
            }
        }
        return null;
    }

    private String[] parseSuite(String str) {
        String[] suite = new String[3];
        if (str == null) {
            return null;
        }
        int i = 0;
        StringTokenizer tok = new StringTokenizer(str, "*");
        while (tok.hasMoreTokens() && i < 3) {
            suite[i++] = tok.nextToken();
        }
        return suite;
    }

    private String getToolTipByCell(TwoDDataSource data, int row, int col) {
        if (row < 0 || row >= data.getRowCount() || col < 0 || col >= data.getColumnCount()) {
            return null;
        }
        Object datum = data.getData(col, row);
        if (datum == null) {
            return null;
        }
        return (String)toolTipDict.get(datum);
    }

    static /* synthetic */ NetStrings access$2() {
        return netStrings;
    }

    static {
        domesticDict.put("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "RSA*3DES_EDE_CBC*SHA");
        domesticDict.put("SSL_RSA_WITH_RC4_128_MD5", "RSA*RC4_128*MD5");
        domesticDict.put("SSL_RSA_WITH_RC4_128_SHA", "RSA*RC4_128*SHA");
        domesticDict.put("SSL_RSA_WITH_DES_CBC_SHA", "RSA*DES_CBC*SHA");
        domesticDict.put("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "DH_anon*3DES_EDE_CBC*SHA");
        domesticDict.put("SSL_DH_anon_WITH_RC4_128_MD5", "DH_anon*RC4_128*MD5");
        domesticDict.put("SSL_DH_anon_WITH_DES_CBC_SHA", "DH_anon*DES_CBC*SHA");
        exportDict.put("SSL_RSA_EXPORT_WITH_RC4_40_MD5", "RSA_EXPORT*RC4_40*MD5");
        exportDict.put("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "RSA_EXPORT*DES40_CBC*SHA");
        exportDict.put("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "DH_anon*RC4_40*MD5");
        exportDict.put("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "DH_anon*DES40_CBC*SHA");
        exportDict.put("SSL_RSA_WITH_NULL_SHA", "RSA*NULL*SHA");
        exportDict.put("SSL_RSA_WITH_NULL_MD5", "RSA*NULL*MD5");
        toolTipDict.put("RSA_EXPORT", "RSA signature (40 bit)");
        toolTipDict.put("RSA", "RSA signature (40 bit)");
        toolTipDict.put("DH_anon", "Diffie Hellman, Anonymous (No certificate)");
        toolTipDict.put("NULL", "(No data encryption)");
        toolTipDict.put("DES", "Data Encryption Standard (56 bit)");
        toolTipDict.put("DES_CBC", "Data Encryption Standard (56 bit) - Cipher Block Chaining");
        toolTipDict.put("DES40", "Data Encryption Standard (40 bit)");
        toolTipDict.put("DES40_CBC", "Data Encryption Standard (40 bit) - Cipher Block Chaining");
        toolTipDict.put("RC4_40", "RC4 Encryption [RSA] (40 bit)");
        toolTipDict.put("RC4_128", "RC4 Encryption [RSA] (128 bit)");
        toolTipDict.put("3DES_EDE_CBC", "Data Encryption Standard (3 56 bit keys) - Cipher Block Chaining");
        toolTipDict.put("MD5", "Message Digest 5");
        toolTipDict.put("SHA", "Secure Hash Algorithm");
        netStrings = new NetStrings();
    }

    private final class 1
    extends TableCellSelectAdapter {
        public void cellSelected(TableEvent e) {
            if (e.getRow() == -1) {
                return;
            }
            int selectedRow = e.getRow();
            SSLCipherSuitePanel.this.csSelect.setRowSelected(selectedRow, true);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends HeaderSelectAdapter {
        public void itemSelecting(HeaderEvent e) {
            ((Cancelable)e).cancel();
        }

        /* synthetic */ 2() {
        }
    }

    private class SuiteDialog
    extends BufferedDialog
    implements ActionListener {
        private final String okButtonString = SSLCipherSuitePanel.access$2().getString("PFCSSLCSDok");
        private final String cancelButtonString = SSLCipherSuitePanel.access$2().getString("PFCSSLCSDcancel");
        private final String titleString = SSLCipherSuitePanel.access$2().getString("PFCSSLCSDtitle");
        private final String domesticString = SSLCipherSuitePanel.access$2().getString("PFCSSLCSDshowUSDomestic");
        private SpreadTable allTable;
        private Grid allGrid;
        private GridSelection allSelect;
        private Header allHeader;
        private ScrollBox allTableSBox;
        private EwtContainer buttonPanel;
        private LWButton okButton;
        private LWButton cancelButton;
        private LWCheckbox domesticBox;
        private String[] selectedSuite;
        private int allTableInnerWidth = -1;

        SuiteDialog(BufferedFrame owner, boolean modal) {
            super((Frame)owner, modal);
            SSLCipherSuitePanel.this = SSLCipherSuitePanel.this;
            if (allData == null) {
                allData = new SortableTwoDDataSource(SSLCipherSuitePanel.this.cols.length, 0);
                this.addExportSuites();
                allData.sort(0, false);
            }
            if (SSLCipherSuitePanel.this.enableUSDomestic) {
                this.addDomesticSuites();
            }
            this.allTable = new SpreadTable((TwoDDataSource)allData, (OneDDataSource)SSLCipherSuitePanel.this.colLabels, null);
            this.allTable.setVerticalSeparatorsVisible(false);
            this.allTable.setHorizontalSeparatorsVisible(false);
            this.allTable.addCellSelectListener((TableCellSelectListener)new 3(this));
            this.allHeader = this.allTable.getColumnHeader();
            this.allHeader.setCanResizeItems(false);
            this.allHeader.addSelectListener((HeaderSelectListener)new 4());
            this.allGrid = this.allTable.getGrid();
            SSLCipherSuitePanel sSLCipherSuitePanel = SSLCipherSuitePanel.this;
            sSLCipherSuitePanel.getClass();
            this.allGrid.setToolTipValue((ToolTipClient)sSLCipherSuitePanel.new CipherSuiteToolTipClient(this.allTable));
            this.allSelect = this.allGrid.getGridSelection();
            this.allTableSBox = new ScrollBox((Component)this.allTable, 2, 0);
            this.buttonPanel = new EwtContainer();
            this.okButton = new LWButton(this.okButtonString);
            this.okButton.setActionCommand("OK");
            this.okButton.addActionListener((ActionListener)this);
            this.cancelButton = new LWButton(this.cancelButtonString);
            this.cancelButton.setActionCommand("CANCEL");
            this.cancelButton.addActionListener((ActionListener)this);
            this.domesticBox = new LWCheckbox(this.domesticString, SSLCipherSuitePanel.this.enableUSDomestic);
            this.domesticBox.setState(SSLCipherSuitePanel.this.allDataContainsDomestic);
            this.domesticBox.setEnabled(SSLCipherSuitePanel.this.enableUSDomestic);
            this.domesticBox.addItemListener((ItemListener)new 5(this));
            this.buttonPanel.setLayout(new FlowLayout(1, 10, 5));
            this.buttonPanel.add((Component)this.okButton);
            this.buttonPanel.add((Component)this.cancelButton);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 10;
            gbc.fill = 1;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbc.insets.top = 10;
            gbc.insets.bottom = 5;
            ((Container)((Object)this)).add((Component)this.allTableSBox, gbc);
            gbc.gridy = 1;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.insets.top = 0;
            ((Container)((Object)this)).add((Component)this.domesticBox, gbc);
            gbc.gridy = 2;
            ((Container)((Object)this)).add((Component)this.buttonPanel, gbc);
            ((Dialog)((Object)this)).setTitle(this.titleString);
        }

        public String[] getSelectedSuite() {
            return this.selectedSuite;
        }

        public void paint(Graphics g) {
            if (this.allTableInnerWidth != this.allTable.getInnerSize().width) {
                this.allTableInnerWidth = this.allTable.getInnerSize().width;
                int colWidth = this.allTableInnerWidth / SSLCipherSuitePanel.this.cols.length;
                int i = 0;
                while (i < SSLCipherSuitePanel.this.cols.length) {
                    this.allTable.setColumnWidth(i, colWidth);
                    ++i;
                }
            }
            super.paint(g);
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("OK")) {
                int[] rows = this.allSelect.getSelectedRows();
                if (rows == null || rows.length == 0) {
                    this.selectedSuite = null;
                } else {
                    this.selectedSuite = new String[SSLCipherSuitePanel.this.cols.length];
                    int i = 0;
                    while (i < this.selectedSuite.length) {
                        this.selectedSuite[i] = (String)allData.getData(i, rows[0]);
                        ++i;
                    }
                }
                ((Component)((Object)this)).setVisible(false);
            } else if (cmd.equals("CANCEL")) {
                this.selectedSuite = null;
                ((Component)((Object)this)).setVisible(false);
            }
        }

        protected void addExportSuites() {
            int row = 0;
            Enumeration e = exportDict.elements();
            while (e.hasMoreElements()) {
                String[] parms = SSLCipherSuitePanel.this.parseSuite((String)e.nextElement());
                allData.addRows(row, 1);
                int col = 0;
                while (col < parms.length) {
                    allData.setData(col, row, (Object)parms[col]);
                    ++col;
                }
                ++row;
            }
        }

        protected void addDomesticSuites() {
            if (SSLCipherSuitePanel.this.allDataContainsDomestic) {
                return;
            }
            allData.addRows(exportDict.size(), domesticDict.size());
            int i = exportDict.size();
            Enumeration e = domesticDict.elements();
            String[] parms = null;
            while (e.hasMoreElements()) {
                parms = SSLCipherSuitePanel.this.parseSuite((String)e.nextElement());
                int j = 0;
                while (j < parms.length) {
                    allData.setData(j, i, (Object)parms[j]);
                    ++j;
                }
                ++i;
            }
            SSLCipherSuitePanel.this.allDataContainsDomestic = true;
        }

        protected void removeDomesticSuites() {
            if (!SSLCipherSuitePanel.this.allDataContainsDomestic) {
                return;
            }
            allData.removeRows(0, allData.getRowCount());
            this.addExportSuites();
            SSLCipherSuitePanel.this.allDataContainsDomestic = false;
        }

        static /* synthetic */ GridSelection access$0(SuiteDialog $0) {
            return $0.allSelect;
        }

        static /* synthetic */ LWCheckbox access$1(SuiteDialog $0) {
            return $0.domesticBox;
        }
    }

    private class CipherSuiteToolTipClient
    implements ToolTipClient {
        private SpreadTable table;

        public CipherSuiteToolTipClient(SpreadTable table) {
            SSLCipherSuitePanel.this = SSLCipherSuitePanel.this;
            this.table = table;
        }

        public ToolTipSite getToolTipSite(Component over, int x, int y) {
            int row = this.table.getGrid().getRowAt(y) + this.table.getFirstRowOnScreen();
            int col = this.table.getGrid().getColumnAt(x) + this.table.getFirstColumnOnScreen();
            if (row == -1) {
                return null;
            }
            String tip = SSLCipherSuitePanel.this.getToolTipByCell(this.table.getGrid().getDataSource(), row, col);
            if (tip == null) {
                return null;
            }
            return new ToolTipSite((Object)tip, this._getBoundsOfLabel(x, y), null, null);
        }

        private Rectangle _getBoundsOfLabel(int x, int y) {
            Grid grid = this.table.getGrid();
            int row = grid.getRowAt(y);
            int col = grid.getColumnAt(x);
            if (row == -1) {
                return new Rectangle(x, y, 1, 1);
            }
            return new Rectangle(grid.getColumnPosition(col), grid.getRowPosition(row), grid.getColumnWidth(col), grid.getRowHeight(row));
        }
    }
}

