/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.event.Cancelable;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addrbook.AddressList;
import oracle.net.asst.container.NetApplication;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.servicename.NetClientAddressPage;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class AddressListPanel
extends EwtContainer
implements ActionListener,
TabPanelListener,
ItemListener {
    private static final int ADV_WIDTH = 400;
    private static final int ADV_HEIGHT = 400;
    private NetStrings ns = new NetStrings();
    private String backCompatString = this.ns.getString("SNCBackCompatClient");
    private String addressString = this.ns.getString("SNCAddress");
    private String tcpString = this.ns.getString("SNCTCP");
    private String tcpsString = this.ns.getString("SNCTCPS");
    private String addressOptionString = this.ns.getString("SNCAddressOptions");
    private String newAddressString = this.ns.getString("SNCNew");
    private String deleteAddressString = this.ns.getString("SNCDelete");
    private String promoteAddressString = this.ns.getString("SNCPromote");
    private String demoteAddressString = this.ns.getString("SNCDemote");
    private String optionsString = this.ns.getString("SNCAdvanced");
    private String optionLBString = this.ns.getString("SNCAddrOptionLB");
    private String optionDefaultString = this.ns.getString("SNCAddrOptionDefault");
    private String optionNoFOString = this.ns.getString("SNCAddrOptionNoFO");
    private String optionSRString = this.ns.getString("SNCAddrOptionSR");
    private String optionNoneString = this.ns.getString("SNCAddrOptionNone");
    private String advancedTitleString = this.ns.getString("SNCAdvancedDialogTitle");
    private String addressOptionGroupString = this.ns.getString("SNCAddressOptionGroup");
    private String okString = this.ns.getString("SNCOK");
    private String cancelString = this.ns.getString("SNCCancel");
    private String helpString = this.ns.getString("SNCHelp");
    private String helpTopicString = "TOPICsnAdvancedAList";
    private TabPanel tabPanel;
    private NetClientAddressPage newPage;
    private NetClientAddressPage currPage;
    private LWButton newButton;
    private LWButton deleteButton;
    private LWButton optionsButton;
    private LWButton promoteButton;
    private LWButton demoteButton;
    private LWButton okButton;
    private LWButton cancelButton;
    private LWButton helpButton;
    private LWCheckbox backCompatBox;
    private LWCheckboxGroup cbg;
    private LWCheckbox optionBoxLB;
    private LWCheckbox optionBoxDefault;
    private LWCheckbox optionBoxNoFO;
    private LWCheckbox optionBoxSR;
    private LWCheckbox optionBoxNone;
    private EwtContainer addressPanel;
    private EwtContainer newDeletePanel;
    private EwtContainer optionGroupPanel;
    private EwtContainer advancedPanel;
    private EwtContainer buttonPanel;
    private BufferedDialog advancedDialog;
    private GridBagConstraints gbc = new GridBagConstraints();
    LWCheckbox currentCheckbox;
    boolean currentBCState;
    private boolean enabled = true;
    private boolean changed = false;
    private boolean dialogChanged = false;
    private int addrCounter = 1;
    private WebApplication app;
    private AddressList aList;

    public AddressListPanel(AddressList aList, WebApplication app) {
        this.app = app;
        this.aList = aList;
        this.currPage = null;
        this.tabPanel = new TabPanel();
        this.tabPanel.addTabPanelListener((TabPanelListener)this);
        int nSize = aList.getNumAddresses();
        if (nSize != 0) {
            int i = 0;
            while (i < nSize) {
                Address address = aList.getAddressAt(i);
                Integer addrNum = new Integer(this.addrCounter);
                String addrStr = addrNum.toString();
                NetClientAddressPage addrPage = new NetClientAddressPage(app);
                addrPage.setAddressInfo(address);
                this.tabPanel.addPage(String.valueOf(this.addressString) + addrStr, (Component)((Object)addrPage));
                ++i;
                ++this.addrCounter;
            }
        } else {
            Integer addrNum = new Integer(this.addrCounter);
            String addrStr = addrNum.toString();
            this.newPage = new NetClientAddressPage(app);
            this.changed = true;
            TabPanelPage tabPanelPage = this.tabPanel.addPage(String.valueOf(this.addressString) + addrStr, (Component)((Object)this.newPage));
            ++this.addrCounter;
        }
        this.newDeletePanel = new EwtContainer();
        Toolkit tk = this.newDeletePanel.getToolkit();
        String imageDir = NetUtils.getImageDirectory();
        this.newButton = new LWButton();
        this.newButton.setImage(tk.getImage(String.valueOf(imageDir) + "create.gif"));
        this.newButton.setActionCommand("NEW");
        this.newButton.setLeftmost(true);
        this.newButton.setFocusable(false);
        this.newButton.addActionListener((ActionListener)this);
        this.deleteButton = new LWButton();
        this.deleteButton.setImage(tk.getImage(String.valueOf(imageDir) + "delete.gif"));
        this.deleteButton.setActionCommand("DELETE");
        this.deleteButton.setRightmost(true);
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener((ActionListener)this);
        this.promoteButton = new LWButton();
        this.promoteButton.setActionCommand("PROMOTE");
        this.promoteButton.setLeftmost(true);
        this.promoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.leftArrow"), 1));
        this.promoteButton.setFocusable(false);
        this.promoteButton.addActionListener((ActionListener)this);
        this.demoteButton = new LWButton();
        this.demoteButton.setActionCommand("DEMOTE");
        this.demoteButton.setRightmost(true);
        this.demoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.rightArrow"), 1));
        this.demoteButton.setFocusable(false);
        this.demoteButton.addActionListener((ActionListener)this);
        this.optionsButton = new LWButton(this.optionsString);
        this.optionsButton.setLeftmost(true);
        this.optionsButton.setRightmost(true);
        this.optionsButton.setActionCommand("ADVANCED");
        this.optionsButton.setFocusable(false);
        this.optionsButton.addActionListener((ActionListener)this);
        this.newDeletePanel.setLayout(new GridBagLayout());
        GridBagConstraints ndgbc = new GridBagConstraints();
        ndgbc.gridy = 0;
        ndgbc.gridx = 0;
        ndgbc.gridheight = 1;
        ndgbc.gridwidth = 1;
        ndgbc.fill = 3;
        ndgbc.anchor = 17;
        ndgbc.weighty = 1.0;
        ndgbc.weightx = 0.0;
        ndgbc.insets.right = 3;
        this.newDeletePanel.add((Component)this.newButton, ndgbc);
        ++ndgbc.gridx;
        this.newDeletePanel.add((Component)this.deleteButton, ndgbc);
        ++ndgbc.gridx;
        this.newDeletePanel.add((Component)this.promoteButton, ndgbc);
        ++ndgbc.gridx;
        this.newDeletePanel.add((Component)this.demoteButton, ndgbc);
        ++ndgbc.gridx;
        ndgbc.weightx = 1.0;
        ndgbc.anchor = 13;
        ndgbc.fill = 0;
        ndgbc.insets.right = 0;
        this.newDeletePanel.add((Component)this.optionsButton, ndgbc);
        this.addressPanel = new EwtContainer();
        this.addressPanel.setLayout(new BorderLayout(0, 3));
        this.addressPanel.add((Component)this.tabPanel, "Center");
        this.addressPanel.add((Component)this.newDeletePanel, "South");
        this.cbg = new LWCheckboxGroup();
        this.optionBoxLB = new LWCheckbox(this.optionLBString, this.cbg, false);
        this.optionBoxDefault = new LWCheckbox(this.optionDefaultString, this.cbg, false);
        this.optionBoxNoFO = new LWCheckbox(this.optionNoFOString, this.cbg, false);
        this.optionBoxSR = new LWCheckbox(this.optionSRString, this.cbg, false);
        this.optionBoxNone = new LWCheckbox(this.optionNoneString, this.cbg, false);
        this.optionBoxLB.addItemListener((ItemListener)this);
        this.optionBoxDefault.addItemListener((ItemListener)this);
        this.optionBoxNoFO.addItemListener((ItemListener)this);
        this.optionBoxSR.addItemListener((ItemListener)this);
        this.optionBoxNone.addItemListener((ItemListener)this);
        this.optionGroupPanel = new EwtContainer();
        this.optionGroupPanel.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(5, 10, 5, 10), (String)this.addressOptionGroupString));
        this.optionGroupPanel.setLayout(new GridBagLayout());
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 17;
        this.optionGroupPanel.add((Component)this.optionBoxDefault, this.gbc);
        this.gbc.gridy = 1;
        this.gbc.insets.top = 5;
        this.optionGroupPanel.add((Component)this.optionBoxLB, this.gbc);
        this.gbc.gridy = 2;
        this.optionGroupPanel.add((Component)this.optionBoxNoFO, this.gbc);
        this.gbc.gridy = 3;
        this.optionGroupPanel.add((Component)this.optionBoxSR, this.gbc);
        this.gbc.gridy = 4;
        this.optionGroupPanel.add((Component)this.optionBoxNone, this.gbc);
        this.backCompatBox = new LWCheckbox(this.backCompatString);
        this.backCompatBox.setState(aList.isBackCompat());
        this.backCompatBox.addItemListener((ItemListener)this);
        this.okButton = new LWButton(this.okString);
        this.okButton.setLeftmost(true);
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener((ActionListener)this);
        this.cancelButton = new LWButton(this.cancelString);
        this.cancelButton.setRightmost(true);
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener((ActionListener)this);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.setRightmost(true);
        this.helpButton.setLeftmost(true);
        this.helpButton.setActionCommand("HELP");
        this.helpButton.addActionListener((ActionListener)this);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(5, 0, 5, 0);
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.buttonPanel.add((Component)this.helpButton, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets.right = 3;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 13;
        this.buttonPanel.add((Component)this.okButton, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets.right = 0;
        this.buttonPanel.add((Component)this.cancelButton, this.gbc);
        this.advancedPanel = new EwtContainer();
        this.advancedPanel.setLayout(new BorderLayout(5, 5));
        this.advancedPanel.add((Component)this.optionGroupPanel, "Center");
        this.advancedPanel.add((Component)this.backCompatBox, "South");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.addressPanel);
        this.parseAddressListOptions();
        this.setButtonState();
        this.updateBackCompatState();
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        int i = 0;
        while (i < this.tabPanel.getPageCount()) {
            NetClientAddressPage addrPage = (NetClientAddressPage)((Object)this.tabPanel.getPage(i).getContent());
            if (addrPage.getChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setChanged(boolean state) {
        int i = 0;
        while (i < this.tabPanel.getPageCount()) {
            NetClientAddressPage addrPage = (NetClientAddressPage)((Object)this.tabPanel.getPage(i).getContent());
            addrPage.setChanged(state);
            ++i;
        }
        this.changed = state;
    }

    public boolean isValidPage() {
        NetClientAddressPage addrPage = (NetClientAddressPage)((Object)this.tabPanel.getSelectedPage().getContent());
        return addrPage.checkFields();
    }

    public void saveAddressInfo() {
        if (!this.isValidPage()) {
            return;
        }
        this.aList.removeAllAddresses();
        this.aList.removeAllAttributes();
        int count = this.tabPanel.getPageCount();
        int i = 0;
        while (i < count) {
            NetClientAddressPage addrPage = (NetClientAddressPage)((Object)this.tabPanel.getPage(i).getContent());
            addrPage.saveAddressInfo(this.aList);
            ++i;
        }
        try {
            this.aList.setBackCompat(this.backCompatBox.getState());
            if (this.optionBoxDefault.getState()) {
                this.aList.setSOURCE_ROUTE("OFF");
                this.aList.setLOAD_BALANCE("OFF");
                this.aList.setFAILOVER("ON");
            } else if (this.optionBoxLB.getState()) {
                this.aList.setSOURCE_ROUTE("OFF");
                this.aList.setLOAD_BALANCE("ON");
                this.aList.setFAILOVER("ON");
            } else if (this.optionBoxNoFO.getState()) {
                this.aList.setSOURCE_ROUTE("OFF");
                this.aList.setLOAD_BALANCE("ON");
                this.aList.setFAILOVER("OFF");
            } else if (this.optionBoxSR.getState()) {
                this.aList.setSOURCE_ROUTE("ON");
                this.aList.setLOAD_BALANCE("OFF");
                this.aList.setFAILOVER("OFF");
            } else if (this.optionBoxNone.getState()) {
                this.aList.setSOURCE_ROUTE("OFF");
                this.aList.setFAILOVER("OFF");
                this.aList.setLOAD_BALANCE("OFF");
            }
        }
        catch (Exception e) {
            System.err.println("AddressListPanel.saveAddressInfo(): Exception while saving field data" + e);
        }
        this.changed = false;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.backCompatBox) {
            this.updateBackCompatState();
        }
        this.dialogChanged = true;
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        Component src = (Component)evt.getSource();
        src.setEnabled(false);
        if (cmd.equals("HELP")) {
            ((NetApplication)this.app).getHelpContext().showTopic("TOPICsnAdvancedAList");
        } else if (cmd.equals("ADVANCED")) {
            this.saveDialogSettings();
            this.displayAdvancedDialog();
        } else if (cmd.equals("CANCEL")) {
            this.advancedDialog.setVisible(false);
            this.revertDialogSettings();
        } else if (cmd.equals("OK")) {
            if (this.dialogChanged) {
                this.changed = true;
                this.dialogChanged = false;
            }
            this.advancedDialog.setVisible(false);
        } else if (cmd.equals("NEW")) {
            this.createNewAddressPage();
            this.changed = true;
        } else if (cmd.equals("DELETE")) {
            this.deleteCurrentAddressPage();
            this.changed = true;
        } else if (cmd.equals("PROMOTE")) {
            this.promoteCurrentAddressPage();
            this.changed = true;
        } else if (cmd.equals("DEMOTE")) {
            this.demoteCurrentAddressPage();
            this.changed = true;
        }
        this.setButtonState();
    }

    public void tabPanelSelectionChanged(TabPanelEvent e) {
        this.currPage = (NetClientAddressPage)((Object)e.getPage().getContent());
    }

    public void tabPanelSelectionChanging(TabPanelEvent e) {
        if (this.currPage != null && !this.currPage.checkFields()) {
            ((Cancelable)e).cancel();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        super.setEnabled(enabled);
        this.tabPanel.setEnabled(enabled);
        this.tabPanel.getSelectedPage().getContent().setEnabled(enabled);
        Component[] buttons = this.newDeletePanel.getComponents();
        int i = 0;
        while (i < buttons.length) {
            buttons[i].setEnabled(enabled);
            ++i;
        }
        if (enabled) {
            this.setButtonState();
            this.updateBackCompatState();
        }
    }

    private void createNewAddressPage() {
        NetClientAddressPage addrPage = (NetClientAddressPage)((Object)this.tabPanel.getSelectedPage().getContent());
        if (!addrPage.checkFields()) {
            return;
        }
        this.currPage = null;
        Integer addrNum = new Integer(this.addrCounter);
        String addrStr = addrNum.toString();
        this.newPage = new NetClientAddressPage(this.app);
        if (this.newPage.getProtocolChoice().equals(this.tcpString) || this.newPage.getProtocolChoice().equals(this.tcpsString)) {
            int i = 0;
            while (i < this.tabPanel.getPageCount()) {
                addrPage = (NetClientAddressPage)((Object)this.tabPanel.getPage(i).getContent());
                if (addrPage.getProtocolChoice().equals(this.tcpsString) || addrPage.getProtocolChoice().equals(this.tcpString)) {
                    this.newPage.setHost(addrPage.getHost());
                    break;
                }
                ++i;
            }
        }
        TabPanelPage tabPanelPage = this.tabPanel.addPage(String.valueOf(this.addressString) + addrStr, (Component)((Object)this.newPage));
        ++this.addrCounter;
        tabPanelPage.setSelected(true);
        this.setButtonState();
        this.changed = true;
    }

    private void deleteCurrentAddressPage() {
        this.currPage = null;
        this.changed = true;
        TabPanelPage tabPanelPage = this.tabPanel.getSelectedPage();
        this.tabPanel.removePage(tabPanelPage);
        tabPanelPage = this.tabPanel.getSelectedPage();
        int i = this.tabPanel.getIndexOf(tabPanelPage);
        while (i < this.tabPanel.getPageCount()) {
            Integer addrNum = new Integer(i + 1);
            this.tabPanel.getPage(i).setLabel(String.valueOf(this.addressString) + addrNum.toString());
            ++i;
        }
        --this.addrCounter;
        this.setButtonState();
        this.changed = true;
    }

    private void displayAdvancedDialog() {
        if (this.advancedDialog == null) {
            this.advancedDialog = new BufferedDialog((Frame)((BufferedFrame)this.app.getFrame()), this.advancedTitleString, true);
            this.advancedDialog.setLayout((LayoutManager)new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(10, 10, 5, 10);
            this.advancedDialog.add((Component)this.advancedPanel, gbc);
            gbc.gridy = 1;
            gbc.fill = 2;
            this.advancedDialog.add((Component)this.buttonPanel, gbc);
            this.advancedDialog.pack();
        }
        Rectangle appSize = this.app.getFrame().getBounds();
        Dimension dlgSize = this.advancedDialog.getSize();
        this.advancedDialog.setLocation(appSize.x + (appSize.width - dlgSize.width) / 2, appSize.y + (appSize.height - dlgSize.height) / 2);
        this.advancedDialog.setVisible(true);
        String os = System.getProperty("os.name");
        if (os.equals("Windows NT") || os.equals("Windows 95") || os.equals("Windows 98")) {
            this.app.getFrame().toFront();
        }
        this.advancedDialog.dispose();
    }

    private void saveDialogSettings() {
        if (this.cbg != null) {
            this.currentCheckbox = this.cbg.getSelectedCheckbox();
        }
        if (this.backCompatBox != null) {
            this.currentBCState = this.backCompatBox.getState();
        }
    }

    private void revertDialogSettings() {
        if (this.currentCheckbox != null) {
            this.cbg.setSelectedCheckbox(this.currentCheckbox);
            this.backCompatBox.setState(this.currentBCState);
            this.updateBackCompatState();
        }
    }

    private void promoteCurrentAddressPage() {
        this.changed = true;
        TabPanelPage curr = this.tabPanel.getSelectedPage();
        if (curr == null) {
            return;
        }
        int index = this.tabPanel.getIndexOf(curr);
        if (index == 0) {
            return;
        }
        if (!this.currPage.checkFields()) {
            return;
        }
        TabPanelPage prevPage = this.tabPanel.getPage(index - 1);
        if (prevPage == null) {
            return;
        }
        this.tabPanel.removePage(curr);
        this.tabPanel.addPage(curr, prevPage);
        curr.setSelected(true);
    }

    private void demoteCurrentAddressPage() {
        this.changed = true;
        TabPanelPage curr = this.tabPanel.getSelectedPage();
        if (curr == null) {
            return;
        }
        int index = this.tabPanel.getIndexOf(curr);
        if (index >= this.tabPanel.getPageCount() - 1) {
            return;
        }
        if (!this.currPage.checkFields()) {
            return;
        }
        this.tabPanel.removePage(curr);
        try {
            try {
                TabPanelPage next2Page = this.tabPanel.getPage(index + 1);
                if (next2Page == null) {
                    throw new IllegalArgumentException();
                }
                this.tabPanel.addPage(curr, next2Page);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.tabPanel.addPage(curr);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            curr.setSelected(true);
            throw throwable;
        }
        curr.setSelected(true);
    }

    private void setButtonState() {
        boolean oneAddr = this.tabPanel.getPageCount() <= 1;
        this.deleteButton.setEnabled(!oneAddr);
        this.promoteButton.setEnabled(!oneAddr);
        this.demoteButton.setEnabled(!oneAddr);
        this.optionsButton.setEnabled(!oneAddr);
        this.newButton.setEnabled(true);
        this.okButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.helpButton.setEnabled(true);
    }

    private void updateBackCompatState() {
        boolean state = this.backCompatBox.getState();
        if (state && (this.optionBoxLB.getState() || this.optionBoxNoFO.getState() || this.optionBoxNone.getState())) {
            this.optionBoxLB.setState(false);
            this.optionBoxNoFO.setState(false);
            this.optionBoxNone.setState(false);
            this.optionBoxDefault.setState(true);
        }
        this.optionBoxLB.setEnabled(!state);
        this.optionBoxNoFO.setEnabled(!state);
        this.optionBoxNone.setEnabled(!state);
    }

    private boolean isAttribEnabled(String val) {
        if (val == null) {
            return false;
        }
        return (val = val.toUpperCase()).equals("ON") || val.equals("YES") || val.equals("TRUE") || val.equals("OK") || val.equals("USE");
    }

    private boolean isAttribDisabled(String val) {
        if (val == null) {
            return false;
        }
        return (val = val.toUpperCase()).equals("OFF") || val.equals("NO") || val.equals("FALSE");
    }

    private void parseAddressListOptions() {
        if (this.isAttribEnabled(this.aList.getSOURCE_ROUTE())) {
            this.optionBoxSR.setState(true);
        } else if (this.isAttribDisabled(this.aList.getFAILOVER())) {
            if (this.isAttribDisabled(this.aList.getLOAD_BALANCE())) {
                this.optionBoxNone.setState(true);
            } else {
                this.optionBoxNoFO.setState(true);
            }
        } else if (this.isAttribDisabled(this.aList.getLOAD_BALANCE())) {
            this.optionBoxDefault.setState(true);
        } else {
            this.optionBoxLB.setState(true);
        }
    }
}

