/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import oracle.ewt.EwtContainer;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.addrbook.ConnectData;
import oracle.net.asst.addrbook.Description;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class AdvancedDialog
extends BufferedDialog
implements ActionListener,
KeyListener,
FocusListener,
ItemListener {
    private static final String DEFAULT_SDU = "2048";
    private static final int HEIGHT = 300;
    private static final int WIDTH = 400;
    private LWLabel tosLabel;
    private LWLabel inLabel;
    private LWLabel hnLabel;
    private LWLabel ohLabel;
    private LWLabel rdbLabel;
    private LWLabel sduLabel;
    private LWLabel gdbLabel;
    private String tosString;
    private String inString;
    private String hnString;
    private String ohString;
    private String rdbString;
    private String gdbString;
    private String sduString;
    private LWTextField tosField;
    private LWTextField inField;
    private LWTextField hnField;
    private LWTextField ohField;
    private LWTextField rdbField;
    private LWTextField gdbField;
    private LWTextField sduField;
    private LWCheckbox srvrBox;
    private LWCheckbox hsBox;
    private String srvrString;
    private String hsString;
    private LWButton okButton;
    private LWButton cancelButton;
    private LWButton helpButton;
    private String okString;
    private String cancelString;
    private String helpString;
    private String titleString;
    private String sduDefaultString;
    private String serviceGroupString;
    private String rdbGroupString;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private GroupBoxContainer servicePanelGroup;
    private GroupBoxContainer rdbPanelGroup;
    private EwtContainer mainPanel;
    private EwtContainer servicePanel;
    private EwtContainer rdbPanel;
    private EwtContainer buttonPanel;
    private boolean changed;
    private boolean response;
    private boolean backCompat;
    private NetStrings netStrings;
    private String helpTopicString;
    private BufferedFrame myOwner;
    private WebApplication app;
    private Description description;
    private ConnectData connectData;
    private String tmptos;
    private String tmpoh;
    private String tmpin;
    private String tmphn;
    private String tmprdb;
    private String tmpgdb;
    private String tmpsdu;
    private boolean tmphs;
    private boolean tmpsrvr;

    public AdvancedDialog(WebApplication app, BufferedFrame frame, ConnectData cd, Description desc) {
        super((Frame)frame, true);
        this.app = app;
        this.myOwner = (BufferedFrame)app.getFrame();
        this.connectData = cd;
        this.description = desc;
        this.netStrings = new NetStrings();
        this.cancelString = this.netStrings.getString("SNCCancel");
        this.helpString = this.netStrings.getString("SNCHelp");
        this.okString = this.netStrings.getString("SNCOK");
        this.sduString = this.netStrings.getString("SNCSDU");
        this.srvrString = this.netStrings.getString("SNCDedicatedServer");
        this.titleString = this.netStrings.getString("SNCAdvancedOptions");
        this.serviceGroupString = this.netStrings.getString("SNCAdvancedServiceGroup");
        this.rdbGroupString = this.netStrings.getString("SNCRDBGroup");
        this.hnString = this.netStrings.getString("SNCHandlerName");
        this.hsString = this.netStrings.getString("SNCHService");
        this.inString = this.netStrings.getString("SNCInstanceName");
        this.ohString = this.netStrings.getString("SNCOracleHome");
        this.gdbString = this.netStrings.getString("SNCGDB");
        this.rdbString = this.netStrings.getString("SNCRdbDatabase");
        this.tosString = this.netStrings.getString("SNCTypeOfService");
        this.helpTopicString = "TOPICsnAdvanced";
        Object[] msgParams = new Object[]{DEFAULT_SDU};
        this.sduDefaultString = MessageFormat.format(this.netStrings.getString("SNCSDUDefault"), msgParams);
        this.okButton = new LWButton(this.okString);
        this.okButton.setLeftmost(true);
        this.okButton.addActionListener((ActionListener)this);
        this.cancelButton = new LWButton(this.cancelString);
        this.cancelButton.setRightmost(true);
        this.cancelButton.addActionListener((ActionListener)this);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.setLeftmost(true);
        this.helpButton.setRightmost(true);
        this.helpButton.addActionListener((ActionListener)this);
        this.tosLabel = new LWLabel(this.tosString, 1);
        this.inLabel = new LWLabel(this.inString, 1);
        this.hnLabel = new LWLabel(this.hnString, 1);
        this.ohLabel = new LWLabel(this.ohString, 1);
        this.gdbLabel = new LWLabel(this.gdbString, 1);
        this.rdbLabel = new LWLabel(this.rdbString, 1);
        this.sduLabel = new LWLabel(this.sduString, 1);
        this.tosField = new LWTextField(15);
        this.inField = new LWTextField(15);
        this.hnField = new LWTextField(15);
        this.ohField = new LWTextField(15);
        this.rdbField = new LWTextField(15);
        this.gdbField = new LWTextField(15);
        this.sduField = new LWTextField(15);
        this.tosField.addFocusListener(this);
        this.inField.addFocusListener(this);
        this.hnField.addFocusListener(this);
        this.ohField.addFocusListener(this);
        this.rdbField.addFocusListener(this);
        this.gdbField.addFocusListener(this);
        this.sduField.addFocusListener(this);
        this.tosField.addKeyListener(this);
        this.inField.addKeyListener(this);
        this.hnField.addKeyListener(this);
        this.ohField.addKeyListener(this);
        this.gdbField.addKeyListener(this);
        this.rdbField.addKeyListener(this);
        this.sduField.addKeyListener(this);
        this.srvrBox = new LWCheckbox(this.srvrString);
        this.hsBox = new LWCheckbox(this.hsString);
        this.srvrBox.addItemListener((ItemListener)this);
        this.hsBox.addItemListener((ItemListener)this);
        this.initDataValues();
        this.saveTempValues();
        ((Dialog)((Object)this)).setTitle(this.titleString);
        ((Component)((Object)this)).setSize(400, 300);
        this.layoutPanels();
        this.updateBackCompatState();
        this.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.mainPanel, "Center");
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).setResizable(false);
    }

    private void layoutPanels() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.servicePanel = new EwtContainer();
        this.servicePanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.servicePanel.setLayout(this.gbl);
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(3, 5, 3, 5);
        this.servicePanel.add((Component)this.inLabel, this.gbc);
        this.gbc.gridy = 1;
        this.servicePanel.add((Component)this.hnLabel, this.gbc);
        this.gbc.gridy = 2;
        this.servicePanel.add((Component)this.ohLabel, this.gbc);
        this.gbc.gridy = 4;
        this.servicePanel.add((Component)this.sduLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.weightx = 2.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(3, 0, 3, 5);
        this.servicePanel.add((Component)this.inField, this.gbc);
        this.gbc.gridy = 1;
        this.servicePanel.add((Component)this.hnField, this.gbc);
        this.gbc.gridy = 2;
        this.servicePanel.add((Component)this.ohField, this.gbc);
        this.gbc.gridy = 4;
        this.servicePanel.add((Component)this.sduField, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 2.0;
        this.gbc.insets = new Insets(5, 5, 3, 5);
        this.servicePanel.add((Component)this.srvrBox, this.gbc);
        this.gbc.gridy = 6;
        this.gbc.insets = new Insets(3, 5, 3, 5);
        this.servicePanel.add((Component)this.hsBox, this.gbc);
        this.rdbPanel = new EwtContainer();
        this.rdbPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.rdbPanel.setLayout(this.gbl);
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(3, 5, 3, 5);
        this.rdbPanel.add((Component)this.rdbLabel, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.tosLabel, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.gdbLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.gridy = 0;
        this.gbc.weightx = 2.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(3, 0, 3, 5);
        this.rdbPanel.add((Component)this.rdbField, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.tosField, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.gdbField, this.gbc);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints bpgbc = new GridBagConstraints();
        bpgbc.gridy = 0;
        bpgbc.gridx = 0;
        bpgbc.gridheight = 1;
        bpgbc.gridwidth = 1;
        bpgbc.weightx = 1.0;
        bpgbc.weighty = 0.0;
        bpgbc.insets = new Insets(5, 0, 5, 0);
        bpgbc.fill = 0;
        bpgbc.anchor = 17;
        this.buttonPanel.add((Component)this.helpButton, bpgbc);
        ++bpgbc.gridx;
        bpgbc.insets.right = 3;
        bpgbc.weightx = 0.0;
        bpgbc.anchor = 13;
        this.buttonPanel.add((Component)this.okButton, bpgbc);
        ++bpgbc.gridx;
        bpgbc.insets.right = 0;
        this.buttonPanel.add((Component)this.cancelButton, bpgbc);
        this.mainPanel = new EwtContainer();
        this.mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.mainPanel.setLayout(this.gbl);
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.gridx = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.servicePanelGroup = new GroupBoxContainer((Component)new LWLabel(this.serviceGroupString), (Component)this.servicePanel);
        this.mainPanel.add((Component)this.servicePanelGroup, this.gbc);
        this.gbc.gridy = 1;
        this.gbc.insets.top = 10;
        this.rdbPanelGroup = new GroupBoxContainer((Component)new LWLabel(this.rdbGroupString), (Component)this.rdbPanel);
        this.mainPanel.add((Component)this.rdbPanelGroup, this.gbc);
        this.gbc.gridy = 2;
        this.gbc.insets.top = 10;
        this.mainPanel.add((Component)this.buttonPanel, this.gbc);
    }

    public boolean areFieldsValid() {
        NetValidate val = new NetValidate(this.myOwner);
        if (!this.sduField.getText().equals("") && !val.validateNumber(this.sduField, 1, Short.MAX_VALUE)) {
            val.showDialog("Session Data Unit", 1, Short.MAX_VALUE);
            this.sduField.requestFocus();
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean state) {
        this.changed = state;
    }

    public boolean getResponse() {
        return this.response;
    }

    public void saveAddressInfo(Description desc, ConnectData cd) {
        if (this.isChanged() && this.areFieldsValid()) {
            try {
                boolean val;
                String value = null;
                value = this.inField.getText();
                if (value != null) {
                    cd.setINSTANCE_NAME(value);
                }
                if ((value = this.hnField.getText()) != null) {
                    cd.setHANDLER_NAME(value);
                }
                if ((value = this.ohField.getText()) != null) {
                    cd.setORACLE_HOME(value);
                }
                if ((value = this.sduField.getText()) != null) {
                    cd.setSDU(value);
                }
                if ((value = this.rdbField.getText()) != null) {
                    cd.setRDB_DATABASE(value);
                }
                if ((value = this.gdbField.getText()) != null) {
                    cd.setGLOBAL_NAME(value);
                }
                if ((value = this.tosField.getText()) != null) {
                    desc.setTYPE_OF_SERVICE(value);
                }
                if (val = this.hsBox.getState()) {
                    desc.setHService("OK");
                } else {
                    desc.setHService("");
                }
                val = this.srvrBox.getState();
                if (val) {
                    cd.setSRVR("DEDICATED");
                } else {
                    cd.setSRVR("");
                }
            }
            catch (Exception e) {
                System.err.println("AdvancedDialog.saveAddressInfo(): AttributeException during save." + e);
            }
            this.saveTempValues();
            this.changed = false;
        }
    }

    public void setBackCompat(boolean bc) {
        this.backCompat = bc;
    }

    public void setVisible(boolean state) {
        this.updateBackCompatState();
        super.setVisible(state);
    }

    public void itemStateChanged(ItemEvent e) {
        this.changed = true;
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(this.okString)) {
            if (this.areFieldsValid()) {
                this.response = true;
                this.setVisible(false);
                this.saveTempValues();
            }
        } else if (cmd.equals(this.helpString)) {
            NetUtils.getHelpContext().show(this.helpTopicString);
        } else {
            this.response = false;
            this.setVisible(false);
            this.restoreTempValues();
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        this.changed = true;
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        LWTextField f = (LWTextField)cmp;
        String s = f.getText();
        if (ch == '\b') {
            return;
        }
        if (cmp == this.sduField && !Character.isDigit(ch)) {
            evt.setKeyChar('\u0000');
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    private void initDataValues() {
        this.tosField.setText(this.description.getTYPE_OF_SERVICE());
        this.ohField.setText(this.connectData.getORACLE_HOME());
        this.inField.setText(this.connectData.getINSTANCE_NAME());
        this.hnField.setText(this.connectData.getHANDLER_NAME());
        this.rdbField.setText(this.connectData.getRDB_DATABASE());
        this.gdbField.setText(this.connectData.getGLOBAL_NAME());
        this.sduField.setText(this.connectData.getSDU());
        this.hsBox.setState(this.isAttribEnabled(this.connectData.getSRVR()));
        this.srvrBox.setState(this.isAttribEnabled(this.description.getHService()));
    }

    private void updateBackCompatState() {
        this.inLabel.setEnabled(!this.backCompat);
        this.inField.setEnabled(!this.backCompat);
        this.hnLabel.setEnabled(!this.backCompat);
        this.hnField.setEnabled(!this.backCompat);
    }

    private boolean isAttribEnabled(String val) {
        if (val == null) {
            return false;
        }
        return (val = val.toUpperCase()).equals("ON") || val.equals("YES") || val.equals("TRUE") || val.equals("OK") || val.equals("USE") || val.equals("DEDICATED");
    }

    private void restoreTempValues() {
        this.tosField.setText(this.tmptos);
        this.ohField.setText(this.tmpoh);
        this.inField.setText(this.tmpin);
        this.hnField.setText(this.tmphn);
        this.rdbField.setText(this.tmprdb);
        this.gdbField.setText(this.tmpgdb);
        this.sduField.setText(this.tmpsdu);
        this.hsBox.setState(this.tmphs);
        this.srvrBox.setState(this.tmpsrvr);
    }

    private void saveTempValues() {
        this.tmptos = this.tosField.getText();
        this.tmpoh = this.ohField.getText();
        this.tmpin = this.inField.getText();
        this.tmphn = this.hnField.getText();
        this.tmprdb = this.rdbField.getText();
        this.tmpgdb = this.gdbField.getText();
        this.tmpsdu = this.sduField.getText();
        this.tmphs = this.hsBox.getState();
        this.tmpsrvr = this.srvrBox.getState();
    }
}

