/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.addrbook.ConnectData;
import oracle.net.asst.addrbook.Description;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NullFieldDialog;
import oracle.net.asst.servicename.AdvancedDialog;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class DBPanel
extends EwtContainer
implements ActionListener,
ItemListener,
KeyListener,
FocusListener {
    private NetStrings netStrings;
    private LWButton advButton;
    private String advancedString;
    private LWCheckbox backCompatBox;
    private String backCompatString;
    private LWLabel sidLabel;
    private LWTextField sidField;
    private LWLabel svcNameLabel;
    private LWTextField svcNameField;
    private String sidString;
    private String sidInitialString;
    private String svcNameString;
    private boolean changed = false;
    private Description description;
    private ConnectData connectData;
    private GridBagConstraints gbc = new GridBagConstraints();
    private AdvancedDialog advancedDialog;
    private final WebApplication app;

    public DBPanel(Description desc, WebApplication wa) {
        this.app = wa;
        this.description = desc;
        this.connectData = this.description.getConnectData();
        this.netStrings = new NetStrings();
        this.advancedString = this.netStrings.getString("SNCAdvanced");
        this.sidString = this.netStrings.getString("SNCSID");
        this.sidInitialString = this.netStrings.getString("SNCSIDField");
        this.svcNameString = this.netStrings.getString("SNCServiceName");
        this.backCompatString = this.netStrings.getString("SNCBackCompatServer");
        this.svcNameLabel = new LWLabel(this.svcNameString, 1);
        this.svcNameField = new LWTextField(20);
        this.svcNameField.setText(this.connectData.getSERVICE_NAME());
        this.svcNameField.addFocusListener(this);
        this.svcNameField.addKeyListener(this);
        this.sidLabel = new LWLabel(this.sidString, 1);
        this.sidField = new LWTextField(20);
        this.sidField.setText(this.connectData.getSID());
        this.sidField.addFocusListener(this);
        this.sidField.addKeyListener(this);
        this.backCompatBox = new LWCheckbox(this.backCompatString);
        this.backCompatBox.setState(this.connectData.isBackCompat());
        this.backCompatBox.addItemListener((ItemListener)this);
        this.advButton = new LWButton(this.advancedString);
        this.advButton.setLeftmost(true);
        this.advButton.setRightmost(true);
        this.advButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(3, 0, 3, 5);
        ((Container)((Object)this)).add((Component)this.svcNameLabel, this.gbc);
        this.gbc.gridy = 1;
        ((Container)((Object)this)).add((Component)this.sidLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.5;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        ((Container)((Object)this)).add((Component)this.svcNameField, this.gbc);
        this.gbc.gridy = 1;
        ((Container)((Object)this)).add((Component)this.sidField, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 2;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(0, 15, 0, 0);
        ((Container)((Object)this)).add((Component)this.advButton, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 3;
        this.gbc.anchor = 16;
        this.gbc.insets = new Insets(7, 0, 0, 0);
        ((Container)((Object)this)).add((Component)this.backCompatBox, this.gbc);
        this.updateBackCompatState();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] kids = ((Container)((Object)this)).getComponents();
        int i = 0;
        while (i < kids.length) {
            kids[i].setEnabled(enabled);
            ++i;
        }
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        if (this.advancedDialog != null) {
            return this.advancedDialog.isChanged();
        }
        return false;
    }

    public void setChanged(boolean state) {
        this.changed = state;
        if (this.advancedDialog != null) {
            this.advancedDialog.setChanged(state);
        }
    }

    public boolean isValidPage() {
        if (this.backCompatBox.getState()) {
            if (this.sidField.getText().equals("")) {
                this.showNullDialog(this.sidString);
                this.sidField.requestFocus();
                return false;
            }
        } else if (this.svcNameField.getText().equals("")) {
            this.showNullDialog(this.svcNameString);
            this.svcNameField.requestFocus();
            return false;
        }
        return true;
    }

    public void saveAddressInfo() {
        if (!this.isValidPage()) {
            return;
        }
        if (this.changed) {
            String value = null;
            boolean state = this.backCompatBox.getState();
            this.connectData.setBackCompat(state);
            try {
                if (state) {
                    value = this.sidField.getText();
                    if (value != null) {
                        this.connectData.setSID(value);
                    }
                } else {
                    value = this.svcNameField.getText();
                    if (value != null) {
                        this.connectData.setSERVICE_NAME(value);
                    }
                }
                this.changed = false;
            }
            catch (Exception e) {
                System.err.println("DBPanel.saveAddressInfo(): exception during save." + e);
            }
        }
        if (this.advancedDialog != null && this.advancedDialog.isChanged()) {
            this.advancedDialog.saveAddressInfo(this.description, this.connectData);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this.showAdvancedDialog();
    }

    public void itemStateChanged(ItemEvent e) {
        this.changed = true;
        if (this.advancedDialog != null) {
            this.advancedDialog.setBackCompat(this.backCompatBox.getState());
        }
        this.updateBackCompatState();
    }

    public void focusGained(FocusEvent e) {
        Component f = e.getComponent();
        if (f.equals(this.sidField)) {
            this.app.showStatus(this.netStrings.getString("SNCSIDHelp"));
            return;
        }
        if (f.equals(this.svcNameField)) {
            this.app.showStatus(this.netStrings.getString("SNCServiceNameHelp"));
            return;
        }
    }

    public void focusLost(FocusEvent e) {
        this.app.showStatus("");
    }

    public void keyPressed(KeyEvent evt) {
        this.changed = true;
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component comp = evt.getComponent();
        if (comp instanceof LWTextField) {
            LWTextField f = (LWTextField)comp;
            String s = f.getText();
            char ch = evt.getKeyChar();
            if (ch == '\b') {
                return;
            }
            if (comp == this.sidField) {
                if (s.length() < 8 && Character.isLetterOrDigit(ch)) {
                    return;
                }
                evt.setKeyChar('\u0000');
            } else if (comp == this.svcNameField) {
                if (s.length() < 137 && (Character.isLetterOrDigit(ch) || ch == '.' || ch == '-')) {
                    return;
                }
                evt.setKeyChar('\u0000');
            }
        }
    }

    private void updateBackCompatState() {
        boolean state = this.backCompatBox.getState();
        this.sidField.setEnabled(state);
        this.sidLabel.setEnabled(state);
        this.svcNameField.setEnabled(!state);
        this.svcNameLabel.setEnabled(!state);
    }

    private void showAdvancedDialog() {
        if (this.advancedDialog == null) {
            this.advancedDialog = new AdvancedDialog(this.app, (BufferedFrame)this.app.getFrame(), this.connectData, this.description);
        }
        Rectangle appSize = this.app.getFrame().getBounds();
        Dimension dlgSize = ((Component)((Object)this.advancedDialog)).getSize();
        ((Component)((Object)this.advancedDialog)).setLocation(appSize.x + appSize.width / 2 - dlgSize.width / 2, appSize.y + appSize.height / 2 - dlgSize.height / 2);
        ((Dialog)((Object)this.advancedDialog)).setModal(true);
        this.advancedDialog.setBackCompat(this.backCompatBox.getState());
        this.advancedDialog.setVisible(true);
        this.app.getFrame().toFront();
        this.changed = this.advancedDialog.getResponse();
    }

    private void showNullDialog(String field) {
        BufferedFrame fr = (BufferedFrame)this.app.getFrame();
        NullFieldDialog nullDialog = new NullFieldDialog(fr, field);
        Rectangle appSize = this.app.getFrame().getBounds();
        Dimension dlgSize = ((Component)((Object)nullDialog)).getSize();
        ((Component)((Object)nullDialog)).setLocation(appSize.x + appSize.width / 2 - dlgSize.width / 2, appSize.y + appSize.height / 2 - dlgSize.height / 2);
        ((Dialog)((Object)nullDialog)).setModal(true);
        ((Dialog)((Object)nullDialog)).show();
    }
}

