/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.AddressList;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NullFieldDialog;
import oracle.net.asst.container.RangeErrorDialog;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetClientAddressPage
extends EwtContainer
implements ItemListener,
KeyListener,
FocusListener {
    String protocolString;
    String tcpString;
    String tcpsString;
    String spxString;
    String nmpString;
    String ipcString;
    String beqString;
    String hostString;
    String portString;
    String serviceString;
    String machineString;
    String pipeString;
    String keyString;
    String hostfieldString;
    String portfieldString;
    String servicefieldString;
    String machinefieldString;
    String pipefieldString;
    String keyfieldString;
    String currentChoice;
    boolean addrChanged = false;
    LWLabel protocolLabel;
    LWChoice protocolChoice;
    LWLabel hostLabel;
    LWLabel hostLabelTCPS;
    LWTextField hostField;
    LWTextField hostFieldTCPS;
    LWLabel blankLabel;
    LWLabel blankLabel1;
    LWLabel portLabel;
    LWLabel portLabelTCPS;
    LWTextField portField;
    LWTextField portFieldTCPS;
    LWLabel blankLabel2;
    LWLabel serviceLabel;
    LWTextField serviceField;
    LWLabel machineLabel;
    LWTextField machineField;
    LWLabel pipeLabel;
    LWTextField pipeField;
    LWLabel blankLabel4;
    LWLabel keyLabel;
    LWTextField keyField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    GroupBoxBorder tsGroup;
    NetStrings netStrings = new NetStrings();
    WebApplication app;
    private boolean enabled = true;

    public NetClientAddressPage(WebApplication w) {
        this.protocolString = this.netStrings.getString("SNCProtocol");
        this.tcpString = this.netStrings.getString("SNCTCP");
        this.tcpsString = this.netStrings.getString("SNCTCPS");
        this.spxString = this.netStrings.getString("SNCSPX");
        this.nmpString = this.netStrings.getString("SNCNMP");
        this.ipcString = this.netStrings.getString("SNCIPC");
        this.beqString = new String("BEQ");
        this.hostString = this.netStrings.getString("SNCHost");
        this.portString = this.netStrings.getString("SNCPort");
        this.serviceString = this.netStrings.getString("SNCService");
        this.machineString = this.netStrings.getString("SNCMachine");
        this.pipeString = this.netStrings.getString("SNCPipe");
        this.keyString = this.netStrings.getString("SNCKey");
        this.hostfieldString = this.netStrings.getString("SNCHostField");
        this.portfieldString = this.netStrings.getString("SNCPortField");
        this.servicefieldString = this.netStrings.getString("SNCServiceField");
        this.machinefieldString = this.netStrings.getString("SNCMachineField");
        this.pipefieldString = this.netStrings.getString("SNCPipeField");
        this.keyfieldString = this.netStrings.getString("SNCKeyField");
        this.currentChoice = this.tcpString;
        this.app = w;
        this.onCreatePage();
        this.initializePage();
    }

    protected void onCreatePage() {
        MarginBorder tenPixelMargin = new MarginBorder(10, 10, 10, 10);
        this.setBorder((Border)tenPixelMargin);
        ((Container)((Object)this)).setLayout(this.gbl);
        this.protocolLabel = new LWLabel(this.protocolString, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.protocolLabel, this.gbl, this.gbc, 0, 0, 1, 1);
        this.protocolChoice = new LWChoice();
        this.protocolChoice.addItemListener((ItemListener)this);
        this.gbc.anchor = 18;
        this.gbc.fill = 0;
        this.gbc.ipadx = 25;
        this.gbc.weighty = 0.0;
        this.add((Component)this.protocolChoice, this.gbl, this.gbc, 1, 0, 1, 1);
        this.gbc.ipadx = 0;
        this.hostLabel = new LWLabel(this.hostString, 1);
        this.hostField = new LWTextField(15);
        this.hostField.addKeyListener(this);
        this.hostField.addFocusListener(this);
        this.blankLabel1 = new LWLabel("", 1);
        this.portLabel = new LWLabel(this.portString, 1);
        this.portField = new LWTextField(15);
        this.portField.addKeyListener(this);
        this.portField.addFocusListener(this);
        this.blankLabel2 = new LWLabel("", 1);
        this.addTCPLayout();
        this.hostLabelTCPS = new LWLabel(this.hostString, 1);
        this.hostFieldTCPS = new LWTextField(15);
        this.hostFieldTCPS.addKeyListener(this);
        this.hostFieldTCPS.addFocusListener(this);
        this.portLabelTCPS = new LWLabel(this.portString, 1);
        this.portFieldTCPS = new LWTextField(15);
        this.portFieldTCPS.addKeyListener(this);
        this.portFieldTCPS.addFocusListener(this);
        this.serviceLabel = new LWLabel(this.serviceString, 1);
        this.serviceField = new LWTextField(15);
        this.serviceField.addKeyListener(this);
        this.serviceField.addFocusListener(this);
        this.machineLabel = new LWLabel(this.machineString, 1);
        this.machineField = new LWTextField(15);
        this.machineField.addKeyListener(this);
        this.machineField.addFocusListener(this);
        this.pipeLabel = new LWLabel(this.pipeString, 1);
        this.pipeField = new LWTextField(15);
        this.pipeField.addKeyListener(this);
        this.pipeField.addFocusListener(this);
        this.keyLabel = new LWLabel(this.keyString, 1);
        this.keyField = new LWTextField(15);
        this.keyField.addKeyListener(this);
        this.keyField.addFocusListener(this);
    }

    protected void initializePage() {
        try {
            NetProperties property = new NetProperties();
            String supportTCP = property.getProperty("TCP");
            String supportTCPS = property.getProperty("TCPS");
            String supportSPX = property.getProperty("SPX");
            String supportNMP = property.getProperty("NMP");
            String supportIPC = property.getProperty("IPC");
            String supportBEQ = property.getProperty("BEQ");
            if (supportTCP != null && supportTCP.toUpperCase().equals("YES")) {
                this.protocolChoice.addItem(this.tcpString);
            }
            if (supportTCPS != null && supportTCPS.toUpperCase().equals("YES")) {
                this.protocolChoice.addItem(this.tcpsString);
            }
            if (supportSPX != null && supportSPX.toUpperCase().equals("YES")) {
                this.protocolChoice.addItem(this.spxString);
            }
            if (supportNMP != null && supportNMP.toUpperCase().equals("YES")) {
                this.protocolChoice.addItem(this.nmpString);
            }
            if (supportIPC != null && supportIPC.toUpperCase().equals("YES")) {
                this.protocolChoice.addItem(this.ipcString);
            }
            if (supportBEQ != null && supportBEQ.toUpperCase().equals("YES")) {
                this.protocolChoice.addItem(this.beqString);
            }
            this.protocolChoice.select(0);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void setAddressInfo(Address addr) {
        String protocol = addr._getParameter("PROTOCOL");
        if (protocol.equalsIgnoreCase("TCP")) {
            this.setProtocolChoice(this.tcpString);
            if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                this.removeBEQLayout();
                this.addTCPLayout();
            }
            this.currentChoice = this.tcpString;
            this.setHost(addr._getParameter("HOST"));
            this.setPort(addr._getParameter("PORT"));
        } else if (protocol.equalsIgnoreCase("TCPS")) {
            this.setProtocolChoice(this.tcpsString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                this.removeBEQLayout();
                this.addTCPSLayout();
            }
            this.currentChoice = this.tcpsString;
            this.setTCPSHost(addr._getParameter("HOST"));
            this.setTCPSPort(addr._getParameter("PORT"));
        } else if (protocol.equalsIgnoreCase("NMP")) {
            this.setProtocolChoice(this.nmpString);
            if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                this.removeBEQLayout();
                this.addNMPLayout();
            }
            this.currentChoice = this.nmpString;
            this.setMachine(addr._getParameter("Server"));
            this.setPipe(addr._getParameter("Pipe"));
        } else if (protocol.equalsIgnoreCase("SPX")) {
            this.setProtocolChoice(this.spxString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                this.removeBEQLayout();
                this.addSPXLayout();
            }
            this.setService(addr._getParameter("Service"));
            this.currentChoice = this.spxString;
        } else if (protocol.equalsIgnoreCase("IPC")) {
            this.setProtocolChoice(this.ipcString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                this.removeBEQLayout();
                this.addIPCLayout();
            }
            this.setKey(addr._getParameter("Key"));
            this.currentChoice = this.ipcString;
        } else if (protocol.equalsIgnoreCase("BEQ")) {
            this.setProtocolChoice(this.beqString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addBEQLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addBEQLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addBEQLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addBEQLayout();
            }
            this.currentChoice = this.beqString;
        }
    }

    public void keyPressed(KeyEvent evt) {
        this.addrChanged = true;
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        this.addrChanged = true;
        char ch = evt.getKeyChar();
        LWTextField f = (LWTextField)cmp;
        String s = f.getText();
        if (cmp.equals(this.portField) || cmp.equals(this.portFieldTCPS)) {
            if (ch == '\b') {
                return;
            }
            if (s.length() < 5 && Character.isDigit(ch)) {
                return;
            }
            evt.setKeyChar('\u0000');
        }
        if (cmp.equals(this.hostField) || cmp.equals(this.hostFieldTCPS) || cmp.equals(this.serviceField) || cmp.equals(this.machineField) || cmp.equals(this.pipeField) || cmp.equals(this.keyField)) {
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                return;
            }
            if (cmp.equals(this.hostField) && ch == '.') {
                return;
            }
            if (ch == '\b') {
                return;
            }
            evt.setKeyChar('\u0000');
        }
    }

    public void focusGained(FocusEvent e) {
        Component f = e.getComponent();
        if (f.equals(this.hostFieldTCPS) || f.equals(this.hostField)) {
            this.app.showStatus(this.netStrings.getString("SNCHostHelp"));
            return;
        }
        if (f.equals(this.portFieldTCPS) || f.equals(this.portField)) {
            this.app.showStatus(this.netStrings.getString("SNCPortHelp"));
            return;
        }
        if (f.equals(this.serviceField)) {
            this.app.showStatus(this.netStrings.getString("SNCServiceHelp"));
            return;
        }
        if (f.equals(this.machineField)) {
            this.app.showStatus(this.netStrings.getString("SNCMachineHelp"));
            return;
        }
        if (f.equals(this.pipeField)) {
            this.app.showStatus(this.netStrings.getString("SNCPipeHelp"));
            return;
        }
    }

    public void focusLost(FocusEvent e) {
        this.app.showStatus("");
    }

    public void itemStateChanged(ItemEvent e) {
        this.addrChanged = true;
        String arg = e.getItem().toString();
        if (arg.equals(this.tcpString)) {
            if (this.currentChoice.equals(this.tcpString)) {
                return;
            }
            if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                this.removeBEQLayout();
            }
            this.addTCPLayout();
            this.currentChoice = this.tcpString;
        } else if (arg.equals(this.tcpsString)) {
            if (this.currentChoice.equals(this.tcpsString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                this.removeBEQLayout();
            }
            this.addTCPSLayout();
            this.currentChoice = this.tcpsString;
        } else if (arg.equals(this.spxString)) {
            if (this.currentChoice.equals(this.spxString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                this.removeBEQLayout();
            }
            this.addSPXLayout();
            this.currentChoice = this.spxString;
        } else if (arg.equals(this.nmpString)) {
            if (this.currentChoice.equals(this.nmpString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                this.removeBEQLayout();
            }
            this.addNMPLayout();
            this.currentChoice = this.nmpString;
        } else if (arg.equals(this.ipcString)) {
            if (this.currentChoice.equals(this.ipcString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else {
                this.removeBEQLayout();
            }
            this.addIPCLayout();
            this.currentChoice = this.ipcString;
        } else {
            if (this.currentChoice.equals(this.beqString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else {
                this.removeIPCLayout();
            }
            this.addBEQLayout();
            this.currentChoice = this.beqString;
        }
        this.doLayout();
    }

    public void saveAddressInfo(AddressList addrList) {
        String protocol = this.getProtocolChoice();
        NVPair nvp = new NVPair("ADDRESS");
        try {
            Address addr = new Address(nvp);
            if (protocol.equals(this.tcpString)) {
                addr._setParameter("PROTOCOL", "TCP");
                addr._setParameter("HOST", this.getHost());
                addr._setParameter("PORT", this.getPort());
            } else if (protocol.equals(this.tcpsString)) {
                addr._setParameter("PROTOCOL", "TCPS");
                addr._setParameter("HOST", this.getTCPSHost());
                addr._setParameter("PORT", this.getTCPSPort());
            } else if (protocol.equals(this.spxString)) {
                addr._setParameter("PROTOCOL", "SPX");
                addr._setParameter("Service", this.getService());
            } else if (protocol.equals(this.nmpString)) {
                addr._setParameter("PROTOCOL", "NMP");
                addr._setParameter("Server", this.getMachine());
                addr._setParameter("Pipe", this.getPipe());
            } else if (protocol.equals(this.ipcString)) {
                addr._setParameter("PROTOCOL", "IPC");
                addr._setParameter("Key", this.getKey());
            } else {
                addr._setParameter("PROTOCOL", "BEQ");
                addr._setParameter("PROGRAM", "oracle80");
                addr._setParameter("ARGV0", "oracle80");
                addr._setParameter("ARGS", "'(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=BEQ)))'");
            }
            addrList.insertAddressAt(addr, 0);
        }
        catch (CreateAddressException createAddressException) {}
    }

    public String getProtocolChoice() {
        return this.currentChoice;
    }

    public void setProtocolChoice(String prot) {
        this.protocolChoice.select(prot);
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public void setHost(String host) {
        this.hostField.setText(host);
    }

    public String getPort() {
        return this.portField.getText();
    }

    public void setPort(String port) {
        this.portField.setText(port);
    }

    public String getTCPSHost() {
        return this.hostFieldTCPS.getText();
    }

    public void setTCPSHost(String host) {
        this.hostFieldTCPS.setText(host);
    }

    public String getTCPSPort() {
        return this.portFieldTCPS.getText();
    }

    public void setTCPSPort(String port) {
        this.portFieldTCPS.setText(port);
    }

    public String getService() {
        return this.serviceField.getText();
    }

    public void setService(String service) {
        this.serviceField.setText(service);
    }

    public String getMachine() {
        return this.machineField.getText();
    }

    public void setMachine(String machine) {
        this.machineField.setText(machine);
    }

    public String getPipe() {
        return this.pipeField.getText();
    }

    public void setPipe(String pipe) {
        this.pipeField.setText(pipe);
    }

    public String getKey() {
        return this.keyField.getText();
    }

    public void setKey(String key) {
        this.keyField.setText(key);
    }

    public boolean getChanged() {
        return this.addrChanged;
    }

    public void setChanged(boolean state) {
        this.addrChanged = state;
    }

    private void add(Component c, GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        ((Container)((Object)this)).add(c);
    }

    private void addTCPLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.hostLabel, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.hostField, this.gbl, this.gbc, 1, 2, 1, 1);
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.add((Component)this.portLabel, this.gbl, this.gbc, 0, 4, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.portField, this.gbl, this.gbc, 1, 4, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 5, 1, 1);
    }

    private void addTCPSLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.hostLabelTCPS, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.hostFieldTCPS, this.gbl, this.gbc, 1, 2, 1, 1);
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.add((Component)this.portLabelTCPS, this.gbl, this.gbc, 0, 4, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.portFieldTCPS, this.gbl, this.gbc, 1, 4, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 5, 1, 1);
    }

    private void addSPXLayout() {
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.serviceLabel, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.serviceField, this.gbl, this.gbc, 1, 3, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 4, 1, 1);
    }

    private void addNMPLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.machineLabel, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.machineField, this.gbl, this.gbc, 1, 2, 1, 1);
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.add((Component)this.pipeLabel, this.gbl, this.gbc, 0, 4, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.pipeField, this.gbl, this.gbc, 1, 4, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 5, 1, 1);
    }

    private void addIPCLayout() {
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.keyLabel, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.keyField, this.gbl, this.gbc, 1, 3, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 4, 1, 1);
    }

    private void addBEQLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 2, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 4, 1, 1);
    }

    private void removeSPXLayout() {
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.serviceLabel);
        ((Container)((Object)this)).remove((Component)this.serviceField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeNMPLayout() {
        ((Container)((Object)this)).remove((Component)this.machineLabel);
        ((Container)((Object)this)).remove((Component)this.machineField);
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.pipeLabel);
        ((Container)((Object)this)).remove((Component)this.pipeField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeTCPLayout() {
        ((Container)((Object)this)).remove((Component)this.hostLabel);
        ((Container)((Object)this)).remove((Component)this.hostField);
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.portLabel);
        ((Container)((Object)this)).remove((Component)this.portField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeTCPSLayout() {
        ((Container)((Object)this)).remove((Component)this.hostLabelTCPS);
        ((Container)((Object)this)).remove((Component)this.hostFieldTCPS);
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.portLabelTCPS);
        ((Container)((Object)this)).remove((Component)this.portFieldTCPS);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeIPCLayout() {
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.keyLabel);
        ((Container)((Object)this)).remove((Component)this.keyField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeBEQLayout() {
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    public boolean checkFields() {
        if (this.currentChoice.equals(this.tcpString)) {
            if (this.hostField.getText().equals("")) {
                this.showNullDialog(this.hostfieldString);
                this.hostField.requestFocus();
                return false;
            }
            String s = this.portField.getText();
            if (s.equals("")) {
                this.showNullDialog(this.portfieldString);
                this.portField.requestFocus();
                return false;
            }
            int port = Integer.parseInt(s, 10);
            if (port < 1 || port > 65535) {
                this.showRangeDialog(this.portfieldString, 1, 65535);
                this.portField.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.tcpsString)) {
            if (this.hostFieldTCPS.getText().equals("")) {
                this.showNullDialog(this.hostfieldString);
                this.hostFieldTCPS.requestFocus();
                return false;
            }
            String s = this.portFieldTCPS.getText();
            if (s.equals("")) {
                this.showNullDialog(this.portfieldString);
                this.portFieldTCPS.requestFocus();
                return false;
            }
            int port = Integer.parseInt(s, 10);
            if (port < 1 || port > 65535) {
                this.showRangeDialog(this.portfieldString, 1, 65535);
                this.portFieldTCPS.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.spxString)) {
            if (this.serviceField.getText().equals("")) {
                this.showNullDialog(this.servicefieldString);
                this.serviceField.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.nmpString)) {
            if (this.machineField.getText().equals("")) {
                this.showNullDialog(this.machinefieldString);
                this.machineField.requestFocus();
                return false;
            }
            if (this.pipeField.getText().equals("")) {
                this.showNullDialog(this.pipefieldString);
                this.pipeField.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.ipcString) && this.keyField.getText().equals("")) {
            this.showNullDialog(this.keyfieldString);
            this.keyField.requestFocus();
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        super.setEnabled(enabled);
        Component[] kids = ((Container)((Object)this)).getComponents();
        int i = 0;
        while (i < kids.length) {
            kids[i].setEnabled(enabled);
            ++i;
        }
    }

    private void showNullDialog(String field) {
        BufferedFrame fr = (BufferedFrame)this.app.getFrame();
        NullFieldDialog nullDialog = new NullFieldDialog(fr, field);
        Toolkit toolkit = fr.getToolkit();
        Dimension dim = toolkit.getScreenSize();
        Dimension dim1 = ((Component)((Object)nullDialog)).getSize();
        ((Component)((Object)nullDialog)).setLocation((dim.width - dim1.width) / 2, (dim.height - dim1.height) / 2);
        ((Dialog)((Object)nullDialog)).setModal(true);
        ((Dialog)((Object)nullDialog)).show();
    }

    private void showRangeDialog(String field, int low, int high) {
        BufferedFrame fr = (BufferedFrame)this.app.getFrame();
        RangeErrorDialog rangeDialog = new RangeErrorDialog(fr, field, low, high);
        Toolkit toolkit = fr.getToolkit();
        Dimension dim = toolkit.getScreenSize();
        Dimension dim1 = ((Component)((Object)rangeDialog)).getSize();
        ((Component)((Object)rangeDialog)).setLocation((dim.width - dim1.width) / 2, (dim.height - dim1.height) / 2);
        ((Dialog)((Object)rangeDialog)).setModal(true);
        ((Dialog)((Object)rangeDialog)).show();
    }
}

