/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.net.asst.addrbook.TNSAddress;
import oracle.net.asst.container.NetApplication;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicename.AddressListPanel;
import oracle.net.asst.servicename.DBPanel;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetClientPropertyPage
extends EwtContainer {
    private WebApplication app;
    private TNSAddress tnsaddr;
    private AddressListPanel addressListPanel;
    private DBPanel dbPanel;
    private LWButton helpButton;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private boolean changed = false;
    private boolean supported = false;
    private String helpButtonString;
    private String addressGroupString;
    private String helpTopicString;

    public NetClientPropertyPage(TNSAddress addr, WebApplication w) {
        this.app = w;
        this.tnsaddr = addr;
        NetStrings netStrings = new NetStrings();
        this.helpTopicString = "TOPICsn";
        this.addressListPanel = new AddressListPanel(this.tnsaddr.getDescription().getAddressList(), this.app);
        this.addressListPanel.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 10, 10, 10), (String)netStrings.getString("SNCAddressGroup")));
        this.dbPanel = new DBPanel(this.tnsaddr.getDescription(), this.app);
        this.dbPanel.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 10, 10, 10), (String)netStrings.getString("SNCServiceGroup")));
        this.helpButtonString = netStrings.getString("SNCHelp");
        this.helpButton = new LWButton(this.helpButtonString);
        this.helpButton.addActionListener((ActionListener)new 1());
        this.gbc = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.gbc.gridy = 0;
        ((Container)((Object)this)).add((Component)((Object)this.addressListPanel), this.gbc);
        this.gbc.gridy = 1;
        this.gbc.fill = 2;
        this.gbc.insets.top = 15;
        ((Container)((Object)this)).add((Component)((Object)this.dbPanel), this.gbc);
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(15, 2, 10, 0);
        this.gbc.gridy = 2;
        ((Container)((Object)this)).add((Component)this.helpButton, this.gbc);
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(20, 20, 0, 20));
    }

    public TNSAddress getTNSAddress() {
        return this.tnsaddr;
    }

    public void setChanged(boolean state) {
        this.changed = state;
        this.addressListPanel.setChanged(state);
        this.dbPanel.setChanged(state);
    }

    public boolean isChanged() {
        return this.changed || this.addressListPanel.isChanged() || this.dbPanel.isChanged();
    }

    public boolean isValidPage() {
        if (!this.addressListPanel.isValidPage()) {
            return false;
        }
        return this.dbPanel.isValidPage();
    }

    public void saveAddressInfo() {
        if (this.addressListPanel.isChanged()) {
            this.addressListPanel.saveAddressInfo();
        }
        if (this.dbPanel.isChanged()) {
            this.dbPanel.saveAddressInfo();
        }
    }

    public String toString() {
        return this.tnsaddr.toString();
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            NetHelp help = ((NetApplication)NetClientPropertyPage.this.app).getHelpContext();
            help.show(NetClientPropertyPage.this.helpTopicString);
        }

        /* synthetic */ 1() {
        }
    }
}

