/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.net.asst.addrbook.TNSAddress;
import oracle.net.asst.addrbook.TNSAddressBook;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.servicename.NetClientPropertyPage;
import oracle.net.asst.servicewizard.ServiceWizard;
import oracle.net.asst.servicewizard.TestConnDialog;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ServiceName
extends NetComponent {
    WebApplication app;
    NetStrings ns;
    String defDomain;
    String name;
    String tnspath;
    boolean objectChanged = false;
    NetVector objectVector;
    NetVector menuVector;
    NetObjectMenu connectMenuItem;
    NetVector toolbarVector;
    NetObjectToolbar connectToolbarItem;
    TNSAddress tnsaddr;
    TNSAddressBook addrBook;
    TNSAddressBook unsupportedBook;
    NetPanel panel;
    NetClientPropertyPage page;
    NetClientPropertyPage activePage;
    ServiceWizard m_theServiceWizard;

    public ServiceName(WebApplication w) {
        String dir = NetUtils.getImageDirectory();
        this.app = w;
        this.objectVector = new NetVector();
        this.ns = new NetStrings();
        this.name = this.ns.getString("SNCComponentName");
        this.menuVector = new NetVector();
        String toolsMenu = this.ns.getString("CNTTools");
        String connect = this.ns.getString("SNCConnectMenu");
        this.connectMenuItem = new NetObjectMenu(toolsMenu, connect, false);
        this.menuVector.addElement(this.connectMenuItem);
        this.toolbarVector = new NetVector();
        Image testImage = Toolkit.getDefaultToolkit().getImage(String.valueOf(dir) + "test.gif");
        this.connectToolbarItem = new NetObjectToolbar(connect, testImage, false);
        this.toolbarVector.addElement(this.connectToolbarItem);
        this.panel = new NetPanel(w, "SN_placebo.gif", this.ns.getString("SNCIntroMessage"));
    }

    public NetVector getObjects(String directoryName) {
        this.objectVector.removeAllElements();
        this.tnspath = directoryName;
        try {
            if (directoryName != null) {
                String fileName = String.valueOf(directoryName) + "tnsnames.ora";
                this.addrBook = new TNSAddressBook(fileName);
                this.unsupportedBook = new TNSAddressBook(fileName);
                this.addrBook.readFile(fileName);
                int i = 0;
                while (i < this.addrBook.getListSize()) {
                    this.tnsaddr = this.addrBook.getListElement(i);
                    if (this.tnsaddr.isSupported()) {
                        this.page = new NetClientPropertyPage(this.tnsaddr, this.app);
                        this.objectVector.addElement(this.page);
                    } else {
                        this.unsupportedBook.addListElement(this.tnsaddr);
                    }
                    ++i;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = new File(directoryName, "tnsnames.ora");
        }
        catch (IOException iOException) {
            System.out.println("IOException");
        }
        return this.objectVector;
    }

    public boolean saveObjects(String directoryName) throws FileNotFoundException, IOException {
        NetClientPropertyPage currpage;
        String fileName = String.valueOf(directoryName) + "tnsnames.ora";
        TNSAddressBook tmpaddrBook = new TNSAddressBook(fileName);
        int i = 0;
        while (i < this.objectVector.size()) {
            currpage = (NetClientPropertyPage)((Object)this.objectVector.elementAt(i));
            if (!currpage.isValidPage()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.objectVector.size()) {
            currpage = (NetClientPropertyPage)((Object)this.objectVector.elementAt(i));
            currpage.saveAddressInfo();
            currpage.setChanged(false);
            tmpaddrBook.addListElement(currpage.getTNSAddress());
            ++i;
        }
        this.objectChanged = false;
        i = 0;
        while (i < this.unsupportedBook.getListSize()) {
            tmpaddrBook.addListElement(this.unsupportedBook.getListElement(i));
            ++i;
        }
        this.addrBook.UpdateAddressBook(tmpaddrBook);
        this.addrBook.writeFile(fileName);
        return true;
    }

    public EwtContainer activateObject(Object object) {
        if (object != null) {
            this.connectMenuItem.setEnabled(true);
            this.connectToolbarItem.setEnabled(true);
            if (object instanceof NetClientPropertyPage) {
                this.activePage = this.page = (NetClientPropertyPage)((Object)object);
                return this.page;
            }
        } else {
            this.connectMenuItem.setEnabled(false);
            this.connectToolbarItem.setEnabled(false);
        }
        this.activePage = null;
        return this.panel;
    }

    public boolean deactivateObject(Object object) {
        if (object != null && object instanceof NetClientPropertyPage) {
            this.page = (NetClientPropertyPage)((Object)object);
            if (!this.page.isValidPage()) {
                return false;
            }
        }
        return true;
    }

    public Object createObject(Object currentObject) {
        return this.createObject(currentObject, ".world");
    }

    public Object createObject(Object currentObject, String defDomain) {
        BufferedFrame fr = (BufferedFrame)this.app.getFrame();
        this.m_theServiceWizard = new ServiceWizard((BufferedFrame)this.app.getFrame(), this.tnspath, this.addrBook, true, defDomain, false);
        this.m_theServiceWizard.go();
        String os = System.getProperty("os.name");
        if (os.equals("Windows NT") || os.equals("Windows 95")) {
            fr.toFront();
        }
        this.tnsaddr = this.m_theServiceWizard.getTheAddress();
        if (this.tnsaddr != null) {
            this.page = new NetClientPropertyPage(this.tnsaddr, this.app);
            this.objectChanged = true;
            this.addrBook.addListElement(this.tnsaddr);
            return this.page;
        }
        return null;
    }

    public boolean deleteObject(Object currentObject) {
        int index = 0;
        while (index < this.objectVector.size()) {
            if (this.objectVector.elementAt(index).equals(currentObject)) {
                this.objectVector.removeElementAt(index);
                this.objectChanged = true;
                this.addrBook.removeListElement(index);
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean discardObjects() {
        return true;
    }

    public boolean isChanged() {
        int i = 0;
        while (i < this.objectVector.size()) {
            NetClientPropertyPage currpage = (NetClientPropertyPage)((Object)this.objectVector.elementAt(i));
            if (currpage.isChanged()) {
                return true;
            }
            ++i;
        }
        return this.objectChanged;
    }

    public String toString() {
        return this.name;
    }

    public boolean Comp_file_has_Comments() {
        return this.addrBook.Comp_file_has_Comments();
    }

    public boolean executeComponentMenu(String menuName) {
        if (menuName.equals(this.ns.getString("SNCConnectMenu"))) {
            if (this.activePage.isValidPage()) {
                BufferedFrame fr = (BufferedFrame)this.app.getFrame();
                TestConnDialog connDialog = new TestConnDialog(fr, this.ns, this.activePage.getTNSAddress());
                Toolkit toolkit = fr.getToolkit();
                Dimension dim = toolkit.getScreenSize();
                Dimension dim1 = ((Component)((Object)connDialog)).getSize();
                ((Component)((Object)connDialog)).setLocation((dim.width - dim1.width) / 2, (dim.height - dim1.height) / 2);
                ((Dialog)((Object)connDialog)).show();
                String os = System.getProperty("os.name");
                if (os.equals("Windows NT") || os.equals("Windows 95")) {
                    fr.toFront();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public NetVector getComponentMenus() {
        return this.menuVector;
    }

    public NetVector getComponentToolbar() {
        return this.toolbarVector;
    }

    public boolean executeComponentToolbar(String toolbarName) {
        return true;
    }
}

