/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.IPCAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class IPCWizardPanel
extends GenericWizardPanel
implements KeyListener {
    public static final String DEFAULT_KEY = new String("ORCL");
    private EditTextField m_keyField;

    public IPCWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.setImage("images/protocol.gif");
        this.m_contentPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        LWLabel header = new LWLabel(this.m_netStrings.getString("SNWIPCPanTitle"));
        TextWrapper textWrap = UniWordWrapper.getTextWrapper();
        MultiLineLabel ipcMsg = new MultiLineLabel(textWrap, this.m_netStrings.getString("SNWIPCPanMsg"));
        ipcMsg.setAlignment(1);
        LWLabel keyLabel = new LWLabel(this.m_netStrings.getString("SNWIPCPanKeyLbl"));
        this.m_keyField = new EditTextField(DEFAULT_KEY);
        ((Component)((Object)this.m_keyField)).addKeyListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridbag);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_contentPanel.add((Component)header);
        gridbag.setConstraints((Component)header, constraints);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.m_contentPanel.add((Component)ipcMsg);
        gridbag.setConstraints((Component)ipcMsg, constraints);
        constraints.fill = 0;
        constraints.weightx = 0.25;
        constraints.insets.bottom = 50;
        constraints.gridwidth = 1;
        constraints.gridy = 2;
        this.m_contentPanel.add((Component)keyLabel);
        gridbag.setConstraints((Component)keyLabel, constraints);
        constraints.weightx = 0.5;
        constraints.ipadx = 4;
        constraints.ipady = 4;
        constraints.fill = 2;
        constraints.insets.left = 5;
        constraints.insets.right = 5;
        constraints.gridx = 1;
        constraints.gridy = 2;
        this.m_contentPanel.add((Component)((Object)this.m_keyField));
        gridbag.setConstraints((Component)((Object)this.m_keyField), constraints);
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        if (cmp.equals(this.m_keyField)) {
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                return;
            }
            if (ch == '\b') {
                return;
            }
            evt.setKeyChar('\u0000');
        }
    }

    public boolean isValid() {
        return !this.m_keyField.getText().equals("");
    }

    public void initFocus() {
        this.m_keyField.requestFocus();
    }

    public void setParams(Address theAddress) {
        if (theAddress != null) {
            this.m_keyField.setText(theAddress._getParameter("KEY"));
        } else {
            this.m_keyField.setText(DEFAULT_KEY);
        }
    }

    public Address getAddress() throws CreateAddressException {
        AddressFactory addrfactory = AddressFactory.getFactory();
        String addr = "(ADDRESS=(PROTOCOL=" + IPCAddress.IPC_PROTOCOL + ")" + "(KEY=" + this.m_keyField.getText() + "))";
        return addrfactory.createAddress(addr);
    }
}

