/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.NMPAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class NMPWizardPanel
extends GenericWizardPanel
implements KeyListener {
    public static final String DEFAULT_PIPE = new String("ORAPIPE");
    private EditTextField m_serverField;
    private EditTextField m_pipeField;

    public NMPWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.setImage("images/protocol.gif");
        this.m_contentPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        LWLabel header = new LWLabel(this.m_netStrings.getString("SNWNMPPanTitle"));
        TextWrapper textWrap = UniWordWrapper.getTextWrapper();
        MultiLineLabel server_label = new MultiLineLabel(textWrap, this.m_netStrings.getString("SNWNMPPanServerMsg"));
        server_label.setAlignment(1);
        MultiLineLabel pipe_label = new MultiLineLabel(textWrap, this.m_netStrings.getString("SNWNMPPanPipeMsg"));
        pipe_label.setAlignment(1);
        LWLabel server_label2 = new LWLabel(this.m_netStrings.getString("SNWNMPPanServerLbl"));
        LWLabel pipe_label2 = new LWLabel(this.m_netStrings.getString("SNWNMPPanPipeLbl"));
        this.m_serverField = new EditTextField("");
        this.m_pipeField = new EditTextField(DEFAULT_PIPE);
        ((Component)((Object)this.m_serverField)).addKeyListener(this);
        ((Component)((Object)this.m_pipeField)).addKeyListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridbag);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_contentPanel.add((Component)header);
        gridbag.setConstraints((Component)header, constraints);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.m_contentPanel.add((Component)server_label);
        gridbag.setConstraints((Component)server_label, constraints);
        constraints.gridy = 3;
        this.m_contentPanel.add((Component)pipe_label);
        gridbag.setConstraints((Component)pipe_label, constraints);
        constraints.fill = 0;
        constraints.weightx = 0.25;
        constraints.gridwidth = 1;
        constraints.gridy = 2;
        this.m_contentPanel.add((Component)server_label2);
        gridbag.setConstraints((Component)server_label2, constraints);
        constraints.gridy = 4;
        this.m_contentPanel.add((Component)pipe_label2);
        gridbag.setConstraints((Component)pipe_label2, constraints);
        constraints.weightx = 0.5;
        constraints.weighty = 0.25;
        constraints.ipadx = 4;
        constraints.ipady = 4;
        constraints.fill = 2;
        constraints.insets.left = 5;
        constraints.insets.right = 5;
        constraints.gridx = 1;
        constraints.gridy = 2;
        this.m_contentPanel.add((Component)((Object)this.m_serverField));
        gridbag.setConstraints((Component)((Object)this.m_serverField), constraints);
        constraints.gridy = 4;
        this.m_contentPanel.add((Component)((Object)this.m_pipeField));
        gridbag.setConstraints((Component)((Object)this.m_pipeField), constraints);
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        if (cmp.equals(this.m_serverField) || cmp.equals(this.m_pipeField)) {
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                return;
            }
            if (ch == '\b') {
                return;
            }
            evt.setKeyChar('\u0000');
        }
    }

    public boolean isValid() {
        return !this.m_serverField.getText().equals("") && !this.m_pipeField.getText().equals("");
    }

    public void setParams(Address theAddress) {
        if (theAddress != null) {
            this.m_serverField.setText(theAddress._getParameter("SERVER"));
            this.m_pipeField.setText(theAddress._getParameter("PIPE"));
        } else {
            this.m_serverField.setText("");
            this.m_pipeField.setText(DEFAULT_PIPE);
        }
    }

    public void initFocus() {
        this.m_serverField.requestFocus();
    }

    public Address getAddress() throws CreateAddressException {
        AddressFactory addrfactory = AddressFactory.getFactory();
        String addr = "(ADDRESS=(PROTOCOL=" + NMPAddress.NMP_PROTOCOL + ")" + "(SERVER=" + this.m_serverField.getText() + ")" + "(PIPE=" + this.m_pipeField.getText() + "))";
        return addrfactory.createAddress(addr);
    }
}

