/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.BEQAddress;
import oracle.net.asst.addr.IPCAddress;
import oracle.net.asst.addr.NMPAddress;
import oracle.net.asst.addr.SPXAddress;
import oracle.net.asst.addr.TCPAddress;
import oracle.net.asst.addr.TCPSAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class ProtocolWizardPanel
extends GenericWizardPanel {
    private static final int VISIBLE_LIST_ITEMS = 5;
    private LWList m_protocolList;
    private String m_protocol;
    private Vector m_avail;

    public ProtocolWizardPanel(NetStrings netStrings, Vector avail) {
        super(netStrings);
        this.setImage("images/protocol.gif");
        this.m_avail = avail;
        TextWrapper Textwrap = UniWordWrapper.getTextWrapper();
        MultiLineLabel prot_label = new MultiLineLabel(Textwrap, this.m_netStrings.getString("SNWProtPanMsg"));
        prot_label.setAlignment(1);
        MultiLineLabel note_label = new MultiLineLabel(Textwrap, this.m_netStrings.getString("SNWProtPanInstr"));
        note_label.setAlignment(1);
        this.m_protocolList = new LWList(5, false);
        this.setupAvailProtocols();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBag);
        constraints.fill = 2;
        constraints.weightx = 0.75;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_contentPanel.add((Component)prot_label);
        gridBag.setConstraints((Component)prot_label, constraints);
        constraints.gridy = 2;
        this.m_contentPanel.add((Component)note_label);
        gridBag.setConstraints((Component)note_label, constraints);
        constraints.fill = 1;
        constraints.insets.top = 2;
        constraints.insets.bottom = 12;
        constraints.weightx = 0.75;
        constraints.gridy = 1;
        gridBag.setConstraints((Component)this.m_protocolList, constraints);
        this.m_contentPanel.add((Component)this.m_protocolList);
    }

    public void setProtocol(Address theAddress) {
        String protocol = "";
        if (theAddress != null) {
            protocol = theAddress.getProtocol();
            int count = 0;
            boolean done = false;
            while (count < this.m_avail.size() && !done) {
                if (this.m_avail.elementAt(count).equals(protocol)) {
                    this.m_protocolList.select(count);
                    done = true;
                }
                ++count;
            }
            if (count > this.m_avail.size()) {
                this.m_protocolList.select(0);
            }
        } else {
            this.m_protocolList.select(0);
        }
    }

    public void setProtocol2(String protocol) {
        int count = 0;
        boolean done = false;
        while (count < this.m_avail.size() && !done) {
            if (((String)this.m_avail.elementAt(count)).equalsIgnoreCase(protocol)) {
                this.m_protocolList.select(count);
                done = true;
            }
            ++count;
        }
        if (!done) {
            this.m_protocolList.select(0);
        }
    }

    public String getProtocol() {
        return (String)this.m_avail.elementAt(this.m_protocolList.getSelectedIndex());
    }

    public void setupAvailProtocols() {
        int count = 0;
        while (count < this.m_avail.size()) {
            if (this.m_avail.elementAt(count).equals(TCPAddress.TCP_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanTCP"));
            } else if (this.m_avail.elementAt(count).equals(TCPSAddress.TCPS_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanTCPS"));
            } else if (this.m_avail.elementAt(count).equals(SPXAddress.SPX_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanSPX"));
            } else if (this.m_avail.elementAt(count).equals(NMPAddress.NMP_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanNMP"));
            } else if (this.m_avail.elementAt(count).equals(BEQAddress.BEQ_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanBEQ"));
            } else if (this.m_avail.elementAt(count).equals(IPCAddress.IPC_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanIPC"));
            }
            ++count;
        }
        this.m_protocolList.select(0);
    }

    public void initFocus() {
        this.m_protocolList.requestFocus();
    }
}

