/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.net.asst.addrbook.ConnectData;
import oracle.net.asst.addrbook.TNSAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class SIDWizardPanel
extends GenericWizardPanel
implements KeyListener,
ItemListener {
    public static final String DEFAULT_SID = new String("ORCL");
    private EditTextField SIDField;
    private EditTextField serviceNameField;
    private LWLabel SIDLabel;
    private LWLabel serviceNameLabel;
    private LWCheckbox SIDBox;
    private LWCheckbox serviceNameBox;
    private LWCheckboxGroup radioGroup;
    private String choice81String;
    private String label81String;
    private String choice80String;
    private String label80String;
    private String mainMsgString;

    public SIDWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.choice81String = netStrings.getString("SNWSidPan81Choice");
        this.label81String = netStrings.getString("SNWSidPan81Label");
        this.choice80String = netStrings.getString("SNWSidPan80Choice");
        this.label80String = netStrings.getString("SNWSidPan80Label");
        this.mainMsgString = netStrings.getString("SNWSidPanMsg");
        MultiLineLabel mainMsg = new MultiLineLabel(UniWordWrapper.getTextWrapper(), netStrings.getString("SNWSidPanMsg"));
        mainMsg.setAlignment(1);
        this.radioGroup = new LWCheckboxGroup();
        this.serviceNameBox = new LWCheckbox(this.choice81String, false, this.radioGroup);
        this.serviceNameLabel = new LWLabel(this.label81String);
        this.serviceNameField = new EditTextField();
        this.serviceNameBox.addItemListener((ItemListener)this);
        ((Component)((Object)this.serviceNameField)).addKeyListener(this);
        this.SIDBox = new LWCheckbox(this.choice80String, false, this.radioGroup);
        this.SIDLabel = new LWLabel(this.label80String);
        this.SIDField = new EditTextField(DEFAULT_SID);
        this.SIDBox.addItemListener((ItemListener)this);
        ((Component)((Object)this.SIDField)).addKeyListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.m_contentPanel.setLayout(gbl);
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.m_contentPanel.add((Component)mainMsg, gbc);
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.insets.left = 10;
        this.m_contentPanel.add((Component)this.serviceNameBox, gbc);
        gbc.weightx = 0.25;
        gbc.gridwidth = 1;
        gbc.gridy = 2;
        gbc.insets.left = 25;
        this.m_contentPanel.add((Component)this.serviceNameLabel, gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        this.m_contentPanel.add((Component)((Object)this.serviceNameField), gbc);
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets.top = 25;
        gbc.insets.left = 10;
        this.m_contentPanel.add((Component)this.SIDBox, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridy = 4;
        gbc.insets.top = 0;
        gbc.insets.left = 25;
        this.m_contentPanel.add((Component)this.SIDLabel, gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        this.m_contentPanel.add((Component)((Object)this.SIDField), gbc);
        this.setImage("images/SID.gif");
        this.m_contentPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        this.serviceNameBox.setState(true);
        this.updateBackCompatState(false);
    }

    public void setParams(TNSAddress theTNSAddress) {
        if (theTNSAddress != null) {
            ConnectData cd = theTNSAddress.getDescription().getConnectData();
            if (cd.isBackCompat()) {
                this.SIDBox.setState(true);
                this.updateBackCompatState(true);
                this.SIDField.setText(cd.getSID());
            } else {
                this.serviceNameBox.setState(true);
                this.updateBackCompatState(false);
                this.serviceNameField.setText(cd.getSERVICE_NAME());
            }
        } else {
            this.updateBackCompatState(false);
            this.SIDField.setText(DEFAULT_SID);
        }
    }

    public boolean isBackCompat() {
        return this.SIDBox.getState();
    }

    public String getService() {
        if (this.SIDBox.getState()) {
            return this.SIDField.getText();
        }
        return this.serviceNameField.getText();
    }

    public void initFocus() {
        this.SIDField.requestFocus();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.SIDBox) {
            this.updateBackCompatState(true);
        } else {
            this.updateBackCompatState(false);
        }
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        if (ch == '\b') {
            return;
        }
        if (cmp.equals(this.SIDField) && (this.SIDField.getText().length() >= 8 || ch == '.')) {
            evt.setKeyChar('\u0000');
        }
        if (cmp.equals(this.serviceNameField) && this.serviceNameField.getText().length() >= 137) {
            evt.setKeyChar('\u0000');
        }
        if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '.') {
            evt.setKeyChar('\u0000');
        }
    }

    private void updateBackCompatState(boolean bc) {
        if (bc) {
            this.SIDField.setEnabled(true);
            this.SIDLabel.setEnabled(true);
            this.serviceNameLabel.setEnabled(false);
            this.serviceNameField.setEnabled(false);
        } else {
            this.SIDField.setEnabled(false);
            this.SIDLabel.setEnabled(false);
            this.serviceNameLabel.setEnabled(true);
            this.serviceNameField.setEnabled(true);
        }
    }
}

