/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.SPXAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class SPXWizardPanel
extends GenericWizardPanel
implements KeyListener {
    private static final String DEFAULT_VAL = "ORACLE_LSNR";
    private EditTextField m_serviceField;

    public SPXWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.setImage("images/protocol.gif");
        this.m_contentPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        LWLabel header = new LWLabel(this.m_netStrings.getString("SNWSPXPanTitle"));
        TextWrapper textWrap = UniWordWrapper.getTextWrapper();
        MultiLineLabel service_label = new MultiLineLabel(textWrap, this.m_netStrings.getString("SNWSPXPanMsg"));
        service_label.setAlignment(1);
        LWLabel service_label2 = new LWLabel(this.m_netStrings.getString("SNWSPXPanServiceLbl"));
        this.m_serviceField = new EditTextField(DEFAULT_VAL);
        ((Component)((Object)this.m_serviceField)).addKeyListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridbag);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_contentPanel.add((Component)header);
        gridbag.setConstraints((Component)header, constraints);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.m_contentPanel.add((Component)service_label);
        gridbag.setConstraints((Component)service_label, constraints);
        constraints.fill = 0;
        constraints.weightx = 0.25;
        constraints.insets.bottom = 50;
        constraints.gridwidth = 1;
        constraints.gridy = 2;
        this.m_contentPanel.add((Component)service_label2);
        gridbag.setConstraints((Component)service_label2, constraints);
        constraints.weightx = 0.5;
        constraints.ipadx = 4;
        constraints.ipady = 4;
        constraints.fill = 2;
        constraints.insets.left = 5;
        constraints.insets.right = 5;
        constraints.gridx = 1;
        constraints.gridy = 2;
        this.m_contentPanel.add((Component)((Object)this.m_serviceField));
        gridbag.setConstraints((Component)((Object)this.m_serviceField), constraints);
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        if (cmp.equals(this.m_serviceField)) {
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                return;
            }
            if (ch == '\b') {
                return;
            }
            evt.setKeyChar('\u0000');
        }
    }

    public boolean isValid() {
        return !this.m_serviceField.getText().equals("");
    }

    public void initFocus() {
        this.m_serviceField.requestFocus();
    }

    public void setParams(Address theAddress) {
        if (theAddress != null) {
            this.m_serviceField.setText(theAddress._getParameter("SERVICE"));
        } else {
            this.m_serviceField.setText("");
        }
    }

    public Address getAddress() throws CreateAddressException {
        AddressFactory addrfactory = AddressFactory.getFactory();
        String addr = "(ADDRESS=(PROTOCOL=" + SPXAddress.SPX_PROTOCOL + ")" + "(SERVICE=" + this.m_serviceField.getText() + "))";
        return addrfactory.createAddress(addr);
    }
}

