/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addrbook.TNSAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class ServiceNameWizardPanel
extends GenericWizardPanel
implements KeyListener {
    private EditTextField m_serviceNameField;
    private String m_domain;
    private MultiLineLabel m_srvcname_label;

    public ServiceNameWizardPanel(NetStrings netStrings, String defDomain) {
        super(netStrings);
        this.setImage("images/NewName.gif");
        this.m_contentPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        this.m_domain = defDomain;
        TextWrapper Textwrap = UniWordWrapper.getTextWrapper();
        this.m_srvcname_label = new MultiLineLabel(Textwrap, this.m_netStrings.getString("SNWSrvPanMsgCreate"));
        this.m_srvcname_label.setAlignment(1);
        LWLabel srvcname_label2 = new LWLabel(this.m_netStrings.getString("SNWNewPanLbl"));
        this.m_serviceNameField = new EditTextField();
        ((Component)((Object)this.m_serviceNameField)).addKeyListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        gridbag.setConstraints((Component)this.m_srvcname_label, constraints);
        this.m_contentPanel.add((Component)this.m_srvcname_label);
        constraints.fill = 0;
        constraints.weightx = 0.25;
        constraints.insets.bottom = 20;
        constraints.gridwidth = 1;
        constraints.gridy = 1;
        constraints.gridy = 1;
        gridbag.setConstraints((Component)srvcname_label2, constraints);
        this.m_contentPanel.add((Component)srvcname_label2);
        constraints.weightx = 0.5;
        constraints.weighty = 0.25;
        constraints.ipadx = 4;
        constraints.ipady = 4;
        constraints.fill = 2;
        constraints.insets.left = 10;
        constraints.insets.right = 10;
        constraints.gridx = 1;
        constraints.gridy = 1;
        this.m_contentPanel.add((Component)((Object)this.m_serviceNameField));
        gridbag.setConstraints((Component)((Object)this.m_serviceNameField), constraints);
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        if (cmp.equals(this.m_serviceNameField)) {
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                return;
            }
            if (ch == '.') {
                return;
            }
            if (ch == '\b') {
                return;
            }
            evt.setKeyChar('\u0000');
        }
    }

    public void initFocus() {
        this.m_serviceNameField.requestFocus();
    }

    public void setService(TNSAddress theTNSAddress) {
        if (theTNSAddress != null) {
            this.m_serviceNameField.setText(theTNSAddress.getName());
        } else {
            this.m_serviceNameField.setText("");
        }
    }

    public String getService() {
        String sname = this.m_serviceNameField.getText();
        if (sname.equals("")) {
            return sname;
        }
        if (sname.endsWith("." + this.m_domain)) {
            return sname;
        }
        if (sname.endsWith(".")) {
            return sname.substring(0, sname.length() - 1);
        }
        if (!this.m_domain.equals("")) {
            return String.valueOf(sname) + "." + this.m_domain;
        }
        return sname;
    }

    public void setMessage(String newMessage) {
        if (newMessage != null) {
            this.m_srvcname_label.setText(newMessage);
        }
    }
}

