/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ewt.alert.Alert;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.wizard.Wizard;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardValidateListener;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.BEQAddress;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.IPCAddress;
import oracle.net.asst.addr.NMPAddress;
import oracle.net.asst.addr.SPXAddress;
import oracle.net.asst.addr.TCPAddress;
import oracle.net.asst.addr.TCPSAddress;
import oracle.net.asst.addrbook.AddressList;
import oracle.net.asst.addrbook.ConnectData;
import oracle.net.asst.addrbook.TNSAddress;
import oracle.net.asst.addrbook.TNSAddressBook;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.BEQWizardPanel;
import oracle.net.asst.servicewizard.ConnectWizardPanel;
import oracle.net.asst.servicewizard.IPCWizardPanel;
import oracle.net.asst.servicewizard.NMPWizardPanel;
import oracle.net.asst.servicewizard.NextTimePanel;
import oracle.net.asst.servicewizard.ProtocolWizardPanel;
import oracle.net.asst.servicewizard.SIDWizardPanel;
import oracle.net.asst.servicewizard.SPXWizardPanel;
import oracle.net.asst.servicewizard.ServiceNameWizardPanel;
import oracle.net.asst.servicewizard.ServiceWizardPanel;
import oracle.net.asst.servicewizard.TCPSWizardPanel;
import oracle.net.asst.servicewizard.TCPWizardPanel;
import oracle.net.asst.servicewizard.TestConnDialog;
import oracle.net.asst.servicewizard.WizardDisplay;

public final class ServiceWizard
implements ActionListener,
WindowListener,
WizardListener,
WizardValidateListener {
    private static final int ALERTX = 150;
    private static final int ALERTY = 150;
    private static final int TSTDLGX = 150;
    private static final int TSTDLGY = 150;
    private static final int EXIT_USER_CANCEL = -1;
    private static final int EXIT_NORMAL = 0;
    private static final int EXIT_ERROR = 1;
    private TNSAddressBook m_tnsAddressBook;
    private TNSAddress m_tnsAddress;
    private AddressList m_addressList;
    private String m_protocol;
    private Vector m_addrVect;
    private Vector m_availProtVect;
    private NetProperties m_property;
    private boolean m_modify = false;
    private NetStrings m_netStrings;
    private String m_defaultProtocol = "TCP";
    private String m_messageText;
    private Alert m_alert;
    private BufferedFrame m_theFrame;
    private Wizard m_theWizard;
    private WizardDisplay m_theDialog;
    private BufferedFrame m_callerFrame;
    private ServiceWizardPanel m_serviceWizPan;
    private ServiceNameWizardPanel m_serviceNameWizPan;
    private ProtocolWizardPanel m_protocolWizPan;
    private TCPWizardPanel m_TCPWizPan;
    private TCPSWizardPanel m_TCPSWizPan;
    private SPXWizardPanel m_SPXWizPan;
    private NMPWizardPanel m_NMPWizPan;
    private BEQWizardPanel m_BEQWizPan;
    private IPCWizardPanel m_IPCWizPan;
    private SIDWizardPanel m_SIDWizPan;
    private ConnectWizardPanel m_connectWizPan;
    private NextTimePanel m_nextTimePan;
    private String m_titleString;
    private String m_welcomeString;
    private String m_page1String;
    private String m_page2String;
    private String m_page3String;
    private String m_page4String;
    private String m_page5String;
    private String m_finishString;
    private WizardPage m_serviceWizPg;
    private WizardPage m_serviceNameWizPg;
    private WizardPage m_protocolWizPg;
    private WizardPage m_TCPWizPg;
    private WizardPage m_TCPSWizPg;
    private WizardPage m_SPXWizPg;
    private WizardPage m_NMPWizPg;
    private WizardPage m_BEQWizPg;
    private WizardPage m_IPCWizPg;
    private WizardPage m_SIDWizPg;
    private WizardPage m_connectWizPg;
    private WizardPage m_nextTimeWizPg;
    private boolean m_createonly;
    private boolean m_exitWhenDone;

    public ServiceWizard(BufferedFrame callerFrame, String tnspath, TNSAddressBook theTNSAddressBook, boolean createonly, String defDomain, boolean exitWhenDone) {
        this.m_callerFrame = callerFrame;
        this.m_createonly = createonly;
        this.m_exitWhenDone = exitWhenDone;
        try {
            this.m_netStrings = new NetStrings();
        }
        catch (Exception exc) {
            System.out.println("ServiceWizard.<init>: Message Resource exception." + exc);
            this.conditionalExit(1);
        }
        if (theTNSAddressBook == null) {
            try {
                this.m_tnsAddressBook = new TNSAddressBook(String.valueOf(tnspath) + "tnsnames.ora");
                this.m_tnsAddressBook.readFile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                File file = new File(tnspath, "tnsnames.ora");
            }
            catch (IOException exc) {
                System.out.println("ServiceWizard.<init>: IOException." + exc);
                this.conditionalExit(1);
            }
        } else {
            this.m_tnsAddressBook = theTNSAddressBook;
        }
        this.setupAddresses();
        try {
            this.m_property = new NetProperties();
        }
        catch (Exception exc) {
            System.out.println("ServiceWizard.<init>: Network Properties loading exception." + exc);
            this.conditionalExit(1);
        }
        this.setupAvailProtocols();
        this.m_theFrame = new BufferedFrame();
        this.m_theWizard = new Wizard();
        this.m_theWizard.addWizardListener((WizardListener)this);
        this.m_theWizard.setMustFinish(true);
        this.m_theWizard.setHelpAvailable(false);
        this.m_theWizard.setCanApply(false);
        this.setupInitPanels(defDomain);
        this.setupAddressPanels();
        this.m_welcomeString = this.m_netStrings.getString("SNWTitleWelcome");
        this.m_page1String = this.m_netStrings.getString("SNWTitlePage1");
        this.m_page2String = this.m_netStrings.getString("SNWTitlePage2");
        this.m_page3String = this.m_netStrings.getString("SNWTitlePage3");
        this.m_page4String = this.m_netStrings.getString("SNWTitlePage4");
        this.m_page5String = this.m_netStrings.getString("SNWTitlePage5");
        this.m_finishString = this.m_netStrings.getString("SNWTitleFinish");
        this.m_titleString = !this.m_exitWhenDone ? new String(this.m_netStrings.getString("SNWWizardTitle")) : new String(this.m_netStrings.getString("SNWEZTitle"));
        this.m_theDialog = createonly ? new WizardDisplay(callerFrame, String.valueOf(this.m_titleString) + this.m_page1String, true) : new WizardDisplay(callerFrame, String.valueOf(this.m_titleString) + this.m_welcomeString, true);
        ((Container)((Object)this.m_theDialog)).add((Component)this.m_theWizard);
        ((Window)((Object)this.m_theDialog)).addWindowListener(this);
        this.centerOnScreen(callerFrame, (Component)((Object)this.m_theDialog));
    }

    public ServiceWizard(BufferedFrame callerFrame, String tnspath, TNSAddressBook theTNSAddressBook, boolean createonly, String defDomain, boolean exitWhenDone, String defaultProtocol, String messageText) {
        this(callerFrame, tnspath, theTNSAddressBook, createonly, defDomain, exitWhenDone);
        this.m_defaultProtocol = defaultProtocol;
        this.m_messageText = messageText;
    }

    public void go() {
        if (!this.m_createonly) {
            this.m_serviceWizPan.initFocus();
        } else {
            this.m_protocolWizPan.setProtocol2(this.m_defaultProtocol);
            if (this.m_messageText != null) {
                this.m_serviceNameWizPan.setMessage(this.m_messageText);
            }
            this.m_serviceNameWizPan.initFocus();
        }
        ((Dialog)((Object)this.m_theDialog)).show();
        this.conditionalExit(0);
    }

    public void wizardValidatePage(WizardEvent evt) {
        WizardPage wp = evt.getPage();
        if (wp == this.m_serviceWizPg) {
            if (this.m_serviceWizPan.getSelection() == 1) {
                if (this.m_serviceWizPan.getNewName().equals("")) {
                    this.blankAlert();
                    ((Cancelable)evt).cancel();
                } else if (this.isDuplicate(this.m_serviceWizPan.getNewName())) {
                    this.dupAlert(this.m_serviceWizPan.getNewName());
                    this.m_serviceWizPan.initFocus();
                    ((Cancelable)evt).cancel();
                } else {
                    this.doCreate();
                }
            }
            if (this.m_serviceWizPan.getSelection() == 2) {
                this.doModify();
            }
            if (this.m_serviceWizPan.getSelection() == 0) {
                this.doTest();
            }
            if (this.m_serviceWizPan.getSelection() == 3 && !this.doDelete()) {
                ((Cancelable)evt).cancel();
            }
        } else if (wp == this.m_serviceNameWizPg) {
            if (this.m_serviceNameWizPan.getService().equals("")) {
                this.blankAlert();
                ((Cancelable)evt).cancel();
            } else if (this.isDuplicate(this.m_serviceNameWizPan.getService())) {
                this.dupAlert(this.m_serviceNameWizPan.getService());
                this.m_serviceNameWizPan.initFocus();
                ((Cancelable)evt).cancel();
            }
        } else if (wp == this.m_protocolWizPg) {
            this.m_protocol = this.m_protocolWizPan.getProtocol();
            if (this.m_protocol.equals(TCPSAddress.TCPS_PROTOCOL)) {
                this.enableTCPS();
            }
            if (this.m_protocol.equals(TCPAddress.TCP_PROTOCOL)) {
                this.enableTCP();
            }
            if (this.m_protocol.equals(SPXAddress.SPX_PROTOCOL)) {
                this.enableSPX();
            }
            if (this.m_protocol.equals(NMPAddress.NMP_PROTOCOL)) {
                this.enableNMP();
            }
            if (this.m_protocol.equals(BEQAddress.BEQ_PROTOCOL)) {
                this.enableBEQ();
            }
            if (this.m_protocol.equals(IPCAddress.IPC_PROTOCOL)) {
                this.enableIPC();
            }
        } else if (wp == this.m_TCPWizPg) {
            if (!this.m_TCPWizPan.isValid()) {
                this.blankAlert();
                ((Cancelable)evt).cancel();
            }
        } else if (wp == this.m_TCPSWizPg) {
            if (!this.m_TCPSWizPan.isValid()) {
                this.blankAlert();
                ((Cancelable)evt).cancel();
            }
        } else if (wp == this.m_SPXWizPg) {
            if (!this.m_SPXWizPan.isValid()) {
                this.blankAlert();
                ((Cancelable)evt).cancel();
            }
        } else if (wp == this.m_NMPWizPg) {
            if (!this.m_NMPWizPan.isValid()) {
                this.blankAlert();
                ((Cancelable)evt).cancel();
            }
        } else if (wp == this.m_IPCWizPg) {
            if (!this.m_IPCWizPan.isValid()) {
                this.blankAlert();
                ((Cancelable)evt).cancel();
            }
        } else if (wp == this.m_SIDWizPg) {
            if (this.m_SIDWizPan.getService().equals("")) {
                this.blankAlert();
                ((Cancelable)evt).cancel();
            } else {
                this.buildAddress();
            }
        }
    }

    public void wizardSelectionChanged(WizardEvent evt) {
        WizardPage wp = evt.getPage();
        String suffix = "";
        if (wp == this.m_serviceWizPg) {
            suffix = this.m_welcomeString;
        } else if (wp == this.m_serviceNameWizPg) {
            suffix = this.m_page1String;
        } else if (wp == this.m_protocolWizPg) {
            suffix = this.m_page2String;
        } else if (wp == this.m_TCPWizPg || wp == this.m_SPXWizPg || wp == this.m_NMPWizPg || wp == this.m_IPCWizPg || wp == this.m_TCPSWizPg) {
            suffix = this.m_page3String;
        } else if (wp == this.m_SIDWizPg) {
            suffix = this.m_page4String;
        } else if (wp == this.m_connectWizPg) {
            suffix = this.m_page5String;
        } else if (wp == this.m_nextTimeWizPg) {
            suffix = this.m_finishString;
        }
        if (this.m_theDialog != null) {
            ((Dialog)((Object)this.m_theDialog)).setTitle(String.valueOf(this.m_titleString) + suffix);
        }
    }

    public void wizardApplyState(WizardEvent evt) {
    }

    public void wizardCanceled(WizardEvent evt) {
        this.m_tnsAddress = null;
        ((Component)((Object)this.m_theDialog)).setVisible(false);
        this.m_theDialog.dispose();
        this.conditionalExit(-1);
    }

    public void wizardFinished(WizardEvent evt) {
        if (!this.m_createonly || this.m_exitWhenDone) {
            this.updateBook();
            this.doSave();
        }
        this.m_theDialog.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        ((Component)source).setEnabled(false);
        if (source instanceof LWButton && evt.getActionCommand().compareTo(ConnectWizardPanel.ACTION_TEST) == 0) {
            WizardPage currentPage = this.m_theWizard.getSelectedPage();
            boolean initialButtonState = currentPage.getCanAdvance();
            currentPage.setCanAdvance(false);
            TestConnDialog testConnDialog = new TestConnDialog(this.m_theFrame, this.m_netStrings, this.m_tnsAddress);
            this.centerOnScreen(this.m_theFrame, (Component)((Object)testConnDialog));
            ((Dialog)((Object)testConnDialog)).show();
            currentPage.setCanAdvance(initialButtonState);
            String os = System.getProperty("os.name");
            if (os.equals("Windows NT") || os.equals("Windows 95")) {
                ((Window)((Object)this.m_theDialog)).toFront();
            }
        }
        ((Component)source).setEnabled(true);
    }

    public void windowClosing(WindowEvent evt) {
        this.m_tnsAddress = null;
        ((Component)((Object)this.m_theDialog)).setVisible(false);
        this.m_theDialog.dispose();
    }

    public void windowOpened(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public TNSAddress getTheAddress() {
        return this.m_tnsAddress;
    }

    void doSave() {
        try {
            this.m_tnsAddressBook.writeFile();
        }
        catch (FileNotFoundException exc) {
            System.out.println("ServiceWizard.doSave(): " + exc);
            this.conditionalExit(1);
        }
        catch (IOException exc) {
            System.out.println("ServiceWizard.doSave(): " + exc);
            this.conditionalExit(1);
        }
    }

    void doTest() {
        String name = this.m_serviceWizPan.getSelectedService();
        if (!this.m_tnsAddressBook.contains(name)) {
            throw new IllegalStateException("ServiceWizard.doTest(): expected address not found in address book");
        }
        this.m_tnsAddress = this.m_tnsAddressBook.getAddress(name);
        this.disableAddressPanels();
        TestConnDialog testConnDialog = new TestConnDialog(this.m_theFrame, this.m_netStrings, this.m_tnsAddress);
        this.centerOnScreen(this.m_theFrame, (Component)((Object)testConnDialog));
        ((Dialog)((Object)testConnDialog)).show();
        String os = System.getProperty("os.name");
        if (os.equals("Windows NT") || os.equals("Windows 95")) {
            ((Window)((Object)this.m_theDialog)).toFront();
        }
    }

    boolean doDelete() {
        boolean doDel = false;
        String name = this.m_serviceWizPan.getSelectedService();
        if (!this.m_tnsAddressBook.contains(name)) {
            throw new IllegalStateException("ServiceWizard.doDelete(): expected address not found in address book");
        }
        this.m_tnsAddress = this.m_tnsAddressBook.getAddress(name);
        Object[] msgParams = new Object[]{this.m_tnsAddress.getName()};
        this.m_alert = new Alert((Frame)this.m_theFrame, MessageFormat.format(this.m_netStrings.getString("SNWDelConfirm"), msgParams), 1, 5);
        this.centerOnScreen(this.m_theFrame, (Component)this.m_alert);
        switch (this.m_alert.runAlert()) {
            case 1: {
                doDel = true;
                break;
            }
            case 4: {
                doDel = false;
                break;
            }
        }
        this.m_alert.dispose();
        String os = System.getProperty("os.name");
        if (os.equals("Windows NT") || os.equals("Windows 95")) {
            ((Window)((Object)this.m_theDialog)).toFront();
        }
        if (doDel) {
            this.disableAddressPanels();
            this.m_tnsAddressBook.removeAddress(name);
            this.m_serviceWizPan.removeListElement(name);
            this.m_tnsAddress = null;
        }
        return doDel;
    }

    void doModify() {
        this.m_modify = true;
        String name = this.m_serviceWizPan.getSelectedService();
        if (!this.m_tnsAddressBook.contains(name)) {
            throw new IllegalStateException("ServiceWizard.doTest(): expected address not found in address book");
        }
        this.m_tnsAddress = this.m_tnsAddressBook.getAddress(name);
        this.enableAddressPanels();
    }

    void doCreate() {
        this.m_modify = false;
        this.m_tnsAddress = null;
        this.enableAddressPanels();
    }

    private boolean isDuplicate(String name) {
        return this.m_tnsAddressBook.contains(name);
    }

    void dupAlert(String name) {
        Toolkit.getDefaultToolkit().beep();
        Object[] msgParams = new Object[]{name};
        this.m_alert = new Alert((Frame)this.m_theFrame, MessageFormat.format(this.m_netStrings.getString("SNWDuplicate"), msgParams), 3, 1);
        this.centerOnScreen(this.m_theFrame, (Component)this.m_alert);
        this.m_alert.runAlert();
        this.m_alert.dispose();
        String os = System.getProperty("os.name");
        if (os.equals("Windows NT") || os.equals("Windows 95")) {
            ((Window)((Object)this.m_theDialog)).toFront();
        }
    }

    void blankAlert() {
        Toolkit.getDefaultToolkit().beep();
        this.m_alert = new Alert((Frame)this.m_theFrame, this.m_netStrings.getString("SNWSupplyAll"), 3, 1);
        this.centerOnScreen(this.m_theFrame, (Component)this.m_alert);
        this.m_alert.runAlert();
        this.m_alert.dispose();
        if (System.getProperty("os.name").equals("Windows NT")) {
            ((Window)((Object)this.m_theDialog)).toFront();
        }
    }

    private void enableAddressPanels() {
        if (this.m_tnsAddress != null) {
            this.m_SIDWizPan.setParams(this.m_tnsAddress);
            this.m_addressList = this.m_tnsAddress.getDescription().getAddressList();
            Address theAddress = this.m_addressList.getAddressAt(0);
            this.m_protocolWizPan.setProtocol(theAddress);
            String protocol = theAddress.getProtocol();
            if (protocol.equals(TCPAddress.TCP_PROTOCOL)) {
                this.m_TCPWizPan.setParams(theAddress);
                this.m_TCPSWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (protocol.equals(TCPSAddress.TCPS_PROTOCOL)) {
                this.m_TCPSWizPan.setParams(theAddress);
                this.m_TCPWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (protocol.equals(SPXAddress.SPX_PROTOCOL)) {
                this.m_SPXWizPan.setParams(theAddress);
                this.m_TCPSWizPan.setParams(null);
                this.m_TCPWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (protocol.equals(NMPAddress.NMP_PROTOCOL)) {
                this.m_NMPWizPan.setParams(theAddress);
                this.m_TCPSWizPan.setParams(null);
                this.m_TCPWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (protocol.equals(IPCAddress.IPC_PROTOCOL)) {
                this.m_IPCWizPan.setParams(theAddress);
                this.m_TCPSWizPan.setParams(null);
                this.m_TCPWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
            }
        } else {
            this.m_protocolWizPan.setProtocol(null);
            this.m_SIDWizPan.setParams(null);
        }
        this.m_protocolWizPg.setEnabled(true);
        this.m_protocolWizPg.setVisible(true);
        this.m_SIDWizPg.setEnabled(true);
        this.m_SIDWizPg.setVisible(true);
        this.m_connectWizPg.setEnabled(true);
        this.m_connectWizPg.setVisible(true);
    }

    private void disableAddressPanels() {
        this.m_protocolWizPg.setEnabled(false);
        this.m_protocolWizPg.setVisible(false);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
        this.m_SIDWizPg.setEnabled(false);
        this.m_SIDWizPg.setVisible(false);
        this.m_connectWizPg.setEnabled(false);
        this.m_connectWizPg.setVisible(false);
    }

    private void enableTCP() {
        this.m_TCPWizPg.setEnabled(true);
        this.m_TCPWizPg.setVisible(true);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableTCPS() {
        this.m_TCPSWizPg.setEnabled(true);
        this.m_TCPSWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableSPX() {
        this.m_SPXWizPg.setEnabled(true);
        this.m_SPXWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableNMP() {
        this.m_NMPWizPg.setEnabled(true);
        this.m_NMPWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableBEQ() {
        this.m_BEQWizPg.setEnabled(true);
        this.m_BEQWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableIPC() {
        this.m_IPCWizPg.setEnabled(true);
        this.m_IPCWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
    }

    void updateBook() {
        if (this.m_modify) {
            String name = this.m_serviceWizPan.getSelectedService();
            if (!this.m_tnsAddressBook.contains(name)) {
                throw new IllegalStateException("ServiceWizard.updateBook(): expected address not found in address book");
            }
            this.m_tnsAddressBook.removeAddress(name);
        }
        this.m_tnsAddressBook.addListElement(this.m_tnsAddress);
    }

    private void centerOnScreen(BufferedFrame fr, Component cmp) {
        Toolkit toolkit = fr.getToolkit();
        Dimension screenDim = toolkit.getScreenSize();
        Dimension compDim = cmp.getSize();
        cmp.setLocation((screenDim.width - compDim.width) / 2, (screenDim.height - compDim.height) / 2);
    }

    void buildAddress() {
        block8: {
            try {
                if (this.m_modify) {
                    String newSID = this.m_SIDWizPan.getService();
                    String name = this.m_serviceWizPan.getSelectedService();
                    if (!this.m_tnsAddressBook.contains(name)) {
                        throw new IllegalStateException("ServiceWizard.doTest(): expected address " + name + " not found in address book");
                    }
                    this.m_tnsAddress = this.m_tnsAddressBook.getAddress(name);
                    try {
                        ConnectData cd = this.m_tnsAddress.getDescription().getConnectData();
                        if (this.m_SIDWizPan.isBackCompat()) {
                            cd.setBackCompat(true);
                            cd.setSID(newSID);
                        } else {
                            cd.setBackCompat(false);
                            cd.setSERVICE_NAME(newSID);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("ServiceWizard.buildAddress(): " + e);
                        this.conditionalExit(1);
                    }
                    this.m_addressList.removeAddressAt(0);
                    this.m_addressList.addAddress(this.getGeneratedAddress(newSID));
                    break block8;
                }
                String newSID = this.m_SIDWizPan.getService();
                String name = this.m_createonly ? this.m_serviceNameWizPan.getService() : this.m_serviceWizPan.getNewName();
                Address address = this.getGeneratedAddress(newSID);
                this.m_tnsAddress = new TNSAddress(name, newSID, address, this.m_SIDWizPan.isBackCompat());
            }
            catch (CreateAddressException exc) {
                System.err.println("ServiceWizard.buildAddress(): " + exc);
                this.conditionalExit(1);
            }
        }
    }

    protected Address getGeneratedAddress(String theSID) throws CreateAddressException {
        if (this.m_protocol.equals(TCPAddress.TCP_PROTOCOL)) {
            return this.m_TCPWizPan.getAddress();
        }
        if (this.m_protocol.equals(TCPSAddress.TCPS_PROTOCOL)) {
            return this.m_TCPSWizPan.getAddress();
        }
        if (this.m_protocol.equals(SPXAddress.SPX_PROTOCOL)) {
            return this.m_SPXWizPan.getAddress();
        }
        if (this.m_protocol.equals(NMPAddress.NMP_PROTOCOL)) {
            return this.m_NMPWizPan.getAddress();
        }
        if (this.m_protocol.equals(BEQAddress.BEQ_PROTOCOL)) {
            return this.m_BEQWizPan.getAddress();
        }
        if (this.m_protocol.equals(IPCAddress.IPC_PROTOCOL)) {
            return this.m_IPCWizPan.getAddress();
        }
        throw new IllegalArgumentException("ServiceWizard: Illegal protocol \"" + this.m_protocol + "\" on FINISH.");
    }

    private void setupAddresses() {
        this.m_addrVect = new Vector(5, 5);
        int count = 0;
        while (count < this.m_tnsAddressBook.getListSize()) {
            TNSAddress t = this.m_tnsAddressBook.getListElement(count);
            if (t.isSupported()) {
                this.m_addrVect.addElement(t.getName());
            }
            ++count;
        }
    }

    private void setupAvailProtocols() {
        this.m_availProtVect = new Vector();
        String support = new String("");
        support = this.m_property.getProperty("TCP");
        if (support != null && support.toUpperCase().equals("YES")) {
            this.m_availProtVect.addElement(TCPAddress.TCP_PROTOCOL);
        }
        if ((support = this.m_property.getProperty("TCPS")) != null && support.toUpperCase().equals("YES")) {
            this.m_availProtVect.addElement(TCPSAddress.TCPS_PROTOCOL);
        }
        if ((support = this.m_property.getProperty("SPX")) != null && support.toUpperCase().equals("YES")) {
            this.m_availProtVect.addElement(SPXAddress.SPX_PROTOCOL);
        }
        if ((support = this.m_property.getProperty("NMP")) != null && support.toUpperCase().equals("YES")) {
            this.m_availProtVect.addElement(NMPAddress.NMP_PROTOCOL);
        }
        if ((support = this.m_property.getProperty("BEQ")) != null && support.toUpperCase().equals("YES")) {
            this.m_availProtVect.addElement(BEQAddress.BEQ_PROTOCOL);
        }
        if ((support = this.m_property.getProperty("IPC")) != null && support.toUpperCase().equals("YES")) {
            this.m_availProtVect.addElement(IPCAddress.IPC_PROTOCOL);
        }
    }

    private void setupInitPanels(String defDomain) {
        if (!this.m_createonly) {
            this.m_serviceWizPan = new ServiceWizardPanel(this.m_netStrings, this.m_addrVect, defDomain);
            this.m_serviceWizPg = new WizardPage((Component)((Object)this.m_serviceWizPan), this.m_netStrings.getString("SNWBeginTle"));
            this.m_theWizard.addPage(this.m_serviceWizPg);
            this.m_serviceWizPg.addWizardValidateListener((WizardValidateListener)this);
        } else {
            this.m_serviceNameWizPan = new ServiceNameWizardPanel(this.m_netStrings, defDomain);
            this.m_serviceNameWizPg = new WizardPage((Component)((Object)this.m_serviceNameWizPan), this.m_netStrings.getString("SNWNewServiceTle"));
            this.m_theWizard.addPage(this.m_serviceNameWizPg);
            this.m_serviceNameWizPg.addWizardValidateListener((WizardValidateListener)this);
        }
        this.m_connectWizPan = new ConnectWizardPanel(this.m_netStrings, this);
        this.m_connectWizPg = new WizardPage((Component)((Object)this.m_connectWizPan), this.m_netStrings.getString("SNWConnTle"));
        this.m_theWizard.addPage(this.m_connectWizPg);
        this.m_connectWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_nextTimePan = new NextTimePanel(this.m_netStrings);
        this.m_nextTimeWizPg = new WizardPage((Component)((Object)this.m_nextTimePan), this.m_netStrings.getString("SNWFinishTle"));
        this.m_theWizard.addPage(this.m_nextTimeWizPg);
        this.m_nextTimeWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_nextTimeWizPg.setEnabled(!this.m_createonly);
        this.m_nextTimeWizPg.setVisible(!this.m_createonly);
    }

    private void setupAddressPanels() {
        this.m_protocolWizPan = new ProtocolWizardPanel(this.m_netStrings, this.m_availProtVect);
        this.m_protocolWizPg = new WizardPage((Component)((Object)this.m_protocolWizPan), this.m_netStrings.getString("SNWProtTle"));
        this.m_theWizard.addPage(this.m_protocolWizPg, this.m_connectWizPg);
        this.m_protocolWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_protocolWizPg.setEnabled(this.m_createonly);
        this.m_protocolWizPg.setVisible(this.m_createonly);
        this.m_TCPWizPan = new TCPWizardPanel(this.m_netStrings);
        this.m_TCPWizPg = new WizardPage((Component)((Object)this.m_TCPWizPan), new String("TCP LWContainer"));
        this.m_theWizard.addPage(this.m_TCPWizPg, this.m_connectWizPg);
        this.m_TCPWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPan = new TCPSWizardPanel(this.m_netStrings);
        this.m_TCPSWizPg = new WizardPage((Component)((Object)this.m_TCPSWizPan), new String("TCPS LWContainer"));
        this.m_theWizard.addPage(this.m_TCPSWizPg, this.m_connectWizPg);
        this.m_TCPSWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPan = new SPXWizardPanel(this.m_netStrings);
        this.m_SPXWizPg = new WizardPage((Component)((Object)this.m_SPXWizPan), new String("SPX LWContainer"));
        this.m_theWizard.addPage(this.m_SPXWizPg, this.m_connectWizPg);
        this.m_SPXWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPan = new NMPWizardPanel(this.m_netStrings);
        this.m_NMPWizPg = new WizardPage((Component)((Object)this.m_NMPWizPan), new String("NMP LWContainer"));
        this.m_theWizard.addPage(this.m_NMPWizPg, this.m_connectWizPg);
        this.m_NMPWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPan = new BEQWizardPanel(this.m_netStrings);
        this.m_BEQWizPg = new WizardPage((Component)((Object)this.m_BEQWizPan), new String("BEQ LWContainer"));
        this.m_theWizard.addPage(this.m_BEQWizPg, this.m_connectWizPg);
        this.m_BEQWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPan = new IPCWizardPanel(this.m_netStrings);
        this.m_IPCWizPg = new WizardPage((Component)((Object)this.m_IPCWizPan), new String("IPC LWContainer"));
        this.m_theWizard.addPage(this.m_IPCWizPg, this.m_connectWizPg);
        this.m_IPCWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
        this.m_SIDWizPan = new SIDWizardPanel(this.m_netStrings);
        this.m_SIDWizPg = new WizardPage((Component)((Object)this.m_SIDWizPan), this.m_netStrings.getString("SNWSIDTle"));
        this.m_theWizard.addPage(this.m_SIDWizPg, this.m_connectWizPg);
        this.m_SIDWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_SIDWizPg.setEnabled(this.m_createonly);
        this.m_SIDWizPg.setVisible(this.m_createonly);
    }

    private void conditionalExit(int errorCode) {
        if (this.m_exitWhenDone) {
            System.exit(errorCode);
        }
    }
}

