/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class ServiceWizardPanel
extends GenericWizardPanel
implements ItemListener,
KeyListener {
    public static final int RB_TEST = 0;
    public static final int RB_CREATE = 1;
    public static final int RB_MODIFY = 2;
    public static final int RB_DELETE = 3;
    private static final int VISIBLE_LIST_ITEMS = 4;
    private int m_rememberServiceIndex;
    private EwtContainer m_actionPan;
    private EwtContainer m_targetPan;
    private EditTextField m_serviceField;
    private LWList m_serviceList;
    private LWCheckboxGroup m_radioGroup;
    private LWCheckbox m_modifyChkBox;
    private LWCheckbox m_deleteChkBox;
    private LWCheckbox m_testChkBox;
    private LWCheckbox m_createChkBox;
    private MultiLineLabel m_mainmsg;
    private String m_domain;

    public ServiceWizardPanel(NetStrings netStrings, Vector addrlist, String defDomain) {
        super(netStrings);
        this.setImage("images/Begin.gif");
        this.m_domain = defDomain;
        TextWrapper Textwrap = UniWordWrapper.getTextWrapper();
        this.m_mainmsg = new MultiLineLabel(Textwrap, this.m_netStrings.getString("SNWSrvPanMsg"));
        this.m_mainmsg.setAlignment(1);
        LWLabel newLabel = new LWLabel(this.m_netStrings.getString("SNWSrvPanNewLabel"));
        LWLabel pickLabel = new LWLabel(this.m_netStrings.getString("SNWSrvPanPickLabel"));
        this.m_serviceField = new EditTextField(10);
        ((Component)((Object)this.m_serviceField)).addKeyListener(this);
        this.m_serviceList = new LWList(4, false);
        int count = 0;
        while (count < addrlist.size()) {
            this.m_serviceList.add((String)addrlist.elementAt(count));
            ++count;
        }
        if (this.m_serviceList.getItemCount() > 0) {
            this.m_serviceList.select(0);
        }
        this.m_radioGroup = new LWCheckboxGroup();
        this.m_modifyChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanModifyCB"), this.m_radioGroup, false);
        this.m_modifyChkBox.addItemListener((ItemListener)this);
        this.m_deleteChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanDeleteCB"), this.m_radioGroup, false);
        this.m_deleteChkBox.addItemListener((ItemListener)this);
        this.m_testChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanTestCB"), this.m_radioGroup, false);
        this.m_testChkBox.addItemListener((ItemListener)this);
        this.m_createChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanCreateCB"), this.m_radioGroup, true);
        this.m_createChkBox.addItemListener((ItemListener)this);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBag);
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_contentPanel.add((Component)this.m_mainmsg, constraints);
        EwtContainer m_targetPan = new EwtContainer();
        m_targetPan.setBorder((Border)new GroupBoxBorder(this.m_netStrings.getString("SNWSrvPanServiceTle"), InsetFramePainter.getFramePainter(), 2));
        GridBagLayout targetGBL = new GridBagLayout();
        GridBagConstraints targetGBC = new GridBagConstraints();
        m_targetPan.setLayout(targetGBL);
        targetGBC.gridwidth = 1;
        targetGBC.gridheight = 1;
        targetGBC.weighty = 1.0;
        targetGBC.weightx = 1.0;
        targetGBC.anchor = 17;
        targetGBC.fill = 0;
        targetGBC.insets.left = 5;
        targetGBC.insets.right = 5;
        targetGBC.insets.top = 5;
        targetGBC.insets.bottom = 0;
        targetGBC.gridx = 0;
        targetGBC.gridy = 0;
        m_targetPan.add((Component)newLabel, targetGBC);
        targetGBC.insets.top = 0;
        targetGBC.insets.bottom = 5;
        targetGBC.fill = 2;
        targetGBC.gridy = 1;
        m_targetPan.add((Component)((Object)this.m_serviceField), targetGBC);
        targetGBC.fill = 0;
        targetGBC.insets.top = 5;
        targetGBC.insets.bottom = 0;
        targetGBC.gridy = 2;
        m_targetPan.add((Component)pickLabel, targetGBC);
        targetGBC.fill = 1;
        targetGBC.insets.top = 0;
        targetGBC.insets.bottom = 5;
        targetGBC.gridy = 3;
        targetGBL.setConstraints((Component)this.m_serviceList, targetGBC);
        m_targetPan.add((Component)this.m_serviceList);
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets.left = 5;
        constraints.insets.right = 0;
        constraints.gridx = 1;
        constraints.gridy = 1;
        this.m_contentPanel.add((Component)m_targetPan, constraints);
        this.m_actionPan = new EwtContainer();
        this.m_actionPan.setBorder((Border)new GroupBoxBorder(this.m_netStrings.getString("SNWSrvPanActionTle"), InsetFramePainter.getFramePainter(), 2));
        GridBagLayout actionGBL = new GridBagLayout();
        GridBagConstraints actionGBC = new GridBagConstraints();
        this.m_actionPan.setLayout(actionGBL);
        EwtContainer chkPanel = new EwtContainer();
        chkPanel.setLayout(new GridLayout(4, 1, 0, 8));
        chkPanel.add((Component)this.m_createChkBox);
        chkPanel.add((Component)this.m_modifyChkBox);
        chkPanel.add((Component)this.m_deleteChkBox);
        chkPanel.add((Component)this.m_testChkBox);
        actionGBC.gridwidth = 1;
        actionGBC.weightx = 1.0;
        actionGBC.anchor = 18;
        actionGBC.fill = 0;
        actionGBC.insets.left = 20;
        actionGBC.insets.right = 20;
        actionGBC.insets.top = 0;
        actionGBC.insets.bottom = 0;
        actionGBC.gridx = 0;
        actionGBC.gridy = 0;
        actionGBL.setConstraints((Component)chkPanel, actionGBC);
        this.m_actionPan.add((Component)chkPanel);
        constraints.fill = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.insets.left = 0;
        constraints.insets.right = 5;
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.m_contentPanel.add((Component)this.m_actionPan, constraints);
        this.setCreate();
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        if (cmp.equals(this.m_serviceField)) {
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                return;
            }
            if (ch == '.') {
                return;
            }
            if (ch == '\b') {
                return;
            }
            evt.setKeyChar('\u0000');
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            LWCheckbox cur = this.m_radioGroup.getSelectedCheckbox();
            if (cur == this.m_modifyChkBox) {
                this.setAlter();
            }
            if (cur == this.m_deleteChkBox) {
                this.setAlter();
            }
            if (cur == this.m_testChkBox) {
                this.setAlter();
            }
            if (cur == this.m_createChkBox) {
                this.setCreate();
            }
        }
    }

    public void initFocus() {
        this.m_serviceField.requestFocus();
    }

    public boolean isServiceSelected() {
        return this.m_serviceList.getSelectedIndex() != -1;
    }

    public String getSelectedService() {
        if (this.isServiceSelected()) {
            return this.m_serviceList.getSelectedItem();
        }
        return null;
    }

    public void removeListElement(String name) {
        this.m_serviceList.remove(name);
    }

    public void removeListElement(int index) {
        this.m_serviceList.remove(index);
    }

    public String getNewName() {
        String sname = this.m_serviceField.getText();
        if (sname.equals("")) {
            return sname;
        }
        if (sname.endsWith("." + this.m_domain)) {
            return sname;
        }
        if (sname.endsWith(".")) {
            return sname.substring(0, sname.length() - 1);
        }
        if (!this.m_domain.equals("")) {
            return String.valueOf(sname) + "." + this.m_domain;
        }
        return sname;
    }

    public int getSelection() {
        LWCheckbox cur = this.m_radioGroup.getSelectedCheckbox();
        if (cur == this.m_modifyChkBox) {
            return 2;
        }
        if (cur == this.m_deleteChkBox) {
            return 3;
        }
        if (cur == this.m_testChkBox) {
            return 0;
        }
        if (cur == this.m_createChkBox) {
            return 1;
        }
        throw new IllegalArgumentException("ServiceWizardPanel: Unexpected error - LWChoice(" + cur + ").");
    }

    void setAlter() {
        this.m_serviceField.setEditable(false);
        if (this.m_serviceList.getItemCount() > 0) {
            try {
                this.m_serviceList.select(this.m_rememberServiceIndex);
            }
            catch (Exception exception) {}
        }
        this.m_serviceList.setEnabled(true);
    }

    void setCreate() {
        this.m_serviceField.setEditable(true);
        if (this.m_serviceList.getItemCount() > 0) {
            this.m_rememberServiceIndex = this.m_serviceList.getSelectedIndex();
            if (this.m_rememberServiceIndex == -1) {
                this.m_rememberServiceIndex = 0;
            }
            this.m_serviceList.deselect(this.m_rememberServiceIndex);
        }
        this.m_serviceList.setEnabled(false);
        this.m_serviceField.requestFocus();
    }
}

