/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.TCPAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class TCPWizardPanel
extends GenericWizardPanel
implements KeyListener {
    public static final String DEFAULT_PORT = new String("1521");
    private EditTextField m_hostField;
    private EditTextField m_portField;

    public TCPWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.setImage("images/ProtocolInfo.gif");
        this.m_contentPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        LWLabel header = new LWLabel(this.m_netStrings.getString("SNWTCPPanTitle"));
        TextWrapper textWrap = UniWordWrapper.getTextWrapper();
        MultiLineLabel host_label = new MultiLineLabel(textWrap, this.m_netStrings.getString("SNWTCPPanHostMsg"));
        host_label.setAlignment(1);
        MultiLineLabel port_label = new MultiLineLabel(textWrap, this.m_netStrings.getString("SNWTCPPanPortMsg"));
        port_label.setAlignment(1);
        LWLabel host_label2 = new LWLabel(this.m_netStrings.getString("SNWTCPPanHostLbl"));
        LWLabel port_label2 = new LWLabel(this.m_netStrings.getString("SNWTCPPanPortLbl"));
        this.m_hostField = new EditTextField("");
        this.m_portField = new EditTextField(DEFAULT_PORT);
        ((Component)((Object)this.m_hostField)).addKeyListener(this);
        ((Component)((Object)this.m_portField)).addKeyListener(this);
        this.m_contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.m_contentPanel.add((Component)header, gbc);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.m_contentPanel.add((Component)host_label, gbc);
        gbc.gridy = 3;
        port_label.setPreferredAspectRatio(4.5f);
        this.m_contentPanel.add((Component)port_label, gbc);
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets.bottom = 0;
        gbc.weightx = 0.25;
        gbc.gridwidth = 1;
        gbc.gridy = 2;
        this.m_contentPanel.add((Component)host_label2, gbc);
        gbc.gridy = 4;
        this.m_contentPanel.add((Component)port_label2, gbc);
        gbc.weightx = 0.5;
        gbc.weighty = 0.25;
        gbc.fill = 2;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.m_contentPanel.add((Component)((Object)this.m_hostField), gbc);
        gbc.gridy = 4;
        this.m_contentPanel.add((Component)((Object)this.m_portField), gbc);
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        if (cmp.equals(this.m_portField)) {
            if (ch == '\b') {
                return;
            }
            if (Character.isDigit(ch)) {
                return;
            }
            evt.setKeyChar('\u0000');
        }
        if (cmp.equals(this.m_hostField)) {
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                return;
            }
            if (ch == '.') {
                return;
            }
            if (ch == '\b') {
                return;
            }
            evt.setKeyChar('\u0000');
        }
    }

    public boolean isValid() {
        String host = this.m_hostField.getText();
        String port = this.m_portField.getText();
        if (host.equals("")) {
            return false;
        }
        try {
            int p = Integer.parseInt(port);
            if (p < 0 || p > 65536) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public void initFocus() {
        this.m_hostField.requestFocus();
    }

    public void setParams(Address theAddress) {
        if (theAddress != null) {
            this.m_hostField.setText(theAddress._getParameter("HOST"));
            this.m_portField.setText(theAddress._getParameter("PORT"));
        } else {
            this.m_hostField.setText("");
            this.m_portField.setText(DEFAULT_PORT);
        }
    }

    public Address getAddress() throws CreateAddressException {
        AddressFactory addrfactory = AddressFactory.getFactory();
        String addr = "(ADDRESS=(PROTOCOL=" + TCPAddress.TCP_PROTOCOL + ")" + "(HOST=" + this.m_hostField.getText() + ")" + "(PORT=" + this.m_portField.getText() + "))";
        return addrfactory.createAddress(addr);
    }
}

