/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.uniword;

import java.text.BreakIterator;

public class UniLineBreak {
    private BreakIterator m_lineBreak;
    private char[] m_line;
    private int m_curLineEnd;
    private int m_curLineIndex;

    public UniLineBreak(String text) {
        this.setText(text);
    }

    public void setText(String text) {
        if (this.m_lineBreak == null) {
            this.m_lineBreak = BreakIterator.getLineInstance();
        }
        this.m_lineBreak.setText(text);
        this.m_line = text.toCharArray();
        this.first();
    }

    public int first() {
        this.m_curLineEnd = this.m_curLineIndex = this.m_lineBreak.first();
        return this.m_curLineIndex;
    }

    public int following(int offset) {
        this.m_curLineEnd = this.m_curLineIndex = this.m_lineBreak.following(offset);
        return this.m_curLineIndex;
    }

    public int next() {
        char c;
        int nextBreak = this.possibleNext();
        if (nextBreak != -1 && nextBreak < this.m_line.length && ((c = this.m_line[nextBreak]) > '\u3000' && c < '\u3020' && (c < '\u3004' || c > '\u3008' && c < '\u301c' && c % 2 != 0 || c == '\u301e' || c == '\u301f') || c > '\uff08' && c < '\uffa0' && (c == '\uff09' || c > '\uff0b' && c < '\uff0f' || c == '\uff3d' || c == '\uff5d' || c == '\uff61' || c == '\uff63' || c == '\uff64' || c == '\uff9e' || c == '\uff9f'))) {
            this.m_curLineIndex = ++nextBreak;
            this.m_curLineEnd = this.m_curLineIndex == this.m_line.length ? -1 : this.m_lineBreak.following(nextBreak);
        }
        return nextBreak;
    }

    private int possibleNext() {
        if (this.m_curLineEnd == -1) {
            return this.m_curLineEnd;
        }
        if (this.m_curLineIndex >= this.m_curLineEnd) {
            int segStart = this.m_lineBreak.current();
            int nextBreak = this.m_lineBreak.next();
            if (nextBreak != -1 && nextBreak - segStart > 1) {
                this.m_curLineIndex = segStart;
                this.m_curLineEnd = nextBreak;
            } else {
                return nextBreak;
            }
        }
        return this.segNext();
    }

    private int segNext() {
        int prevIndex = this.m_curLineIndex;
        while (this.m_curLineIndex < this.m_curLineEnd) {
            char c;
            if (((c = this.m_line[this.m_curLineIndex++]) <= '\u300f' || c >= '\u3100') && (c <= '\uff64' || c >= '\uff9e')) continue;
            if (this.m_curLineIndex - prevIndex <= 2) break;
            --this.m_curLineIndex;
            break;
        }
        return this.m_curLineIndex;
    }
}

