/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.uniword;

import java.awt.FontMetrics;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WrapInfo;
import oracle.net.asst.uniword.UniLineBreak;

public class UniWordWrapper
implements TextWrapper {
    private static UniWordWrapper _sWordWrapper;

    public static TextWrapper getTextWrapper() {
        if (_sWordWrapper == null) {
            _sWordWrapper = new UniWordWrapper();
        }
        return _sWordWrapper;
    }

    public void wrapParagraph(WrapInfo wrapInfo, String text) {
        int nextBreak;
        char[] textChars = text.toCharArray();
        int wrapWidth = wrapInfo.getWrapWidth();
        FontMetrics metrics = wrapInfo.getFontMetrics();
        UniLineBreak lineBreak = new UniLineBreak(text);
        int lineEnd = nextBreak = lineBreak.first();
        while (nextBreak != -1) {
            int currLineWidth = 0;
            int oldLineWidth = 0;
            int lineStart = lineEnd;
            lineEnd = nextBreak;
            if (Character.isWhitespace(textChars[lineStart])) {
                nextBreak = lineBreak.following(lineStart);
                if (nextBreak == -1) break;
                lineStart = lineEnd;
                lineEnd = nextBreak;
            }
            while (nextBreak != -1) {
                int nonspaceEnd = text.indexOf(32, lineEnd);
                if (nonspaceEnd < lineEnd || nonspaceEnd >= nextBreak) {
                    nonspaceEnd = nextBreak;
                }
                if ((currLineWidth = metrics.charsWidth(textChars, lineStart, nonspaceEnd - lineStart)) > wrapWidth && oldLineWidth != 0) break;
                lineEnd = nextBreak;
                nextBreak = lineBreak.next();
                oldLineWidth = currLineWidth;
            }
            if (nextBreak == -1) {
                currLineWidth = Integer.MAX_VALUE;
            }
            String line = new String(textChars, lineStart, lineEnd - lineStart);
            wrapInfo.addLine(line, 0, line.length());
        }
    }

    protected UniWordWrapper() {
    }
}

