/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.help;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import oracle.help.Book;
import oracle.help.Help;
import oracle.help.TopicNotFoundException;
import oracle.net.common.help.HelpSystem;

public class KomodoHelp
implements HelpSystem {
    private Help help;
    private Book book;
    private boolean helpInitialized = false;
    private Frame callerFrame;
    private String title = "Help";
    private Point TOPIC_LOC = new Point(0, 0);
    private Dimension TOPIC_DIM = new Dimension(500, 500);

    public KomodoHelp(Frame owner, String dir, String bookName, Class placeHolder, String windowTitle) throws InstantiationException {
        this.callerFrame = owner;
        this.title = windowTitle;
        try {
            this.help = new Help(Class.forName("oracle.help.htmlBrowser.ICEBrowser"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InstantiationException("Failed to initialize Help browser.");
        }
        this.book = placeHolder != null ? Help.createBook((Class)placeHolder, (String)dir, (String)bookName, (String)windowTitle) : Help.createBook((String)dir, (String)bookName, (String)windowTitle);
        if (this.book == null) {
            throw new InstantiationException("Failed to initialize help system.");
        }
        this.help.addBook(this.book);
        this.helpInitialized = true;
    }

    public KomodoHelp(Frame owner, String directory, String bookName, Class placeHolder, String windowTitle, Dimension dim, Point loc) throws InstantiationException {
        this(owner, directory, bookName, placeHolder, windowTitle);
        this.TOPIC_LOC = loc;
        this.TOPIC_DIM = dim;
    }

    public void showTopic(String section) {
        if (this.helpInitialized) {
            ((Component)this.callerFrame).setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.help.showTopic(this.book, section, false, this.TOPIC_LOC, this.TOPIC_DIM);
            }
            catch (TopicNotFoundException e) {
                System.err.println(e.getMessage());
            }
            ((Component)this.callerFrame).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void showContents() {
        if (this.helpInitialized) {
            this.help.showContents();
        }
    }

    public void showIndex() {
        if (this.helpInitialized) {
            this.help.showIndex();
        }
    }

    public void showSearch() {
        if (this.helpInitialized) {
            this.help.showSearch();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSize(Dimension size) {
        this.TOPIC_DIM = size;
    }

    public Dimension getSize() {
        return this.TOPIC_DIM;
    }

    public void setLocation(Point loc) {
        this.TOPIC_LOC = loc;
    }

    public Point getLocation() {
        return this.TOPIC_LOC;
    }
}

