/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

public class NLException
extends Throwable {
    private static final int MAXMESSAGES = 200;
    private String[] msgs = new String[200];
    private short errno;
    public static final short NL0000 = 0;
    public static final short NL0001 = 1;
    public static final short NL0002 = 2;
    public static final short NL0003 = 3;
    public static final short NL0004 = 4;
    public static final short NL0100 = 100;
    public static final short NL0101 = 101;
    public static final short NL0102 = 102;
    public static final short NL0103 = 103;
    public static final short NL0104 = 104;
    public static final short NL0200 = 199;

    public NLException() {
    }

    public NLException(String s) {
        super(s);
    }

    public NLException(short errno) {
        this.initMessages();
        this.errno = errno;
    }

    public short getNLErrno() {
        return this.errno;
    }

    public String getNLErrorMsg() {
        int msgNumber = this.errno;
        String errClass = "";
        if (this.errno > this.msgs.length - 2) {
            msgNumber = this.msgs.length - 1;
        }
        if (msgNumber < 100) {
            errClass = new String("NL:Internal");
        } else if (msgNumber < 199) {
            errClass = new String("NLNV");
        }
        return "Error: " + this.errno + " -- " + errClass + "-" + this.msgs[msgNumber];
    }

    public void printNLErrorMsg() {
        System.out.println("Messages " + this.msgs.length);
        int i = 0;
        while (i < this.msgs.length) {
            System.out.println("Message " + i + ": " + this.msgs[i]);
            ++i;
        }
    }

    private void initMessages() {
        this.msgs[0] = new String("");
        this.msgs[1] = new String("Invalid continuation character after Comment");
        this.msgs[2] = new String("");
        this.msgs[3] = new String("");
        this.msgs[4] = new String("");
        this.msgs[100] = new String("NLNV String Format Error");
        this.msgs[101] = new String("Null RHS for Atom");
        this.msgs[102] = new String("");
        this.msgs[103] = new String("");
        this.msgs[104] = new String("");
    }
}

