/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class NLParamParser {
    private String filename;
    private Hashtable ht;
    private Vector linebuffer;
    private int Commentcnt;
    private int nvStringcnt;
    private int Groupcnt;
    private boolean hasComments;
    private boolean hasGroups;
    private String[] errstr;
    private int errstrcnt;
    public static final byte IGNORE_NL_EXCEPTION = 1;
    public static final byte IGNORE_FILE_EXCEPTION = 2;
    public static final byte NLPASUCC = 1;
    public static final byte NLPAOVWR = 2;
    public static final byte NLPAFAIL = -1;
    private static boolean DEBUG;

    public NLParamParser(String filename) throws IOException, NLException {
        this.hasComments = false;
        this.hasGroups = false;
        this.filename = filename;
        this.ht = new Hashtable(128);
        this.linebuffer = new Vector(100, 50);
        FileInputStream fis = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        try {
            String newline;
            fis = new FileInputStream(filename);
            is = new InputStreamReader(fis);
            br = new BufferedReader(is);
            while ((newline = br.readLine()) != null) {
                this.linebuffer.addElement(newline);
            }
            fis.close();
            is.close();
            br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fis != null) {
                fis.close();
            }
            if (is != null) {
                is.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException e) {
            if (fis != null) {
                fis.close();
            }
            if (is != null) {
                is.close();
            }
            if (br != null) {
                br.close();
            }
            throw e;
        }
        String nvElem = "";
        String linesep = System.getProperty("line.separator");
        String commentKey = "";
        String commentValue = "";
        int i = 0;
        while (i < this.linebuffer.size()) {
            String line = (String)this.linebuffer.elementAt(i);
            if (line.length() != 0) {
                if (line.charAt(0) == '#') {
                    if (line.indexOf(".ORA Configuration ") != -1 || line.indexOf("Generated by Oracle") != -1) {
                        if (DEBUG) {
                            System.out.println(String.valueOf(line) + ": this comment ignored");
                        }
                    } else if (commentKey.length() != 0) {
                        commentValue = String.valueOf(commentValue) + line + linesep;
                    } else {
                        commentKey = "COMMENT#" + this.Commentcnt;
                        commentValue = String.valueOf(line) + linesep;
                        if (!this.hasComments) {
                            this.hasComments = true;
                        }
                    }
                } else if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                    if (commentValue.length() == 0) {
                        if (nvElem.length() == 0) {
                            line = this.EatNLPWS(line);
                        }
                        if ((line = this.checkNLPforComments(line)).length() != 0) {
                            nvElem = String.valueOf(nvElem) + line + linesep;
                        }
                    } else if (nvElem.length() == 0 && commentValue.length() != 0) {
                        line = this.EatNLPWS(line);
                        if ((line = this.checkNLPforComments(line)).length() != 0) {
                            throw new NLException(1);
                        }
                    } else if (nvElem.length() != 0 && commentValue.length() != 0) {
                        commentKey = "";
                        commentValue = "";
                        line = this.checkNLPforComments(line);
                        nvElem = String.valueOf(nvElem) + line + linesep;
                    }
                } else if (nvElem.length() == 0 && commentValue.length() == 0) {
                    line = this.checkNLPforComments(line);
                    nvElem = String.valueOf(nvElem) + line + linesep;
                } else if (nvElem.length() == 0 && commentValue.length() != 0) {
                    commentValue = this.modifyCommentString(commentValue);
                    this.addNLPListElement(String.valueOf(commentKey) + "=" + commentValue);
                    commentKey = "";
                    commentValue = "";
                    ++this.Commentcnt;
                    line = this.checkNLPforComments(line);
                    nvElem = String.valueOf(nvElem) + line + linesep;
                } else if (nvElem.length() != 0 && commentValue.length() == 0) {
                    this.addNLPListElement(nvElem);
                    nvElem = "";
                    line = this.checkNLPforComments(line);
                    nvElem = String.valueOf(nvElem) + line + linesep;
                } else if (nvElem.length() != 0 && commentValue.length() != 0) {
                    this.addNLPListElement(nvElem);
                    nvElem = "";
                    line = this.checkNLPforComments(line);
                    nvElem = String.valueOf(nvElem) + line + linesep;
                    commentValue = this.modifyCommentString(commentValue);
                    this.addNLPListElement(String.valueOf(commentKey) + "=" + commentValue);
                    commentKey = "";
                    commentValue = "";
                    ++this.Commentcnt;
                }
            }
            ++i;
        }
        if (nvElem.length() != 0) {
            this.addNLPListElement(nvElem);
            nvElem = "";
        }
        if (commentValue.length() != 0) {
            commentValue = this.modifyCommentString(commentValue);
            this.addNLPListElement(String.valueOf(commentKey) + "=" + commentValue);
            commentKey = "";
            commentValue = "";
            ++this.Commentcnt;
        }
    }

    public NLParamParser(String filename, byte ignore_exception) throws NLException, IOException {
        block50: {
            this.hasComments = false;
            this.hasGroups = false;
            this.filename = filename;
            this.ht = new Hashtable(128);
            this.linebuffer = new Vector(100, 50);
            this.errstr = new String[50];
            FileInputStream fis = null;
            InputStreamReader is = null;
            BufferedReader br = null;
            try {
                String newline;
                fis = new FileInputStream(filename);
                is = new InputStreamReader(fis);
                br = new BufferedReader(is);
                while ((newline = br.readLine()) != null) {
                    this.linebuffer.addElement(newline);
                }
                fis.close();
                is.close();
                br.close();
            }
            catch (FileNotFoundException e) {
                if (fis != null) {
                    fis.close();
                }
                if (is != null) {
                    is.close();
                }
                if (br != null) {
                    br.close();
                }
                if ((ignore_exception & 2) == 0) {
                    throw e;
                }
            }
            catch (IOException iOException) {
                if (fis != null) {
                    fis.close();
                }
                if (is != null) {
                    is.close();
                }
                if (br == null) break block50;
                br.close();
            }
        }
        String nvElem = "";
        String linesep = System.getProperty("line.separator");
        String commentKey = "";
        String commentValue = "";
        int i = 0;
        while (i < this.linebuffer.size()) {
            String line = (String)this.linebuffer.elementAt(i);
            if (line.length() != 0) {
                if (line.charAt(0) == '#') {
                    if (line.indexOf(".ORA Configuration File:") != -1 || line.indexOf("Generated by Oracle") != -1) {
                        if (DEBUG) {
                            System.out.println(String.valueOf(line) + ": this comment ignored");
                        }
                    } else if (commentKey.length() != 0) {
                        commentValue = String.valueOf(commentValue) + line + linesep;
                    } else {
                        commentKey = "COMMENT#" + this.Commentcnt;
                        commentValue = String.valueOf(line) + linesep;
                    }
                } else if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                    if (commentValue.length() == 0) {
                        if (nvElem.length() == 0) {
                            line = this.EatNLPWS(line);
                        }
                        if ((line = this.checkNLPforComments(line)).length() != 0) {
                            nvElem = String.valueOf(nvElem) + line + linesep;
                        }
                    } else if (nvElem.length() == 0 && commentValue.length() != 0) {
                        line = this.EatNLPWS(line);
                        if ((line = this.checkNLPforComments(line)).length() != 0 && (ignore_exception & 1) == 0) {
                            throw new NLException(1);
                        }
                    } else if (nvElem.length() != 0 && commentValue.length() != 0) {
                        commentKey = "";
                        commentValue = "";
                        line = this.checkNLPforComments(line);
                        nvElem = String.valueOf(nvElem) + line + linesep;
                    }
                } else if (nvElem.length() == 0 && commentValue.length() == 0) {
                    line = this.checkNLPforComments(line);
                    nvElem = String.valueOf(nvElem) + line + linesep;
                } else if (nvElem.length() == 0 && commentValue.length() != 0) {
                    block51: {
                        commentValue = this.modifyCommentString(commentValue);
                        try {
                            this.addNLPListElement(String.valueOf(commentKey) + "=" + commentValue);
                        }
                        catch (NLException e) {
                            this.errstr[this.errstrcnt++] = nvElem;
                            if ((ignore_exception & 1) != 0) break block51;
                            throw e;
                        }
                    }
                    commentKey = "";
                    commentValue = "";
                    ++this.Commentcnt;
                    line = this.checkNLPforComments(line);
                    nvElem = String.valueOf(nvElem) + line + linesep;
                } else if (nvElem.length() != 0 && commentValue.length() == 0) {
                    block52: {
                        try {
                            this.addNLPListElement(nvElem);
                        }
                        catch (NLException e) {
                            this.errstr[this.errstrcnt++] = nvElem;
                            if ((ignore_exception & 1) != 0) break block52;
                            throw e;
                        }
                    }
                    nvElem = "";
                    line = this.checkNLPforComments(line);
                    nvElem = String.valueOf(nvElem) + line + linesep;
                } else if (nvElem.length() != 0 && commentValue.length() != 0) {
                    block54: {
                        block53: {
                            try {
                                this.addNLPListElement(nvElem);
                            }
                            catch (NLException e) {
                                this.errstr[this.errstrcnt++] = nvElem;
                                if ((ignore_exception & 1) != 0) break block53;
                                throw e;
                            }
                        }
                        nvElem = "";
                        line = this.checkNLPforComments(line);
                        nvElem = String.valueOf(nvElem) + line + linesep;
                        commentValue = this.modifyCommentString(commentValue);
                        try {
                            this.addNLPListElement(String.valueOf(commentKey) + "=" + commentValue);
                        }
                        catch (NLException e) {
                            this.errstr[this.errstrcnt++] = nvElem;
                            if ((ignore_exception & 1) != 0) break block54;
                            throw e;
                        }
                    }
                    commentKey = "";
                    commentValue = "";
                    ++this.Commentcnt;
                }
            }
            ++i;
        }
        if (nvElem.length() != 0) {
            block55: {
                try {
                    this.addNLPListElement(nvElem);
                }
                catch (NLException e) {
                    this.errstr[this.errstrcnt++] = nvElem;
                    if ((ignore_exception & 1) != 0) break block55;
                    throw e;
                }
            }
            nvElem = "";
        }
        if (commentValue.length() != 0) {
            block56: {
                commentValue = this.modifyCommentString(commentValue);
                try {
                    this.addNLPListElement(String.valueOf(commentKey) + "=" + commentValue);
                }
                catch (NLException e) {
                    this.errstr[this.errstrcnt++] = nvElem;
                    if ((ignore_exception & 1) != 0) break block56;
                    throw e;
                }
            }
            commentKey = "";
            commentValue = "";
            ++this.Commentcnt;
        }
    }

    private String modifyCommentString(String str) {
        String str1 = "";
        boolean offset = false;
        int i = 0;
        while (i < str.length()) {
            char current_char = str.charAt(i);
            switch (current_char) {
                case '(': {
                    str1 = String.valueOf(str1) + "\\(";
                    break;
                }
                case '=': {
                    str1 = String.valueOf(str1) + "\\=";
                    break;
                }
                case ')': {
                    str1 = String.valueOf(str1) + "\\)";
                    break;
                }
                case ',': {
                    str1 = String.valueOf(str1) + "\\,";
                    break;
                }
                default: {
                    str1 = String.valueOf(str1) + str.charAt(i);
                }
            }
            ++i;
        }
        return str1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkNLPforComments(String str) {
        StringBuffer str1 = new StringBuffer(str.length());
        boolean offset = false;
        int i = 0;
        while (i < str.length()) {
            char current_char = str.charAt(i);
            if (current_char == '#') {
                if (i == 0) return "";
                if (str.charAt(i - 1) != '\\') return str1.toString();
                str1.append(current_char);
            } else {
                str1.append(current_char);
            }
            ++i;
        }
        return str1.toString();
    }

    private String EatNLPWS(String str) {
        StringBuffer str1 = new StringBuffer(str.length());
        int offset = 0;
        boolean NWScharfound = false;
        while (!NWScharfound) {
            char current_char;
            if ((current_char = str.charAt(offset++)) != ' ' || current_char != '\t') {
                NWScharfound = true;
                int i = offset - 1;
                while (str.charAt(i) == '\n') {
                    str1.append(str.charAt(i));
                    ++i;
                }
                continue;
            }
            if (current_char != '\n') continue;
            return "";
        }
        return str1.toString();
    }

    public void saveNLParams() throws IOException {
        FileOutputStream fout = null;
        PrintWriter pout = null;
        String orafile = "";
        try {
            fout = new FileOutputStream(this.filename);
            pout = new PrintWriter(fout);
            StringTokenizer st = new StringTokenizer(this.filename, "/");
            while (st.hasMoreTokens()) {
                orafile = st.nextToken();
            }
            pout.println("# " + orafile.toUpperCase() + " Configuration File:" + this.filename);
            pout.println("# Generated by Oracle Net8 Assistant");
            pout.println("");
            if (this.hasGroups) {
                this.saveNLPGroups(pout);
            }
            Enumeration e = this.ht.elements();
            while (e.hasMoreElements()) {
                NVPair nvp = (NVPair)e.nextElement();
                String Value = nvp.toString(0, true);
                if (DEBUG) {
                    System.out.println("The initial stringified NVPair is:\n" + Value);
                }
                char[] chkstr = new char[Value.length() - 2];
                Value.getChars(1, Value.length() - 1, chkstr, 0);
                String newValue = new String(chkstr);
                if (DEBUG) {
                    System.out.println("The modified NV String is:\n" + newValue);
                }
                pout.println(newValue);
                pout.println("");
                chkstr = null;
            }
            pout.close();
            fout.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (pout != null) {
                pout.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
        catch (IOException e) {
            if (pout != null) {
                pout.close();
            }
            if (fout != null) {
                fout.close();
            }
            throw e;
        }
    }

    public void saveNLParams(String filename) throws FileNotFoundException, IOException {
        this.filename = filename;
        this.saveNLParams();
    }

    public String getFilename() {
        return this.filename;
    }

    public int getNLPListSize() {
        this.nvStringcnt = 0;
        Enumeration e = this.ht.keys();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (paramName.indexOf("COMMENT") != -1) continue;
            ++this.nvStringcnt;
        }
        return this.nvStringcnt;
    }

    public boolean inErrorList(String Name) {
        boolean exists = false;
        if (DEBUG) {
            System.out.println("Entering inErrorList():");
        }
        int i = 0;
        while (!exists || i < this.errstrcnt) {
            if (this.errstrcnt == 0) break;
            if (this.errstr[i].indexOf(Name) != -1) {
                exists = true;
            }
            ++i;
        }
        return exists;
    }

    public NVPair getNLPListElement(String Name) {
        String UName = Name.toUpperCase();
        return (NVPair)this.ht.get(UName);
    }

    public String[] getNLPAllNames() {
        int size = this.getNLPListSize();
        String[] Names = new String[size];
        int count = 0;
        Enumeration e = this.ht.keys();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (paramName.indexOf("COMMENT") != -1) continue;
            Names[count++] = paramName;
        }
        return Names;
    }

    public String[] getNLPAllElements() {
        int size = this.getNLPListSize();
        String[] nvstrings = new String[size];
        int count = 0;
        Enumeration e = this.ht.elements();
        while (e.hasMoreElements()) {
            NVPair nvp = (NVPair)e.nextElement();
            if (nvp.getName().indexOf("COMMENT") != -1) continue;
            String nvelem = nvp.toString();
            nvstrings[count++] = nvelem;
        }
        return nvstrings;
    }

    public byte addNLPListElement(String Name, Object Value) {
        try {
            Object retobj = this.ht.put(Name, Value);
            return retobj != null ? (byte)2 : 1;
        }
        catch (NullPointerException e) {
            if (DEBUG) {
                System.out.println(((Throwable)e).getMessage());
            }
            return -1;
        }
    }

    public void addNLPGroupProfile(String[] Names) {
        String GroupName = new String("GROUP#" + this.Groupcnt++);
        String[] GroupValue = Names;
        if (!this.hasGroups) {
            this.hasGroups = true;
        }
        this.addNLPListElement(GroupName, GroupValue);
    }

    private String[] getNLPGroupProfile(String Name) {
        String UName = Name.toUpperCase();
        return (String[])this.ht.get(UName);
    }

    private void saveNLPGroups(PrintWriter pout) {
        int i = 0;
        while (i < this.Groupcnt) {
            String GroupName = new String("GROUP#" + i);
            String[] Value = this.getNLPGroupProfile(GroupName);
            int j = 0;
            while (j < Value.length) {
                String paramValue = null;
                String newValue = null;
                NVPair nvp = null;
                if (DEBUG) {
                    System.out.println("Current Value in Group Profile: " + Value[j]);
                }
                if (Value[j] != null) {
                    nvp = this.getNLPListElement(Value[j]);
                    if (nvp != null) {
                        paramValue = nvp.toString(0, true);
                        if (DEBUG) {
                            System.out.println("Parameter Value = " + paramValue);
                        }
                        char[] chkstr = new char[paramValue.length() - 2];
                        paramValue.getChars(1, paramValue.length() - 1, chkstr, 0);
                        newValue = new String(chkstr);
                        pout.println(newValue);
                        pout.println("");
                        NVPair nvp_gone = this.removeNLPListElement(Value[j]);
                        if (nvp_gone == null && DEBUG) {
                            System.out.println("saveNLPGroups(): Could notremove param from Hashtable");
                        }
                        chkstr = null;
                        newValue = null;
                    } else if (DEBUG) {
                        System.out.println("No such Parameter in the Table");
                    }
                }
                ++j;
            }
            this.removeNLPGroupProfile(GroupName);
            ++i;
        }
    }

    public void addNLPListElement(String nvString) throws NLException {
        char[] chkstr = new char[nvString.length() + 2];
        String newstr = "";
        if (DEBUG) {
            System.out.println("Entering Method addNLPListElement\n");
            System.out.println("String to add is: " + nvString);
        }
        nvString.getChars(0, nvString.length(), chkstr, 1);
        if (chkstr[1] == '(') {
            newstr = nvString;
        } else {
            chkstr[0] = 40;
            String os = System.getProperty("os.name");
            if (os.equals("Windows NT") || os.equals("Windows 95")) {
                if (chkstr[chkstr.length - 2] == '/' || chkstr[chkstr.length - 2] == '\\') {
                    chkstr[chkstr.length - 2] = 41;
                } else {
                    chkstr[chkstr.length - 1] = 41;
                }
            } else if (chkstr[chkstr.length - 2] == '\\') {
                chkstr[chkstr.length - 2] = 41;
            } else {
                chkstr[chkstr.length - 1] = 41;
            }
            newstr = new String(chkstr);
            if (DEBUG) {
                System.out.println("The modified NV String is: " + newstr);
            }
        }
        NVFactory nvf = new NVFactory();
        NVPair nvp = nvf.createNVPair(newstr);
        if (nvp == null && DEBUG) {
            throw new NLException(100);
        }
        if (nvp.getRHSType() == NVPair.RHS_NONE) {
            throw new NLException(101);
        }
        String Name = nvp.getName();
        String UName = Name.toUpperCase();
        nvp.setName(UName);
        if (DEBUG) {
            System.out.println("The final NV String is: " + nvp.toString());
        }
        byte retcode = this.addNLPListElement(UName, nvp);
        switch (retcode) {
            case 2: {
                if (!DEBUG) break;
                System.out.println("The value for the Name: " + Name + " was overwritten\n");
                break;
            }
            case -1: {
                if (!DEBUG) break;
                System.out.println("The value for the Name: " + Name + " could not be inserted\n");
            }
        }
    }

    public NVPair removeNLPListElement(String Name) {
        Object retobj;
        String UName = Name.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + UName + " from Table");
        }
        return (retobj = this.ht.remove(UName)) != null ? (NVPair)retobj : null;
    }

    public void removeNLPGroupProfile(String Name) {
        String UName = Name.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + UName + " GroupName from Table");
        }
        Object retobj = this.ht.remove(UName);
    }

    public void removeNLPAllElements() {
        this.ht.clear();
    }

    public String toString() {
        String out = "";
        Enumeration e = this.ht.elements();
        while (e.hasMoreElements()) {
            NVPair nvp = (NVPair)e.nextElement();
            String Value = nvp.toString();
            out = String.valueOf(out) + Value + "\n";
        }
        return out;
    }

    public boolean fileHasComments() {
        return this.hasComments;
    }

    public void println() {
        System.out.println(this.toString());
    }
}

