/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import oracle.net.nl.NVPair;
import oracle.net.nl.NVTokens;

public class NVFactory {
    public NVPair createNVPair(String nvString) {
        NVTokens nvt = new NVTokens();
        if (!nvt.parseTokens(nvString)) {
            System.out.println("NVFactory: Error in NVTokens");
            return null;
        }
        return this._readNVPair(nvt);
    }

    private NVPair _readNVPair(NVTokens nvt) {
        int tk = nvt.getToken();
        nvt.eatToken();
        if (tk != 1 && tk != 3) {
            System.out.println("NVFactory: _readNVPair expected ( or , ");
            return null;
        }
        String name = this._readNVLiteral(nvt);
        NVPair nvp = new NVPair(name);
        tk = nvt.getToken();
        switch (tk) {
            case 4: {
                nvt.eatToken();
                if (nvt.getToken() == 8) {
                    String value = this._readNVLiteral(nvt);
                    nvp.setAtom(value);
                    break;
                }
                int count = this._readNVList(nvt, nvp);
                break;
            }
            case 2: 
            case 3: {
                nvp.setAtom(name);
                break;
            }
            default: {
                System.out.println("NVFactory: _readNVPair expected =");
                return null;
            }
        }
        tk = nvt.getToken();
        if (tk == 2) {
            nvt.eatToken();
        } else if (tk != 3) {
            System.out.println("NVFactory: _readNVPair expected )");
            return null;
        }
        return nvp;
    }

    private String _readNVLiteral(NVTokens nvt) {
        int tk = nvt.getToken();
        if (tk != 8) {
            System.out.println("NVFactory: _readNVLiteral expected LITERAL");
            return null;
        }
        return nvt.popLiteral();
    }

    private int _readNVList(NVTokens nvt, NVPair parent) {
        int tk = nvt.getToken();
        if (tk != 1 && tk != 3) {
            return 0;
        }
        NVPair child = this._readNVPair(nvt);
        if (child == null) {
            return 0;
        }
        parent.addListElement(child);
        if ((tk == 3 || child.getName() == child.getAtom()) && parent.getListType() != NVPair.LIST_COMMASEP) {
            parent.setListType(NVPair.LIST_COMMASEP);
        }
        return 1 + this._readNVList(nvt, parent);
    }
}

