/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.io.PrintWriter;
import java.util.Vector;

public final class NVPair {
    public static int RHS_NONE;
    public static int RHS_ATOM;
    public static int RHS_LIST;
    public static int LIST_REGULAR;
    public static int LIST_COMMASEP;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    private String _linesep = System.getProperty("line.separator");

    public NVPair(String name) {
        this._name = name;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String name, String atom) {
        this(name);
        this.setAtom(atom);
    }

    public NVPair(String name, NVPair child) {
        this(name);
        this.addListElement(child);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public NVPair getParent() {
        return this._parent;
    }

    private void _setParent(NVPair parent) {
        this._parent = parent;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public int getListType() {
        return this._listType;
    }

    public void setListType(int type) {
        this._listType = type;
    }

    public String getAtom() {
        return this._atom;
    }

    public void setAtom(String atom) {
        this._rhsType = RHS_ATOM;
        this._atom = atom;
        this._list = null;
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public NVPair getListElement(int pos) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(pos);
    }

    public void addListElement(NVPair pair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(pair);
        pair._setParent(this);
    }

    public void removeListElement(int pos) {
        if (this._list != null) {
            this._list.removeElementAt(pos);
            if (this.getListSize() == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    private String space(int count) {
        String blank_str = new String("");
        int i = 0;
        while (i < count) {
            blank_str = String.valueOf(blank_str) + " ";
            ++i;
        }
        return blank_str;
    }

    public String toString() {
        String out = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            out = String.valueOf(out) + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                int i = 0;
                while (i < this.getListSize()) {
                    out = String.valueOf(out) + this.getListElement(i).toString();
                    ++i;
                }
            } else if (this._listType == LIST_COMMASEP) {
                out = String.valueOf(out) + " (";
                int i = 0;
                while (i < this.getListSize()) {
                    NVPair listElem = this.getListElement(i);
                    out = String.valueOf(out) + listElem.getName();
                    if (i != this.getListSize() - 1) {
                        out = String.valueOf(out) + ", ";
                    }
                    ++i;
                }
                out = String.valueOf(out) + ")";
            }
        }
        out = String.valueOf(out) + ")";
        return out;
    }

    public String toString(int level, boolean enable) {
        String out = "";
        String temp = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                out = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? String.valueOf(out) + this.space(level * 2) + "(" + this._name + " = " : String.valueOf(out) + this.space(level * 2) + "(" + this._name + " =" + this._linesep;
                int i = 0;
                while (i < this.getListSize()) {
                    out = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? String.valueOf(out) + this.getListElement(i).toString(level + 1, false) : String.valueOf(out) + this.getListElement(i).toString(level + 1, true);
                    ++i;
                }
                out = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? String.valueOf(out) + ")" + this._linesep : (level == 0 ? String.valueOf(out) + ")" : (level == 1 ? String.valueOf(out) + this.space(level * 2) + ")" : String.valueOf(out) + this.space(level * 2) + ")" + this._linesep));
            } else if (this._listType == LIST_COMMASEP) {
                out = String.valueOf(out) + "(" + this._name + "=" + " (";
                int i = 0;
                while (i < this.getListSize()) {
                    NVPair listElem = this.getListElement(i);
                    out = String.valueOf(out) + listElem.getName();
                    if (i != this.getListSize() - 1) {
                        out = String.valueOf(out) + ", ";
                    }
                    ++i;
                }
                out = String.valueOf(out) + ")" + ")";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (level == 0) {
                if (temp.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    out = String.valueOf(out) + "(" + this._atom + ")";
                } else {
                    out = String.valueOf(out) + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (temp.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                out = String.valueOf(out) + this._atom + this._linesep;
            } else if (!enable) {
                out = String.valueOf(out) + "(" + this._name + " = " + this._atom + ")";
            } else {
                out = String.valueOf(out) + this.space(level * 2) + "(" + this._name + " = " + this._atom + ")";
                out = String.valueOf(out) + this._linesep;
            }
        }
        return out;
    }

    public String modifyCommentString(String str) {
        String str1 = "";
        int offset = 0;
        block3: while (offset < str.length()) {
            char current_char = str.charAt(offset);
            switch (current_char) {
                case '\\': {
                    if (str.charAt(offset + 1) != '(' && str.charAt(offset + 1) != '=' && str.charAt(offset + 1) != ')' && str.charAt(offset + 1) != ',') continue block3;
                    int n = ++offset;
                    ++offset;
                    str1 = String.valueOf(str1) + str.charAt(n);
                    break;
                }
                default: {
                    str1 = String.valueOf(str1) + str.charAt(offset++);
                }
            }
        }
        return str1;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintWriter pout) {
        if (this._rhsType == RHS_ATOM) {
            pout.println("          (" + this._name + " = " + this._atom + ")");
        } else if (this._rhsType == RHS_LIST) {
            int i = 0;
            while (i < this.getListSize()) {
                this.getListElement(i).println(pout);
                ++i;
            }
        }
    }

    static {
        RHS_ATOM = 1;
        RHS_LIST = 2;
        LIST_REGULAR = 3;
        LIST_COMMASEP = 4;
    }
}

