/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.util.Vector;

public final class NVTokens {
    public static final int TKN_ERROR = -1;
    public static final int TKN_NONE = 0;
    public static final int TKN_LPAREN = 1;
    public static final int TKN_RPAREN = 2;
    public static final int TKN_COMMA = 3;
    public static final int TKN_EQUAL = 4;
    public static final int TKN_LITERAL = 8;
    public static final int TKN_EOS = 9;
    private static final char TKN_LPAREN_VALUE = '(';
    private static final char TKN_RPAREN_VALUE = ')';
    private static final char TKN_COMMA_VALUE = ',';
    private static final char TKN_EQUAL_VALUE = '=';
    private static final char TKN_BKSLASH_VALUE = '\\';
    private static final char TKN_DQUOTE_VALUE = '\"';
    private static final char TKN_SQUOTE_VALUE = '\'';
    private static final char TKN_EOS_VALUE = '%';
    private static final char TKN_SPC_VALUE = ' ';
    private static final char TKN_TAB_VALUE = '\t';
    private static final char TKN_LF_VALUE = '\n';
    private static final char TKN_CR_VALUE = '\r';
    private Vector _tkType = null;
    private Vector _tkValue = null;
    private int _numTokens = 0;
    private int _tkPos = 0;

    private static boolean _isWhiteSpace(char it) {
        return it == ' ' || it == '\t' || it == '\n' || it == '\r';
    }

    private static String _trimWhiteSpace(String it) {
        int length = it.length();
        int start = 0;
        int end = length;
        while (start < length && NVTokens._isWhiteSpace(it.charAt(start))) {
            ++start;
        }
        while (start < end && NVTokens._isWhiteSpace(it.charAt(end - 1))) {
            --end;
        }
        return it.substring(start, end);
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseTokens(String nvString) {
        this._numTokens = 0;
        this._tkPos = 0;
        this._tkType = new Vector<E>(25, 25);
        this._tkValue = new Vector<E>(25, 25);
        len = nvString.length();
        input = nvString.toCharArray();
        pos = 0;
        ** GOTO lbl56
        {
            ++pos;
            do {
                if (pos < len && NVTokens._isWhiteSpace(input[pos])) continue block6;
                switch (input[pos]) {
                    case '(': {
                        this._addToken(1, '(');
                        ++pos;
                        break;
                    }
                    case '=': {
                        this._addToken(4, '=');
                        ++pos;
                        break;
                    }
                    case ')': {
                        this._addToken(2, ')');
                        ++pos;
                        break;
                    }
                    case ',': {
                        this._addToken(3, ',');
                        ++pos;
                        break;
                    }
                    default: {
                        startPos = pos;
                        endPos = -1;
                        quoted_str = false;
                        quote_char = '\"';
                        if (input[pos] == '\'' || input[pos] == '\"') {
                            quoted_str = true;
                            quote_char = input[pos];
                            ++pos;
                        }
                        while (pos < len) {
                            if (input[pos] == '\\') {
                                pos += 2;
                                continue;
                            }
                            if (quoted_str) {
                                if (input[pos] == quote_char) {
                                    endPos = ++pos;
                                    break;
                                }
                            } else if (input[pos] == '(' || input[pos] == ')' || input[pos] == ',' || input[pos] == '=') {
                                endPos = pos;
                                break;
                            }
                            ++pos;
                        }
                        if (endPos == -1) {
                            endPos = pos;
                        }
                        this._addToken(8, NVTokens._trimWhiteSpace(nvString.substring(startPos, endPos)));
                        break;
                    }
                }
lbl56:
                // 6 sources

            } while (pos < len);
        }
        this._addToken(9, '%');
        return true;
    }

    public int getToken() {
        if (this._tkType == null) {
            return -1;
        }
        if (this._tkPos < this._numTokens) {
            return (Integer)this._tkType.elementAt(this._tkPos);
        }
        return 0;
    }

    public int popToken() {
        int token = 0;
        if (this._tkType == null) {
            token = -1;
        } else if (this._tkPos < this._numTokens) {
            token = (Integer)this._tkType.elementAt(this._tkPos++);
        }
        return token;
    }

    public String getLiteral() {
        String theLiteral = null;
        if (this._tkValue != null && this._tkPos < this._numTokens) {
            theLiteral = (String)this._tkValue.elementAt(this._tkPos);
        }
        return theLiteral;
    }

    public String popLiteral() {
        String theLiteral = null;
        if (this._tkValue != null && this._tkPos < this._numTokens) {
            theLiteral = (String)this._tkValue.elementAt(this._tkPos++);
        }
        return theLiteral;
    }

    public void eatToken() {
        if (this._tkPos < this._numTokens) {
            ++this._tkPos;
        }
    }

    public String toString() {
        if (this._tkType == null) {
            return "*NO TOKENS*";
        }
        String out = "Tokens";
        int i = 0;
        while (i < this._numTokens) {
            out = String.valueOf(out) + " : " + this._tkValue.elementAt(i);
            ++i;
        }
        return out;
    }

    public void println() {
        System.out.println(this.toString());
    }

    private void _addToken(int tk, char tk_char) {
        this._addToken(tk, String.valueOf(tk_char));
    }

    private void _addToken(int tk, String tk_val) {
        this._tkType.addElement(new Integer(tk));
        this._tkValue.addElement(tk_val);
        ++this._numTokens;
    }
}

