/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.shuttle.ListPicker;
import oracle.ewt.shuttle.MultiItemPicker;
import oracle.ewt.shuttle.Shuttle;
import oracle.ewt.shuttle.ToMultiItemPicker;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.ca.CAWizardPanel;
import oracle.net.ca.NetStrings;

public class CAPanelListenerProtocols
extends EwtContainer
implements CAWizardPanel {
    private boolean guiInitialized = false;
    private Component invalidComponent;
    static final NetStrings netstr = new NetStrings();
    String[] SelectedProtocols;
    LWList toList;
    LWList fromList;
    String installedProtocols;
    String prefferedProtocol;

    public CAPanelListenerProtocols(String instPrtcls, String prefPrtcl) {
        this.installedProtocols = instPrtcls;
        this.prefferedProtocol = prefPrtcl;
    }

    public boolean isValid() {
        return true;
    }

    public void explainError() {
    }

    public void focusOnInvalidField() {
    }

    public void reset() {
    }

    public String[] getSelectedProtocols() {
        return this.toList.getItems();
    }

    public int getSelectedProtocolsNum() {
        return this.toList.getItemCount();
    }

    public void buildGUI() {
        if (this.guiInitialized) {
            return;
        }
        this.guiInitialized = true;
        MultiLineLabel label = new MultiLineLabel(WordWrapper.getTextWrapper(), netstr.getString("LIprtcl"));
        label.setPreferredAspectRatio(6.0f);
        Shuttle shuttle = new Shuttle();
        shuttle.setMoveAllAllowed(false);
        this.buildShuttleFromList(shuttle);
        this.buildShuttleToList(shuttle);
        GridBagConstraints gbc = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        gbc.insets = new Insets(3, 1, 3, 1);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        ((Container)((Object)this)).add((Component)label, gbc);
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        ((Container)((Object)this)).add((Component)shuttle, gbc);
    }

    private void buildShuttleFromList(Shuttle shuttle) {
        this.fromList = new LWList(3, true);
        StringTokenizer st = new StringTokenizer(this.installedProtocols, ",");
        while (st.hasMoreTokens()) {
            this.fromList.add(st.nextToken().toUpperCase());
        }
        ListPicker fromPicker = new ListPicker(this.fromList);
        fromPicker.setSortItems(false);
        shuttle.setFromPicker((MultiItemPicker)fromPicker);
        shuttle.setFromHeader((Component)new LWLabel(netstr.getString("LIfromHeader")));
    }

    private void buildShuttleToList(Shuttle shuttle) {
        this.toList = new LWList(3, true);
        String selPrtcl = this.prefferedProtocol;
        this.toList.add(selPrtcl);
        try {
            this.fromList.remove(selPrtcl);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
        }
        ListPicker toPicker = new ListPicker(this.toList);
        toPicker.setSortItems(false);
        shuttle.setToPicker((ToMultiItemPicker)toPicker);
        shuttle.setToHeader((Component)new LWLabel(netstr.getString("LItoHeader")));
    }
}

