/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.net.ca.IllegalOptionException;
import oracle.net.ca.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.common.NetProperties;

public class CmdlineArgs {
    private Hashtable vars;
    private NetProperties NetProp;
    final NetStrings netstr = new NetStrings();
    private boolean standAlone;

    public CmdlineArgs() {
        this.vars = new Hashtable(20);
    }

    void initArgs() {
        this.addBooleanArgs("silent");
        this.addStringArgs("instype", "NO_VALUE");
        this.addStringArgs("inscomp", "server");
        this.addStringArgs("insprtcl", "tcp");
        this.addStringArgs("orahid", "NO_VALUE");
        this.addStringArgs("orahnam", "NO_VALUE");
        this.addStringArgs("orahome", "NO_VALUE");
        this.addStringArgs("cfg", "local");
        this.addStringArgs("authadp", "NO_VALUE");
    }

    public void setStandAlone(boolean status) {
        this.standAlone = status;
    }

    public boolean getStandAlone() {
        return this.standAlone;
    }

    public void setOraArgs() {
        if (this.getStringArgs("orahome").equals("NO_VALUE")) {
            this.addStringArgs("orahome", NetGetEnv.getOracleHome());
        }
    }

    void saveParameters() {
        try {
            this.NetProp = NetProperties.getInstance();
        }
        catch (IOException e) {
            System.err.println(String.valueOf(this.netstr.getString("SOCreatePropertiesIO")) + e.getMessage());
        }
        this.NetProp.putProperty("INSTALLEDCOMPONENTS", this.getStringArgs("inscomp").toUpperCase());
        try {
            this.NetProp.save();
        }
        catch (IOException e) {
            System.err.println(String.valueOf(this.netstr.getString("SOSavePropertiesIO")) + e.getMessage());
        }
    }

    void addStringArgs(String name, String defaultValue) {
        this.vars.put(name, defaultValue);
    }

    void addNumberArgs(String name, int defaultValue) {
        this.vars.put(name, new Integer(defaultValue));
    }

    void addBooleanArgs(String name) {
        this.vars.put(name, new Boolean(false));
    }

    String getStringArgs(String name) {
        String s = (String)this.vars.get(name);
        return s;
    }

    int getNumberArgs(String name) {
        return (Integer)this.vars.get(name);
    }

    boolean getBooleanArgs(String name) {
        return (Boolean)this.vars.get(name);
    }

    boolean getInsComponent(String comp) {
        String token = null;
        StringTokenizer st = new StringTokenizer(this.getStringArgs("inscomp"), ",");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!token.equals(comp)) continue;
            return true;
        }
        return false;
    }

    void addInsComponent(String newComp) {
        if (!this.getInsComponent(newComp)) {
            String comps = this.getStringArgs("inscomp");
            this.addStringArgs("inscomp", String.valueOf(comps) + "," + newComp);
        }
    }

    void removeInsComponent(String rmComp) {
        String token = null;
        StringBuffer newArgs = new StringBuffer();
        if (!this.getInsComponent(rmComp)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.getStringArgs("inscomp"), ",");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals(rmComp)) continue;
            newArgs.append(String.valueOf(token) + ",");
        }
        token = newArgs.toString();
        this.addStringArgs("inscomp", token.substring(0, token.length() - 1));
    }

    public String getPrefPrtcl() {
        Object token = null;
        String line = null;
        String insPrtcl = null;
        StringTokenizer st = new StringTokenizer(this.getStringArgs("insprtcl"), ",");
        while (st.hasMoreTokens()) {
            insPrtcl = st.nextToken();
            int i = 1;
            while (this.NetProp.getProperty("p" + i) != null) {
                line = "p" + i;
                if (this.NetProp.getProperty(line).equalsIgnoreCase(insPrtcl)) {
                    return insPrtcl.toUpperCase();
                }
                ++i;
            }
        }
        return "TCP";
    }

    void parseArgs(String[] args) throws IllegalOptionException {
        CmdlineArgs cmdargs = new CmdlineArgs();
        int n = 0;
        while (n < args.length) {
            String s;
            if ((s = args[n++]).charAt(0) != '/') {
                throw new IllegalOptionException(String.valueOf(this.netstr.getString("SOParamMissing")) + s);
            }
            Object cmdarg = this.vars.get(s = s.substring(1).toLowerCase());
            if (cmdarg instanceof Boolean) {
                System.out.println(String.valueOf(this.netstr.getString("SOParamParam")) + "\"" + s + "\" = " + new Boolean(true));
                this.vars.put(s, new Boolean(true));
                continue;
            }
            if (cmdarg instanceof Integer) {
                int val;
                try {
                    val = Integer.parseInt(args[n++]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalOptionException("invalid number argument for " + s);
                }
                System.out.println(String.valueOf(this.netstr.getString("SOParamParam")) + "\"" + s + "\" = " + new Integer(val));
                this.vars.put(s, new Integer(val));
                continue;
            }
            System.out.println(String.valueOf(this.netstr.getString("SOParamParam")) + "\"" + s + "\" = " + args[n]);
            this.vars.put(s, args[n++]);
        }
    }

    void printArgs() {
        System.out.println("silent: " + this.getBooleanArgs("silent"));
        System.out.println("instype: " + this.getStringArgs("instype"));
        System.out.println("inscomp: " + this.getStringArgs("inscomp"));
        System.out.println("insprtcl: " + this.getStringArgs("insprtcl"));
        System.out.println("orahid: " + this.getStringArgs("orahid"));
        System.out.println("orahnam: " + this.getStringArgs("orahnam"));
        System.out.println("orahome: " + this.getStringArgs("orahome"));
        System.out.println("cfg: " + this.getStringArgs("cfg"));
        System.out.println("authadp: " + this.getStringArgs("authadp"));
    }
}

