/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.NetStrings;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;

public class ConfigureLDAP {
    public Config config;
    private String DSaddr;
    private String DStype;
    private String namingContext;
    private String[] userCredentials = new String[2];
    int authMethod;
    String oraHome;
    final NetStrings netstr = new NetStrings();

    public void initConfig(CmdlineArgs arg, String[] credentials) {
        this.authMethod = 1;
        this.userCredentials[0] = null;
        this.userCredentials[1] = null;
        this.oraHome = arg.getStringArgs("orahome");
        try {
            this.config = new Config(this.oraHome, this.authMethod, this.userCredentials);
        }
        catch (ConfigException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExCreate")) + (Object)((Object)e));
        }
        this.config.netConfigUsesLDAP(false);
    }

    public void getDirectoryServerType() {
        this.DStype = Config.detectDSType((String)this.DSaddr);
        if (this.DStype == null) {
            this.DStype = "ODS";
        }
    }

    public String[] getNamingContextList() {
        return Config.getNamingContexts((String)this.DSaddr, (String)this.DStype);
    }

    public String[] getNamingSubContextList(String context) {
        return Config.getSubContexts((String)this.DSaddr, (String)this.DStype, (String)context);
    }

    public void setDirectoryHost(String addr) {
        this.DSaddr = addr;
    }

    public void setNamingContext(String context) {
        this.namingContext = context;
    }

    public void setCredentials(String username, String password) {
        this.userCredentials[0] = username;
        this.userCredentials[1] = password;
        if (this.userCredentials[0] == "") {
            this.userCredentials[0] = null;
        }
        if (this.userCredentials[1] == "") {
            this.userCredentials[1] = null;
        }
    }

    public void initLDAP(CmdlineArgs arg) {
        String OracleHomeName = arg.getStringArgs("orahnam");
        String OracleHomeID = arg.getStringArgs("orahid");
        if (OracleHomeName == "NO_VALUE") {
            OracleHomeName = null;
        }
        if (OracleHomeID == "NO_VALUE") {
            OracleHomeID = null;
        }
        try {
            Config.init((String)arg.getStringArgs("orahome"), (String)OracleHomeName, (String)OracleHomeID, (boolean)false, (String)this.DStype, (String)this.DSaddr, (boolean)false, (String)this.namingContext, (int)1, (String[])this.userCredentials);
        }
        catch (ConfigException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExInit")) + e.getMessage());
        }
    }

    public void reCreateConfig(CmdlineArgs arg) {
        try {
            this.config = new Config(this.oraHome, this.authMethod, this.userCredentials);
        }
        catch (ConfigException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExCreate")) + (Object)((Object)e));
        }
    }

    public void saveLDAP() {
        try {
            this.config.save();
        }
        catch (ConfigException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExSave")) + e.getMessage());
        }
    }
}

