/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.net.ca.CAWizardUtils;
import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.config.Config;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.Listener;
import oracle.net.config.ListenerException;
import oracle.net.config.SOExceptionConfig;

public class ConfigureListener {
    private Listener listener;
    private int ADDR_NUM = 10;
    private int currAddr;
    private String sidDesc;
    private String TCPort;
    private String TCPortIIOP;
    private String SPXname;
    private String NMPipe;
    private String hostname;
    private String compname;
    private String[] addressDescriptions;
    private String firstListener;
    private String currListener;
    private boolean enableIIOP = false;
    private NetGetEnv env = new NetGetEnv();
    final NetStrings netstr = new NetStrings();

    public void silentConfigure(CmdlineArgs arg, Config config) {
        this.initListener(arg, config, "LISTENER");
        this.buildAddressIPC();
        this.setTCPort("1521");
        this.setSPXname(String.valueOf(this.compname) + "_lsnr");
        this.setNMPipe("ORAPIPE");
        String prefProtocol = arg.getPrefPrtcl();
        if (arg.getInsComponent("javavm") && prefProtocol.equalsIgnoreCase("tcp")) {
            this.setTCPortIIOP("2481");
        }
        this.buildAddress(arg, prefProtocol);
        this.addAddressToListener(config);
        this.addSIDescription(arg);
        this.saveListener(config);
        System.out.println(this.netstr.getString("SOListenerComplete"));
    }

    public void initListener(CmdlineArgs arg, Config config, String lName) {
        this.currAddr = 0;
        this.NMPipe = null;
        this.SPXname = null;
        this.TCPortIIOP = null;
        this.TCPort = null;
        this.sidDesc = null;
        this.currListener = null;
        this.firstListener = null;
        this.addressDescriptions = new String[this.ADDR_NUM];
        this.enableIIOP = false;
        this.hostname = CAWizardUtils.getHostName();
        this.compname = NetGetEnv.getComputerName();
        if (this.compname == null) {
            this.compname = this.hostname;
        }
        this.currListener = lName;
        try {
            this.listener = new Listener(config, lName);
        }
        catch (ListenerException listenerException) {
            System.out.println(this.netstr.getString("SOListenerExCreate"));
        }
    }

    public void buildAddressIPC() {
        String[][] valpair0 = new String[][]{{"KEY", null, null}, {"EXTPROC0", null, null}};
        this.addressDescriptions[this.currAddr++] = this.buildAddressString("IPC", valpair0);
    }

    public void buildAddress(CmdlineArgs arg, String prtcl) {
        String[][] valpair1;
        if (prtcl.equals("TCP")) {
            if (this.TCPort != null) {
                valpair1 = new String[][]{{"HOST", "PORT", null}, {this.hostname, this.TCPort, null}};
                this.addressDescriptions[this.currAddr++] = this.buildAddressString(prtcl, valpair1);
            }
            if (this.TCPortIIOP != null) {
                this.enableIIOP = true;
            }
        }
        if (prtcl.equals("SPX")) {
            valpair1 = new String[][]{{"SERVICE", null, null}, {this.SPXname, null, null}};
            this.addressDescriptions[this.currAddr++] = this.buildAddressString(prtcl, valpair1);
        }
        if (prtcl.equals("NMP")) {
            valpair1 = new String[][]{{"SERVER", "PIPE", null}, {this.compname, this.NMPipe, null}};
            this.addressDescriptions[this.currAddr++] = this.buildAddressString(prtcl, valpair1);
        }
    }

    private String buildAddressString(String prtcl, String[][] valpair) {
        String addr_list = "(ADDRESS_LIST=(ADDRESS=(PROTOCOL=" + prtcl + ")";
        int i = 0;
        while (valpair[0][i] != null) {
            addr_list = String.valueOf(addr_list) + "(" + valpair[0][i] + "=" + valpair[1][i] + ")";
            ++i;
        }
        addr_list = String.valueOf(addr_list) + "))";
        return addr_list;
    }

    public void addAddressToListener(Config config) {
        Vector<DescriptionListConfig> addressList = new Vector<DescriptionListConfig>();
        String desc_list = "(DESCRIPTION_LIST=(DESCRIPTION=";
        int i = 0;
        while (i < this.ADDR_NUM && this.addressDescriptions[i] != null) {
            desc_list = String.valueOf(desc_list) + this.addressDescriptions[i];
            ++i;
        }
        desc_list = this.enableIIOP ? String.valueOf(desc_list) + ")(DESCRIPTION=(PROTOCOL_STACK=(PRESENTATION=GIOP)(SESSION=RAW))(ADDRESS=(PROTOCOL=TCP)(HOST=" + this.hostname + ")(PORT=" + this.TCPortIIOP + "))))" : String.valueOf(desc_list) + "))";
        try {
            DescriptionListConfig address = new DescriptionListConfig(desc_list, null);
            addressList.addElement(address);
            this.listener.setEndpoints(addressList);
        }
        catch (SOExceptionConfig e) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExSO")) + desc_list + e.getMessage());
        }
        catch (ListenerException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExAddAddr")) + desc_list + e.getMessage());
        }
    }

    public void addSIDescription(CmdlineArgs arg) {
        String[][] valpair = new String[][]{{"SID_NAME", "ORACLE_HOME", "PROGRAM", null}, {"PLSExtProc", arg.getStringArgs("orahome"), "extproc", null}};
        String address = "(SID_DESC=";
        int i = 0;
        while (valpair[0][i] != null) {
            address = String.valueOf(address) + "(" + valpair[0][i] + "=" + valpair[1][i] + ")";
            ++i;
        }
        address = String.valueOf(address) + ")";
        this.listener.addSidDesc(address, true);
    }

    public boolean startListener(CmdlineArgs arg) {
        if (!arg.getStandAlone() && this.firstListener != null) {
            return this.startListener(arg, this.firstListener);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean startListener(CmdlineArgs arg, String ListenerName) {
        exitStatus = 1;
        System.out.println(this.netstr.getString("SOListenerStart"));
        cmdLine1 = String.valueOf(arg.getStringArgs("orahome")) + File.separator + "bin" + File.separator + "lsnrctl start " + ListenerName;
        System.out.println(String.valueOf(this.netstr.getString("SORunListenerStartCtl")) + cmdLine1);
        try {
            runtime = Runtime.getRuntime();
            process = runtime.exec(cmdLine1);
            inputStream = new BufferedInputStream(process.getInputStream());
            errorStream = new BufferedInputStream(process.getErrorStream());
            done = false;
            ** GOTO lbl31
            {
                inputStream.read();
                do {
                    if (inputStream.available() > 0) continue block6;
                    while (errorStream.available() > 0) {
                        errorStream.read();
                    }
                    done = true;
                    try {
                        exitStatus = process.exitValue();
                        System.out.println(this.netstr.getString("SOListenerStartCtlComp"));
                        if (exitStatus == 0) {
                            System.out.println(this.netstr.getString("SOListenerStartSuccess"));
                            continue;
                        }
                        System.out.println(this.netstr.getString("SOListenerStartFail"));
                    }
                    catch (IllegalThreadStateException v0) {
                        done = false;
                    }
lbl31:
                    // 4 sources

                } while (!done);
            }
            inputStream.close();
            errorStream.close();
        }
        catch (IOException v1) {
            System.out.println(this.netstr.getString("SOListenerExControl"));
        }
        os = System.getProperty("os.name");
        if (exitStatus == 0 && os.equals("Windows NT")) {
            cmdLine2 = arg.getStringArgs("orahnam").equals("no_value") != false ? String.valueOf(arg.getStringArgs("orahome")) + File.separator + "bin" + File.separator + "lsnrauto" : String.valueOf(arg.getStringArgs("orahome")) + File.separator + "bin" + File.separator + "lsnrauto " + arg.getStringArgs("orahnam");
            System.out.println(this.netstr.getString("SOListenerStartAuto"));
            try {
                runtime = Runtime.getRuntime();
                process = runtime.exec(cmdLine2);
            }
            catch (IOException v2) {
                System.out.println(String.valueOf(this.netstr.getString("SOListenerExAuto")) + cmdLine2);
            }
        }
        return exitStatus == 0;
    }

    public void saveListener(Config config) {
        try {
            this.listener.save(config, true);
        }
        catch (ListenerException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExSave")) + e.getMessage());
        }
        if (this.firstListener == null) {
            this.firstListener = this.currListener;
        }
    }

    public void setTCPort(String portNum) {
        this.TCPort = portNum;
    }

    public void setTCPortIIOP(String portNum) {
        this.TCPortIIOP = portNum;
    }

    public void setSPXname(String servName) {
        this.SPXname = servName;
    }

    public void setNMPipe(String pipeName) {
        this.NMPipe = pipeName;
    }
}

