/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import oracle.net.ca.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.config.Config;
import oracle.net.config.Profile;
import oracle.net.config.ProfileException;

public class ConfigureProfile {
    private Profile profile;
    private String os = System.getProperty("os.name");
    private NetGetEnv env = new NetGetEnv();
    final NetStrings netstr = new NetStrings();

    public void silentConfigure(Config config) {
        this.initProfile(config);
        this.setDefaultProfileParameters();
        this.saveProfile(config);
        System.out.println(this.netstr.getString("SOProfileComplete"));
    }

    public void setDefaultProfileParameters() {
        String domain = NetGetEnv.getDNSDomain();
        if (domain != null) {
            this.setProfileParam("NAMES.DEFAULT_DOMAIN", NetGetEnv.getDNSDomain());
        } else {
            this.setProfileParam("NAMES.DEFAULT_DOMAIN", "");
        }
        if (this.os.equals("Windows NT") || this.os.equals("Windows 95") || this.os.equals("Windows 98")) {
            this.setProfileParam("SQLNET.AUTHENTICATION_SERVICES", "(NTS)");
        }
    }

    public void initProfile(Config config) {
        try {
            this.profile = new Profile(config, false, "");
        }
        catch (ProfileException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOProfileExCreate")) + e.getMessage());
        }
    }

    public String getProfileParam(String name) {
        return this.profile.getParameter(name);
    }

    public void setProfileParam(String name, String value) {
        this.profile.setParameter(name, value);
    }

    public void saveProfile(Config config) {
        try {
            this.profile.save(config, true);
        }
        catch (ProfileException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOProfileExSave")) + e.getMessage());
        }
    }
}

