/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.config.Config;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;
import oracle.net.nl.NLException;

public class ConfigureServiceAlias {
    private DescriptionConfig desc;
    private Vector endpoints;
    private ServiceAlias alias;
    private Config config;
    private String shortName;
    private String fullName;
    private NetGetEnv env = new NetGetEnv();
    final NetStrings netstr = new NetStrings();

    public ConfigureServiceAlias(Config cfg) {
        this.config = cfg;
    }

    public void silentConfigure(CmdlineArgs cmdarg) {
        String domain = NetGetEnv.getDNSDomain();
        if (domain != null) {
            this.initAlias("extproc_connection_data." + domain);
        } else {
            this.initAlias("extproc_connection_data");
        }
        if (cmdarg.getInsComponent("server")) {
            String descExtProc = "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=IPC)(KEY=EXTPROC0)))(CONNECT_DATA=(SID=PLSExtProc)(PRESENTATION=RO)))";
            this.addDescription(descExtProc);
            this.addEndpoints();
        }
        this.saveAlias();
        System.out.println(this.netstr.getString("SOLocalAliasComplete"));
    }

    public void addDescription(String descText) {
        try {
            this.desc.initFromString(descText);
            this.endpoints.addElement(this.desc);
        }
        catch (NLException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExInit")) + e.getMessage());
        }
        catch (SOException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExInit")) + e.getMessage());
        }
    }

    public void addEndpoints() {
        try {
            this.alias.setEndpoints(this.endpoints);
        }
        catch (ServiceAliasException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExEndp")) + e.getMessage());
        }
    }

    public void initAlias(String name) {
        SchemaObjectConfigFactory factory = new SchemaObjectConfigFactory();
        this.endpoints = new Vector();
        try {
            this.alias = new ServiceAlias(this.config, name);
            this.desc = (DescriptionConfig)factory.create(2);
        }
        catch (ServiceAliasException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExInit")) + e.getMessage());
        }
    }

    public void saveAlias() {
        try {
            this.alias.save(this.config, true);
        }
        catch (ServiceAliasException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExSave")) + e.getMessage());
        }
    }

    public String[] getNetServiceNames() {
        String[] nsnames = null;
        try {
            nsnames = ServiceAlias.enum((Config)this.config, null, (boolean)false);
        }
        catch (ServiceAliasException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExEnum")) + e.getMessage());
        }
        if (nsnames.length == 0) {
            return null;
        }
        return nsnames;
    }

    public void deleteNetServiceName(String name) {
        try {
            ServiceAlias.delete((Config)this.config, (String)name);
        }
        catch (ServiceAliasException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExDelete")) + name + e.getMessage());
        }
        System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasDelete")) + name);
    }

    public void renameNetServiceName(String oldName, String newName) {
        try {
            this.alias.saveAs(this.config, true, newName);
            ServiceAlias.delete((Config)this.config, (String)oldName);
        }
        catch (ServiceAliasException e) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExRename")) + oldName + e.getMessage());
        }
        System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasRename")) + oldName);
    }

    public String getNSNshortName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        return st.nextToken();
    }

    public String getNSNfullName(String fullName, String dfltDomain) {
        String shortName = null;
        Object token = null;
        String dnsDomain = null;
        dnsDomain = dfltDomain == null || dfltDomain == "" ? NetGetEnv.getDNSDomain() : dfltDomain;
        StringTokenizer st = new StringTokenizer(fullName, ".", true);
        shortName = st.nextToken();
        if (!st.hasMoreTokens()) {
            if (dnsDomain != null) {
                return String.valueOf(shortName) + "." + dnsDomain;
            }
            return shortName;
        }
        if (st.hasMoreTokens()) {
            return fullName;
        }
        return shortName;
    }
}

