/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.net.common.NetGetEnv;

public class NetProperties {
    private static final char SEP = File.separatorChar;
    private static NetProperties instance;
    private Properties netProperties = new Properties();
    private FileInputStream inpFile;
    private String fileName = NetGetEnv.getOracleHome();

    public static NetProperties getInstance() throws FileNotFoundException, IOException {
        if (instance == null) {
            instance = new NetProperties();
        }
        return instance;
    }

    private NetProperties() throws FileNotFoundException, IOException {
        int i = this.fileName.length() - 1;
        while (i >= 0) {
            if (this.fileName.charAt(i) != SEP) break;
            --i;
        }
        this.fileName = String.valueOf(this.fileName.substring(0, i + 1)) + SEP + "network" + SEP + "tools" + SEP + "NetProperties";
        this.inpFile = new FileInputStream(this.fileName);
        this.netProperties.load(this.inpFile);
    }

    public String getProperty(String key) {
        return this.netProperties.getProperty(key);
    }

    public void putProperty(String key, String value) {
        ((Hashtable)this.netProperties).put(key, value);
    }

    public void save() throws FileNotFoundException, IOException {
        FileOutputStream outFile = new FileOutputStream(this.fileName);
        this.netProperties.save(outFile, null);
    }
}

