
#include <Python.h>
#include <stdio.h>
#include <math.h>
#include "libnumarray.h"

#ifdef MS_WIN32
#pragma warning(once : 4244)
#endif

#define logical_and(arg1, arg2) (arg1 != 0) & (arg2 != 0)
#define logical_or(arg1, arg2)  (arg1 != 0) | (arg2 != 0)
#define logical_xor(arg1, arg2) ((arg1 != 0) ^ (arg2 != 0)) & 1
#define ufmaximum(arg1, arg2) (((temp1=arg1) > (temp2=arg2)) ? temp1 : temp2)
#define ufminimum(arg1, arg2) (((temp1=arg1) < (temp2=arg2)) ? temp1 : temp2)

static PyObject *_Error;

/*********************  minus  *********************/

static int minus_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    UInt8 *tout = (UInt8 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = -*tin;
    }
    return 0;
}

UFUNC_DESCR2(minus_UInt8_vector, sizeof(UInt8), sizeof(UInt8));
/*********************  add  *********************/

static int add_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 + *tin2;
    }
    return 0;
}

UFUNC_DESCR3(add_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int add_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 + tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(add_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int add_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar + *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(add_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int add_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval + *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int add_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = net + *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  subtract  *********************/

static int subtract_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 - *tin2;
    }
    return 0;
}

UFUNC_DESCR3(subtract_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int subtract_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 - tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(subtract_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int subtract_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar - *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(subtract_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int subtract_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval - *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int subtract_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = net - *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  multiply  *********************/
/*********************  multiply  *********************/

static int multiply_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    Int32 temp;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        temp = ((Int32) *tin1) * ((Int32) *tin2);
    if (temp > 255) temp = int_overflow_error(255.);
    *tout = (UInt8) temp;
    }
    return 0;
}

UFUNC_DESCR3(multiply_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int multiply_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    Int32 temp;
    for (i=0; i<niter; i++, tin1++, tout++) {
        temp = ((Int32) *tin1) * ((Int32) tscalar);
    if (temp > 255) temp = int_overflow_error(255.);
    *tout = (UInt8) temp;
    }
    return 0;
}

UFUNC_DESCR3vs(multiply_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int multiply_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    Int32 temp;
    for (i=0; i<niter; i++, tin2++, tout++) {
        temp = ((Int32) tscalar) * ((Int32) *tin2);
    if (temp > 255) temp = int_overflow_error(255.);
    *tout = (UInt8) temp;
    }
    return 0;
}

UFUNC_DESCR3sv(multiply_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int multiply_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    Int32 temp;
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            temp = ((Int32) lastval) * ((Int32) *tin);
    if (temp > 255) temp = int_overflow_error(255.);
    *tout = (UInt8) temp;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int multiply_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    Int32 temp;
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            temp = ((Int32) net) * ((Int32) *tin);
    if (temp > 255) temp = int_overflow_error(255.);
    net = (UInt8) temp;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/

static int divide_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1 / *tin2);
    }
    return 0;
}

UFUNC_DESCR3(divide_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int divide_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1 / tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(divide_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int divide_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar / *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(divide_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int divide_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : lastval / *tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int divide_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : net / *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  divide  *********************/
/*********************  floor_divide  *********************/

static int floor_divide_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : floor(*tin1 / (double) *tin2));
    }
    return 0;
}

UFUNC_DESCR3(floor_divide_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int floor_divide_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : floor(*tin1 / (double) tscalar));
    }
    return 0;
}

UFUNC_DESCR3vs(floor_divide_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int floor_divide_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : floor(tscalar / (double) *tin2));
    }
    return 0;
}

UFUNC_DESCR3sv(floor_divide_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int floor_divide_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : floor(lastval / (double) *tin));
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            floor_divide_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(floor_divide_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int floor_divide_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : floor(net / (double) *tin));
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            floor_divide_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(floor_divide_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  floor_divide  *********************/
/*********************  true_divide  *********************/

static int true_divide_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1 / (double) *tin2);
    }
    return 0;
}

UFUNC_DESCR3(true_divide_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));


static int true_divide_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Float32 *tout    = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1 / (double) tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(true_divide_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));


static int true_divide_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar / (double) *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(true_divide_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));

/*********************  true_divide  *********************/
/*********************  remainder  *********************/

static int remainder_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1  %  *tin2);
    }
    return 0;
}

UFUNC_DESCR3(remainder_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int remainder_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1  %  tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(remainder_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int remainder_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar  %  *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(remainder_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int remainder_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : lastval  %  *tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int remainder_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : net  %  *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  remainder  *********************/
/*********************  power  *********************/

static int power_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = num_pow(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(power_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int power_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = num_pow(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(power_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int power_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = num_pow(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(power_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int power_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = num_pow(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int power_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = num_pow(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  abs  *********************/

static int abs_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    UInt8 *tout = (UInt8 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = fabs(*tin);
    }
    return 0;
}

UFUNC_DESCR2(abs_UInt8_vector, sizeof(UInt8), sizeof(UInt8));
/*********************  sin  *********************/

static int sin_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sin(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sin_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  cos  *********************/

static int cos_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = cos(*tin);
    }
    return 0;
}

UFUNC_DESCR2(cos_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  tan  *********************/

static int tan_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = tan(*tin);
    }
    return 0;
}

UFUNC_DESCR2(tan_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  arcsin  *********************/

static int arcsin_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = asin(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arcsin_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  arccos  *********************/

static int arccos_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = acos(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arccos_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  arctan  *********************/

static int arctan_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = atan(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arctan_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  arctan2  *********************/

static int arctan2_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = atan2(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(arctan2_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));


static int arctan2_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Float32 *tout    = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = atan2(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(arctan2_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));


static int arctan2_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = atan2(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(arctan2_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));

/*********************  log  *********************/

static int log_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_log(*tin);
    }
    return 0;
}

UFUNC_DESCR2(log_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  log10  *********************/

static int log10_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_log10(*tin);
    }
    return 0;
}

UFUNC_DESCR2(log10_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  exp  *********************/

static int exp_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = exp(*tin);
    }
    return 0;
}

UFUNC_DESCR2(exp_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  sinh  *********************/

static int sinh_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sinh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sinh_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  cosh  *********************/

static int cosh_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = cosh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(cosh_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  tanh  *********************/

static int tanh_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = tanh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(tanh_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  arcsinh  *********************/

static int arcsinh_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_asinh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arcsinh_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  arccosh  *********************/

static int arccosh_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_acosh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arccosh_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  arctanh  *********************/

static int arctanh_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_atanh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arctanh_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  ieeemask  *********************/
/*********************  ieeemask  *********************/
/*********************  sqrt  *********************/

static int sqrt_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sqrt(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sqrt_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  equal  *********************/

static int equal_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 == *tin2;
    }
    return 0;
}

UFUNC_DESCR3(equal_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int equal_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 == tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(equal_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int equal_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar == *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(equal_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  not_equal  *********************/

static int not_equal_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 != *tin2;
    }
    return 0;
}

UFUNC_DESCR3(not_equal_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int not_equal_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 != tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(not_equal_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int not_equal_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar != *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(not_equal_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  greater  *********************/

static int greater_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 > *tin2;
    }
    return 0;
}

UFUNC_DESCR3(greater_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int greater_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 > tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(greater_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int greater_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar > *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(greater_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  greater_equal  *********************/

static int greater_equal_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 >= *tin2;
    }
    return 0;
}

UFUNC_DESCR3(greater_equal_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int greater_equal_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 >= tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(greater_equal_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int greater_equal_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar >= *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(greater_equal_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  less  *********************/

static int less_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 < *tin2;
    }
    return 0;
}

UFUNC_DESCR3(less_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int less_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 < tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(less_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int less_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar < *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(less_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  less_equal  *********************/

static int less_equal_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 <= *tin2;
    }
    return 0;
}

UFUNC_DESCR3(less_equal_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int less_equal_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 <= tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(less_equal_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int less_equal_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar <= *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(less_equal_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  logical_and  *********************/

static int logical_and_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_and(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_and_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int logical_and_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_and(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_and_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int logical_and_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_and(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_and_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  logical_or  *********************/

static int logical_or_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_or(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_or_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int logical_or_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_or(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_or_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int logical_or_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_or(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_or_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  logical_xor  *********************/

static int logical_xor_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_xor(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_xor_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int logical_xor_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_xor(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_xor_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));


static int logical_xor_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_xor(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_xor_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Bool));

/*********************  logical_not  *********************/

static int logical_not_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = !*tin;
    }
    return 0;
}

UFUNC_DESCR2(logical_not_UInt8_vector, sizeof(UInt8), sizeof(Bool));
/*********************  bitwise_and  *********************/

static int bitwise_and_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 & *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_and_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_and_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 & tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_and_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_and_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar & *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_and_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_and_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval & *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_and_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_and_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int bitwise_and_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = net & *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_and_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_and_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  bitwise_or  *********************/

static int bitwise_or_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 | *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_or_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_or_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 | tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_or_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_or_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar | *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_or_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_or_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval | *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_or_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_or_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int bitwise_or_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = net | *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_or_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_or_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  bitwise_xor  *********************/

static int bitwise_xor_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 ^ *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_xor_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_xor_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 ^ tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_xor_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_xor_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar ^ *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_xor_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int bitwise_xor_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval ^ *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_xor_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_xor_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int bitwise_xor_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = net ^ *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_xor_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_xor_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  bitwise_not  *********************/

static int bitwise_not_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    UInt8 *tout = (UInt8 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = ~*tin;
    }
    return 0;
}

UFUNC_DESCR2(bitwise_not_UInt8_vector, sizeof(UInt8), sizeof(UInt8));
/*********************  rshift  *********************/

static int rshift_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 >> *tin2;
    }
    return 0;
}

UFUNC_DESCR3(rshift_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int rshift_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 >> tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(rshift_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int rshift_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar >> *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(rshift_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int rshift_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval >> *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            rshift_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(rshift_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int rshift_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = net >> *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            rshift_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(rshift_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  lshift  *********************/

static int lshift_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 << *tin2;
    }
    return 0;
}

UFUNC_DESCR3(lshift_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int lshift_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 << tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(lshift_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int lshift_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar << *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(lshift_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int lshift_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval << *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            lshift_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(lshift_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int lshift_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = net << *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            lshift_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(lshift_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  floor  *********************/

static int floor_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    UInt8 *tout = (UInt8 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = (*tin);
    }
    return 0;
}

UFUNC_DESCR2(floor_UInt8_vector, sizeof(UInt8), sizeof(UInt8));
/*********************  floor  *********************/
/*********************  ceil  *********************/

static int ceil_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    UInt8 *tout = (UInt8 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = (*tin);
    }
    return 0;
}

UFUNC_DESCR2(ceil_UInt8_vector, sizeof(UInt8), sizeof(UInt8));
/*********************  ceil  *********************/
/*********************  maximum  *********************/

static int maximum_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    UInt8 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ufmaximum(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(maximum_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int maximum_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    UInt8 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ufmaximum(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(maximum_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int maximum_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    UInt8 temp1, temp2;
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ufmaximum(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(maximum_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int maximum_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    UInt8 temp1, temp2;
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = ufmaximum(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int maximum_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    UInt8 temp1, temp2;
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = ufmaximum(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  minimum  *********************/

static int minimum_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    UInt8 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ufminimum(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(minimum_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int minimum_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    UInt8 *tout    = (UInt8 *) buffers[2];
    UInt8 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ufminimum(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(minimum_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int minimum_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    UInt8 *tout  = (UInt8 *) buffers[2];
    UInt8 temp1, temp2;
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ufminimum(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(minimum_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(UInt8));


static int minimum_UInt8_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8 *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout = (UInt8 *) ((char *) output + outboffset);
    UInt8 lastval;
    UInt8 temp1, temp2;
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            tout = (UInt8 *) ((char *) tout + outbstrides[dim]);
            *tout = ufminimum(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_UInt8_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_UInt8_accumulate, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));

static int minimum_UInt8_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    UInt8  *tin   = (UInt8 *) ((char *) input  + inboffset);
    UInt8 *tout  = (UInt8 *) ((char *) output + outboffset);
    UInt8 net;
    UInt8 temp1, temp2;
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (UInt8 *) ((char *) tin + inbstrides[dim]);
            net = ufminimum(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_UInt8_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_UInt8_reduce, CHECK_ALIGN, sizeof(UInt8), sizeof(UInt8));
/*********************  fabs  *********************/

static int fabs_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = fabs(*tin);
    }
    return 0;
}

UFUNC_DESCR2(fabs_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  _round  *********************/

static int _round_UInt8_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin = (UInt8 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_round(*tin);
    }
    return 0;
}

UFUNC_DESCR2(_round_UInt8_vector, sizeof(UInt8), sizeof(Float32));
/*********************  hypot  *********************/

static int hypot_UInt8_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8  *tin1  = (UInt8 *) buffers[0];
    UInt8  *tin2  = (UInt8 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = hypot(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(hypot_UInt8_vector_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));


static int hypot_UInt8_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 *tin1     = (UInt8 *) buffers[0];
    UInt8 tscalar   = *(UInt8 *) buffers[1];
    Float32 *tout    = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = hypot(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(hypot_UInt8_vector_scalar, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));


static int hypot_UInt8_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    UInt8 tscalar = *(UInt8 *) buffers[0];
    UInt8 *tin2   =  (UInt8 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = hypot(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(hypot_UInt8_scalar_vector, sizeof(UInt8), sizeof(UInt8), sizeof(Float32));

/*********************  minus  *********************/
/*********************  add  *********************/
/*********************  subtract  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/
/*********************  true_divide  *********************/
/*********************  remainder  *********************/
/*********************  power  *********************/
/*********************  abs  *********************/
/*********************  sin  *********************/
/*********************  cos  *********************/
/*********************  tan  *********************/
/*********************  arcsin  *********************/
/*********************  arccos  *********************/
/*********************  arctan  *********************/
/*********************  arcsinh  *********************/
/*********************  arccosh  *********************/
/*********************  arctanh  *********************/
/*********************  log  *********************/
/*********************  log10  *********************/
/*********************  exp  *********************/
/*********************  sinh  *********************/
/*********************  cosh  *********************/
/*********************  tanh  *********************/
/*********************  sqrt  *********************/
/*********************  equal  *********************/
/*********************  not_equal  *********************/
/*********************  logical_and  *********************/
/*********************  logical_or  *********************/
/*********************  logical_xor  *********************/
/*********************  logical_not  *********************/
/*********************  floor  *********************/
/*********************  ceil  *********************/
/*********************  maximum  *********************/
/*********************  minimum  *********************/
/*********************  fabs  *********************/
/*********************  _round  *********************/
/*********************  hypot  *********************/

static PyMethodDef _ufuncUInt8Methods[] = {

	{NULL,      NULL}        /* Sentinel */
};

static PyObject *init_funcDict(void) {
    PyObject *dict;
    dict = PyDict_New();
    NA_add_cfunc(dict, "('minus', 'vector', (('UInt8',), ('UInt8',)))", (void *) &minus_UInt8_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &add_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &add_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('add', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &add_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('add', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &add_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('add', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &add_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &subtract_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &subtract_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('subtract', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &subtract_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &subtract_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('subtract', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &subtract_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &multiply_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &multiply_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('multiply', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &multiply_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &multiply_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('multiply', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &multiply_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('divide', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &divide_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('divide', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &divide_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('divide', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &divide_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('divide', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &divide_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('divide', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &divide_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('floor_divide', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &floor_divide_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('floor_divide', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &floor_divide_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('floor_divide', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &floor_divide_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('floor_divide', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &floor_divide_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('floor_divide', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &floor_divide_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_vector', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &true_divide_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_scalar', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &true_divide_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('true_divide', 'scalar_vector', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &true_divide_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &remainder_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &remainder_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('remainder', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &remainder_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &remainder_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('remainder', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &remainder_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('power', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &power_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('power', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &power_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('power', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &power_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('power', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &power_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('power', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &power_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('abs', 'vector', (('UInt8',), ('UInt8',)))", (void *) &abs_UInt8_vector_descr);
    NA_add_cfunc(dict, "('sin', 'vector', (('UInt8',), ('Float32',)))", (void *) &sin_UInt8_vector_descr);
    NA_add_cfunc(dict, "('cos', 'vector', (('UInt8',), ('Float32',)))", (void *) &cos_UInt8_vector_descr);
    NA_add_cfunc(dict, "('tan', 'vector', (('UInt8',), ('Float32',)))", (void *) &tan_UInt8_vector_descr);
    NA_add_cfunc(dict, "('arcsin', 'vector', (('UInt8',), ('Float32',)))", (void *) &arcsin_UInt8_vector_descr);
    NA_add_cfunc(dict, "('arccos', 'vector', (('UInt8',), ('Float32',)))", (void *) &arccos_UInt8_vector_descr);
    NA_add_cfunc(dict, "('arctan', 'vector', (('UInt8',), ('Float32',)))", (void *) &arctan_UInt8_vector_descr);
    NA_add_cfunc(dict, "('arctan2', 'vector_vector', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &arctan2_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('arctan2', 'vector_scalar', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &arctan2_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('arctan2', 'scalar_vector', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &arctan2_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('log', 'vector', (('UInt8',), ('Float32',)))", (void *) &log_UInt8_vector_descr);
    NA_add_cfunc(dict, "('log10', 'vector', (('UInt8',), ('Float32',)))", (void *) &log10_UInt8_vector_descr);
    NA_add_cfunc(dict, "('exp', 'vector', (('UInt8',), ('Float32',)))", (void *) &exp_UInt8_vector_descr);
    NA_add_cfunc(dict, "('sinh', 'vector', (('UInt8',), ('Float32',)))", (void *) &sinh_UInt8_vector_descr);
    NA_add_cfunc(dict, "('cosh', 'vector', (('UInt8',), ('Float32',)))", (void *) &cosh_UInt8_vector_descr);
    NA_add_cfunc(dict, "('tanh', 'vector', (('UInt8',), ('Float32',)))", (void *) &tanh_UInt8_vector_descr);
    NA_add_cfunc(dict, "('arcsinh', 'vector', (('UInt8',), ('Float32',)))", (void *) &arcsinh_UInt8_vector_descr);
    NA_add_cfunc(dict, "('arccosh', 'vector', (('UInt8',), ('Float32',)))", (void *) &arccosh_UInt8_vector_descr);
    NA_add_cfunc(dict, "('arctanh', 'vector', (('UInt8',), ('Float32',)))", (void *) &arctanh_UInt8_vector_descr);
    NA_add_cfunc(dict, "('sqrt', 'vector', (('UInt8',), ('Float32',)))", (void *) &sqrt_UInt8_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &equal_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &equal_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('equal', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &equal_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &not_equal_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &not_equal_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('not_equal', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &not_equal_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('greater', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &greater_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('greater', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &greater_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('greater', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &greater_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('greater_equal', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &greater_equal_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('greater_equal', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &greater_equal_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('greater_equal', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &greater_equal_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('less', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &less_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('less', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &less_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('less', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &less_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('less_equal', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &less_equal_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('less_equal', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &less_equal_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('less_equal', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &less_equal_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_and_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_and_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_and', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_and_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_or_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_or_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_or', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_or_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_xor_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_scalar', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_xor_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_xor', 'scalar_vector', (('UInt8', 'UInt8'), ('Bool',)))", (void *) &logical_xor_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_not', 'vector', (('UInt8',), ('Bool',)))", (void *) &logical_not_UInt8_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_and_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_and_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_and_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &bitwise_and_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &bitwise_and_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_or_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_or_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_or_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &bitwise_or_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &bitwise_or_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_xor_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_xor_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &bitwise_xor_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &bitwise_xor_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &bitwise_xor_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_not', 'vector', (('UInt8',), ('UInt8',)))", (void *) &bitwise_not_UInt8_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &rshift_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &rshift_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('rshift', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &rshift_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &rshift_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('rshift', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &rshift_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('lshift', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &lshift_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('lshift', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &lshift_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('lshift', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &lshift_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('lshift', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &lshift_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('lshift', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &lshift_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('floor', 'vector', (('UInt8',), ('UInt8',)))", (void *) &floor_UInt8_vector_descr);
    NA_add_cfunc(dict, "('ceil', 'vector', (('UInt8',), ('UInt8',)))", (void *) &ceil_UInt8_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &maximum_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &maximum_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('maximum', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &maximum_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &maximum_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('maximum', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &maximum_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &minimum_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_scalar', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &minimum_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('minimum', 'scalar_vector', (('UInt8', 'UInt8'), ('UInt8',)))", (void *) &minimum_UInt8_scalar_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'reduce', (('UInt8',), ('UInt8',)))", (void *) &minimum_UInt8_reduce_descr);
    NA_add_cfunc(dict, "('minimum', 'accumulate', (('UInt8',), ('UInt8',)))", (void *) &minimum_UInt8_accumulate_descr);
    NA_add_cfunc(dict, "('fabs', 'vector', (('UInt8',), ('Float32',)))", (void *) &fabs_UInt8_vector_descr);
    NA_add_cfunc(dict, "('_round', 'vector', (('UInt8',), ('Float32',)))", (void *) &_round_UInt8_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_vector', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &hypot_UInt8_vector_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_scalar', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &hypot_UInt8_vector_scalar_descr);
    NA_add_cfunc(dict, "('hypot', 'scalar_vector', (('UInt8', 'UInt8'), ('Float32',)))", (void *) &hypot_UInt8_scalar_vector_descr);
    return dict;
}

/* platform independent*/
#ifdef MS_WIN32
__declspec(dllexport)
#endif
void init_ufuncUInt8(void) {
    PyObject *m, *d;
    m = Py_InitModule("_ufuncUInt8", _ufuncUInt8Methods);
    d = PyModule_GetDict(m);
    _Error = PyErr_NewException("_ufuncUInt8.error", NULL, NULL);
    PyDict_SetItemString(d, "error", _Error);
    import_libnumarray();
    PyDict_SetItemString(d, "functionDict", init_funcDict());
}
